/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the size of files in a merge or pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSizes implements SdkPojo, Serializable, ToCopyableBuilder<FileSizes.Builder, FileSizes> {
    private static final SdkField<Long> SOURCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("source")
            .getter(getter(FileSizes::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Long> DESTINATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("destination").getter(getter(FileSizes::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Long> BASE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("base")
            .getter(getter(FileSizes::base)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, BASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long source;

    private final Long destination;

    private final Long base;

    private FileSizes(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.base = builder.base;
    }

    /**
     * <p>
     * The size of a file in the source of a merge or pull request.
     * </p>
     * 
     * @return The size of a file in the source of a merge or pull request.
     */
    public final Long source() {
        return source;
    }

    /**
     * <p>
     * The size of a file in the destination of a merge or pull request.
     * </p>
     * 
     * @return The size of a file in the destination of a merge or pull request.
     */
    public final Long destination() {
        return destination;
    }

    /**
     * <p>
     * The size of a file in the base of a merge or pull request.
     * </p>
     * 
     * @return The size of a file in the base of a merge or pull request.
     */
    public final Long base() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(base());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSizes)) {
            return false;
        }
        FileSizes other = (FileSizes) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(base(), other.base());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSizes").add("Source", source()).add("Destination", destination()).add("Base", base())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "base":
            return Optional.ofNullable(clazz.cast(base()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("base", BASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileSizes, T> g) {
        return obj -> g.apply((FileSizes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSizes> {
        /**
         * <p>
         * The size of a file in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        The size of a file in the source of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Long source);

        /**
         * <p>
         * The size of a file in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        The size of a file in the destination of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Long destination);

        /**
         * <p>
         * The size of a file in the base of a merge or pull request.
         * </p>
         * 
         * @param base
         *        The size of a file in the base of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base(Long base);
    }

    static final class BuilderImpl implements Builder {
        private Long source;

        private Long destination;

        private Long base;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSizes model) {
            source(model.source);
            destination(model.destination);
            base(model.base);
        }

        public final Long getSource() {
            return source;
        }

        public final void setSource(Long source) {
            this.source = source;
        }

        @Override
        public final Builder source(Long source) {
            this.source = source;
            return this;
        }

        public final Long getDestination() {
            return destination;
        }

        public final void setDestination(Long destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(Long destination) {
            this.destination = destination;
            return this;
        }

        public final Long getBase() {
            return base;
        }

        public final void setBase(Long base) {
            this.base = base;
        }

        @Override
        public final Builder base(Long base) {
            this.base = base;
            return this;
        }

        @Override
        public FileSizes build() {
            return new FileSizes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
