/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a folder in a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Folder implements SdkPojo, Serializable, ToCopyableBuilder<Folder.Builder, Folder> {
    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("treeId")
            .getter(getter(Folder::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final SdkField<String> ABSOLUTE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("absolutePath").getter(getter(Folder::absolutePath)).setter(setter(Builder::absolutePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolutePath").build()).build();

    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relativePath").getter(getter(Folder::relativePath)).setter(setter(Builder::relativePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TREE_ID_FIELD,
            ABSOLUTE_PATH_FIELD, RELATIVE_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String treeId;

    private final String absolutePath;

    private final String relativePath;

    private Folder(BuilderImpl builder) {
        this.treeId = builder.treeId;
        this.absolutePath = builder.absolutePath;
        this.relativePath = builder.relativePath;
    }

    /**
     * <p>
     * The full SHA-1 pointer of the tree information for the commit that contains the folder.
     * </p>
     * 
     * @return The full SHA-1 pointer of the tree information for the commit that contains the folder.
     */
    public final String treeId() {
        return treeId;
    }

    /**
     * <p>
     * The fully qualified path of the folder in the repository.
     * </p>
     * 
     * @return The fully qualified path of the folder in the repository.
     */
    public final String absolutePath() {
        return absolutePath;
    }

    /**
     * <p>
     * The relative path of the specified folder from the folder where the query originated.
     * </p>
     * 
     * @return The relative path of the specified folder from the folder where the query originated.
     */
    public final String relativePath() {
        return relativePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        hashCode = 31 * hashCode + Objects.hashCode(absolutePath());
        hashCode = 31 * hashCode + Objects.hashCode(relativePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Folder)) {
            return false;
        }
        Folder other = (Folder) obj;
        return Objects.equals(treeId(), other.treeId()) && Objects.equals(absolutePath(), other.absolutePath())
                && Objects.equals(relativePath(), other.relativePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Folder").add("TreeId", treeId()).add("AbsolutePath", absolutePath())
                .add("RelativePath", relativePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        case "absolutePath":
            return Optional.ofNullable(clazz.cast(absolutePath()));
        case "relativePath":
            return Optional.ofNullable(clazz.cast(relativePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("treeId", TREE_ID_FIELD);
        map.put("absolutePath", ABSOLUTE_PATH_FIELD);
        map.put("relativePath", RELATIVE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Folder, T> g) {
        return obj -> g.apply((Folder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Folder> {
        /**
         * <p>
         * The full SHA-1 pointer of the tree information for the commit that contains the folder.
         * </p>
         * 
         * @param treeId
         *        The full SHA-1 pointer of the tree information for the commit that contains the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);

        /**
         * <p>
         * The fully qualified path of the folder in the repository.
         * </p>
         * 
         * @param absolutePath
         *        The fully qualified path of the folder in the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absolutePath(String absolutePath);

        /**
         * <p>
         * The relative path of the specified folder from the folder where the query originated.
         * </p>
         * 
         * @param relativePath
         *        The relative path of the specified folder from the folder where the query originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativePath(String relativePath);
    }

    static final class BuilderImpl implements Builder {
        private String treeId;

        private String absolutePath;

        private String relativePath;

        private BuilderImpl() {
        }

        private BuilderImpl(Folder model) {
            treeId(model.treeId);
            absolutePath(model.absolutePath);
            relativePath(model.relativePath);
        }

        public final String getTreeId() {
            return treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final String getAbsolutePath() {
            return absolutePath;
        }

        public final void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        @Override
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
            return this;
        }

        public final String getRelativePath() {
            return relativePath;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        @Override
        public Folder build() {
            return new Folder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
