/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFileRequest extends CodeCommitRequest implements ToCopyableBuilder<GetFileRequest.Builder, GetFileRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(GetFileRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitSpecifier").getter(getter(GetFileRequest::commitSpecifier))
            .setter(setter(Builder::commitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitSpecifier").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(GetFileRequest::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            COMMIT_SPECIFIER_FIELD, FILE_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final String commitSpecifier;

    private final String filePath;

    private GetFileRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.commitSpecifier = builder.commitSpecifier;
        this.filePath = builder.filePath;
    }

    /**
     * <p>
     * The name of the repository that contains the file.
     * </p>
     * 
     * @return The name of the repository that contains the file.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The fully quaified reference that identifies the commit that contains the file. For example, you can specify a
     * full commit ID, a tag, a branch name, or a reference such as refs/heads/main. If none is provided, the head
     * commit is used.
     * </p>
     * 
     * @return The fully quaified reference that identifies the commit that contains the file. For example, you can
     *         specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/main. If none is
     *         provided, the head commit is used.
     */
    public final String commitSpecifier() {
        return commitSpecifier;
    }

    /**
     * <p>
     * The fully qualified path to the file, including the full name and extension of the file. For example,
     * /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.
     * </p>
     * 
     * @return The fully qualified path to the file, including the full name and extension of the file. For example,
     *         /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.
     */
    public final String filePath() {
        return filePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(commitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFileRequest)) {
            return false;
        }
        GetFileRequest other = (GetFileRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(commitSpecifier(), other.commitSpecifier()) && Objects.equals(filePath(), other.filePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFileRequest").add("RepositoryName", repositoryName())
                .add("CommitSpecifier", commitSpecifier()).add("FilePath", filePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "commitSpecifier":
            return Optional.ofNullable(clazz.cast(commitSpecifier()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("commitSpecifier", COMMIT_SPECIFIER_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFileRequest, T> g) {
        return obj -> g.apply((GetFileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFileRequest> {
        /**
         * <p>
         * The name of the repository that contains the file.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The fully quaified reference that identifies the commit that contains the file. For example, you can specify
         * a full commit ID, a tag, a branch name, or a reference such as refs/heads/main. If none is provided, the head
         * commit is used.
         * </p>
         * 
         * @param commitSpecifier
         *        The fully quaified reference that identifies the commit that contains the file. For example, you can
         *        specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/main. If none is
         *        provided, the head commit is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitSpecifier(String commitSpecifier);

        /**
         * <p>
         * The fully qualified path to the file, including the full name and extension of the file. For example,
         * /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.
         * </p>
         * 
         * @param filePath
         *        The fully qualified path to the file, including the full name and extension of the file. For example,
         *        /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String commitSpecifier;

        private String filePath;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFileRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            commitSpecifier(model.commitSpecifier);
            filePath(model.filePath);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getCommitSpecifier() {
            return commitSpecifier;
        }

        public final void setCommitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
        }

        @Override
        public final Builder commitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFileRequest build() {
            return new GetFileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
