/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFileCommitHistoryResponse extends CodeCommitResponse implements
        ToCopyableBuilder<ListFileCommitHistoryResponse.Builder, ListFileCommitHistoryResponse> {
    private static final SdkField<List<FileVersion>> REVISION_DAG_FIELD = SdkField
            .<List<FileVersion>> builder(MarshallingType.LIST)
            .memberName("revisionDag")
            .getter(getter(ListFileCommitHistoryResponse::revisionDag))
            .setter(setter(Builder::revisionDag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionDag").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFileCommitHistoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_DAG_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FileVersion> revisionDag;

    private final String nextToken;

    private ListFileCommitHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.revisionDag = builder.revisionDag;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevisionDag property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevisionDag() {
        return revisionDag != null && !(revisionDag instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file made by the
     * commits that changed the file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevisionDag} method.
     * </p>
     * 
     * @return An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file made
     *         by the commits that changed the file.
     */
    public final List<FileVersion> revisionDag() {
        return revisionDag;
    }

    /**
     * <p>
     * An enumeration token that can be used to return the next batch of results.
     * </p>
     * 
     * @return An enumeration token that can be used to return the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRevisionDag() ? revisionDag() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileCommitHistoryResponse)) {
            return false;
        }
        ListFileCommitHistoryResponse other = (ListFileCommitHistoryResponse) obj;
        return hasRevisionDag() == other.hasRevisionDag() && Objects.equals(revisionDag(), other.revisionDag())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFileCommitHistoryResponse").add("RevisionDag", hasRevisionDag() ? revisionDag() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionDag":
            return Optional.ofNullable(clazz.cast(revisionDag()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("revisionDag", REVISION_DAG_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFileCommitHistoryResponse, T> g) {
        return obj -> g.apply((ListFileCommitHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFileCommitHistoryResponse> {
        /**
         * <p>
         * An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file made by
         * the commits that changed the file.
         * </p>
         * 
         * @param revisionDag
         *        An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file
         *        made by the commits that changed the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDag(Collection<FileVersion> revisionDag);

        /**
         * <p>
         * An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file made by
         * the commits that changed the file.
         * </p>
         * 
         * @param revisionDag
         *        An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file
         *        made by the commits that changed the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDag(FileVersion... revisionDag);

        /**
         * <p>
         * An array of FileVersion objects that form a directed acyclic graph (DAG) of the changes to the file made by
         * the commits that changed the file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.FileVersion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.FileVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.FileVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #revisionDag(List<FileVersion>)}.
         * 
         * @param revisionDag
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.FileVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionDag(java.util.Collection<FileVersion>)
         */
        Builder revisionDag(Consumer<FileVersion.Builder>... revisionDag);

        /**
         * <p>
         * An enumeration token that can be used to return the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<FileVersion> revisionDag = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileCommitHistoryResponse model) {
            super(model);
            revisionDag(model.revisionDag);
            nextToken(model.nextToken);
        }

        public final List<FileVersion.Builder> getRevisionDag() {
            List<FileVersion.Builder> result = RevisionDagCopier.copyToBuilder(this.revisionDag);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisionDag(Collection<FileVersion.BuilderImpl> revisionDag) {
            this.revisionDag = RevisionDagCopier.copyFromBuilder(revisionDag);
        }

        @Override
        public final Builder revisionDag(Collection<FileVersion> revisionDag) {
            this.revisionDag = RevisionDagCopier.copy(revisionDag);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDag(FileVersion... revisionDag) {
            revisionDag(Arrays.asList(revisionDag));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDag(Consumer<FileVersion.Builder>... revisionDag) {
            revisionDag(Stream.of(revisionDag).map(c -> FileVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFileCommitHistoryResponse build() {
            return new ListFileCommitHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
