/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPullRequestsRequest extends CodeCommitRequest implements
        ToCopyableBuilder<ListPullRequestsRequest.Builder, ListPullRequestsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(ListPullRequestsRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorArn").getter(getter(ListPullRequestsRequest::authorArn)).setter(setter(Builder::authorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()).build();

    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestStatus").getter(getter(ListPullRequestsRequest::pullRequestStatusAsString))
            .setter(setter(Builder::pullRequestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPullRequestsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListPullRequestsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            AUTHOR_ARN_FIELD, PULL_REQUEST_STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final String authorArn;

    private final String pullRequestStatus;

    private final String nextToken;

    private final Integer maxResults;

    private ListPullRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.authorArn = builder.authorArn;
        this.pullRequestStatus = builder.pullRequestStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the repository for which you want to list pull requests.
     * </p>
     * 
     * @return The name of the repository for which you want to list pull requests.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the
     * results to pull requests created by that user.
     * </p>
     * 
     * @return Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters
     *         the results to pull requests created by that user.
     */
    public final String authorArn() {
        return authorArn;
    }

    /**
     * <p>
     * Optional. The status of the pull request. If used, this refines the results to the pull requests that match the
     * specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pullRequestStatus}
     * will return {@link PullRequestStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pullRequestStatusAsString}.
     * </p>
     * 
     * @return Optional. The status of the pull request. If used, this refines the results to the pull requests that
     *         match the specified status.
     * @see PullRequestStatusEnum
     */
    public final PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(pullRequestStatus);
    }

    /**
     * <p>
     * Optional. The status of the pull request. If used, this refines the results to the pull requests that match the
     * specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pullRequestStatus}
     * will return {@link PullRequestStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pullRequestStatusAsString}.
     * </p>
     * 
     * @return Optional. The status of the pull request. If used, this refines the results to the pull requests that
     *         match the specified status.
     * @see PullRequestStatusEnum
     */
    public final String pullRequestStatusAsString() {
        return pullRequestStatus;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A non-zero, non-negative integer used to limit the number of returned results.
     * </p>
     * 
     * @return A non-zero, non-negative integer used to limit the number of returned results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPullRequestsRequest)) {
            return false;
        }
        ListPullRequestsRequest other = (ListPullRequestsRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(authorArn(), other.authorArn())
                && Objects.equals(pullRequestStatusAsString(), other.pullRequestStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPullRequestsRequest").add("RepositoryName", repositoryName()).add("AuthorArn", authorArn())
                .add("PullRequestStatus", pullRequestStatusAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "authorArn":
            return Optional.ofNullable(clazz.cast(authorArn()));
        case "pullRequestStatus":
            return Optional.ofNullable(clazz.cast(pullRequestStatusAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("authorArn", AUTHOR_ARN_FIELD);
        map.put("pullRequestStatus", PULL_REQUEST_STATUS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPullRequestsRequest, T> g) {
        return obj -> g.apply((ListPullRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPullRequestsRequest> {
        /**
         * <p>
         * The name of the repository for which you want to list pull requests.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository for which you want to list pull requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the
         * results to pull requests created by that user.
         * </p>
         * 
         * @param authorArn
         *        Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this
         *        filters the results to pull requests created by that user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorArn(String authorArn);

        /**
         * <p>
         * Optional. The status of the pull request. If used, this refines the results to the pull requests that match
         * the specified status.
         * </p>
         * 
         * @param pullRequestStatus
         *        Optional. The status of the pull request. If used, this refines the results to the pull requests that
         *        match the specified status.
         * @see PullRequestStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestStatusEnum
         */
        Builder pullRequestStatus(String pullRequestStatus);

        /**
         * <p>
         * Optional. The status of the pull request. If used, this refines the results to the pull requests that match
         * the specified status.
         * </p>
         * 
         * @param pullRequestStatus
         *        Optional. The status of the pull request. If used, this refines the results to the pull requests that
         *        match the specified status.
         * @see PullRequestStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestStatusEnum
         */
        Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A non-zero, non-negative integer used to limit the number of returned results.
         * </p>
         * 
         * @param maxResults
         *        A non-zero, non-negative integer used to limit the number of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String authorArn;

        private String pullRequestStatus;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPullRequestsRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            authorArn(model.authorArn);
            pullRequestStatus(model.pullRequestStatus);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getAuthorArn() {
            return authorArn;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final String getPullRequestStatus() {
            return pullRequestStatus;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        @Override
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus == null ? null : pullRequestStatus.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPullRequestsRequest build() {
            return new ListPullRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
