/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostCommentForPullRequestResponse extends CodeCommitResponse implements
        ToCopyableBuilder<PostCommentForPullRequestResponse.Builder, PostCommentForPullRequestResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PostCommentForPullRequestResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(PostCommentForPullRequestResponse::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("beforeCommitId").getter(getter(PostCommentForPullRequestResponse::beforeCommitId))
            .setter(setter(Builder::beforeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()).build();

    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterCommitId").getter(getter(PostCommentForPullRequestResponse::afterCommitId))
            .setter(setter(Builder::afterCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()).build();

    private static final SdkField<String> BEFORE_BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("beforeBlobId").getter(getter(PostCommentForPullRequestResponse::beforeBlobId))
            .setter(setter(Builder::beforeBlobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlobId").build()).build();

    private static final SdkField<String> AFTER_BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterBlobId").getter(getter(PostCommentForPullRequestResponse::afterBlobId))
            .setter(setter(Builder::afterBlobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlobId").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("location").getter(getter(PostCommentForPullRequestResponse::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Comment> COMMENT_FIELD = SdkField.<Comment> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(PostCommentForPullRequestResponse::comment)).setter(setter(Builder::comment))
            .constructor(Comment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            PULL_REQUEST_ID_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, BEFORE_BLOB_ID_FIELD, AFTER_BLOB_ID_FIELD,
            LOCATION_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final String pullRequestId;

    private final String beforeCommitId;

    private final String afterCommitId;

    private final String beforeBlobId;

    private final String afterBlobId;

    private final Location location;

    private final Comment comment;

    private PostCommentForPullRequestResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.pullRequestId = builder.pullRequestId;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.beforeBlobId = builder.beforeBlobId;
        this.afterBlobId = builder.afterBlobId;
        this.location = builder.location;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The name of the repository where you posted a comment on a pull request.
     * </p>
     * 
     * @return The name of the repository where you posted a comment on a pull request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The system-generated ID of the pull request.
     * </p>
     * 
     * @return The system-generated ID of the pull request.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The full commit ID of the commit in the source branch used to create the pull request, or in the case of an
     * updated pull request, the full commit ID of the commit used to update the pull request.
     * </p>
     * 
     * @return The full commit ID of the commit in the source branch used to create the pull request, or in the case of
     *         an updated pull request, the full commit ID of the commit used to update the pull request.
     */
    public final String beforeCommitId() {
        return beforeCommitId;
    }

    /**
     * <p>
     * The full commit ID of the commit in the destination branch where the pull request is merged.
     * </p>
     * 
     * @return The full commit ID of the commit in the destination branch where the pull request is merged.
     */
    public final String afterCommitId() {
        return afterCommitId;
    }

    /**
     * <p>
     * In the directionality of the pull request, the blob ID of the before blob.
     * </p>
     * 
     * @return In the directionality of the pull request, the blob ID of the before blob.
     */
    public final String beforeBlobId() {
        return beforeBlobId;
    }

    /**
     * <p>
     * In the directionality of the pull request, the blob ID of the after blob.
     * </p>
     * 
     * @return In the directionality of the pull request, the blob ID of the after blob.
     */
    public final String afterBlobId() {
        return afterBlobId;
    }

    /**
     * <p>
     * The location of the change where you posted your comment.
     * </p>
     * 
     * @return The location of the change where you posted your comment.
     */
    public final Location location() {
        return location;
    }

    /**
     * <p>
     * The content of the comment you posted.
     * </p>
     * 
     * @return The content of the comment you posted.
     */
    public final Comment comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(beforeBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(afterBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentForPullRequestResponse)) {
            return false;
        }
        PostCommentForPullRequestResponse other = (PostCommentForPullRequestResponse) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(beforeCommitId(), other.beforeCommitId())
                && Objects.equals(afterCommitId(), other.afterCommitId()) && Objects.equals(beforeBlobId(), other.beforeBlobId())
                && Objects.equals(afterBlobId(), other.afterBlobId()) && Objects.equals(location(), other.location())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostCommentForPullRequestResponse").add("RepositoryName", repositoryName())
                .add("PullRequestId", pullRequestId()).add("BeforeCommitId", beforeCommitId())
                .add("AfterCommitId", afterCommitId()).add("BeforeBlobId", beforeBlobId()).add("AfterBlobId", afterBlobId())
                .add("Location", location()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "beforeCommitId":
            return Optional.ofNullable(clazz.cast(beforeCommitId()));
        case "afterCommitId":
            return Optional.ofNullable(clazz.cast(afterCommitId()));
        case "beforeBlobId":
            return Optional.ofNullable(clazz.cast(beforeBlobId()));
        case "afterBlobId":
            return Optional.ofNullable(clazz.cast(afterBlobId()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("pullRequestId", PULL_REQUEST_ID_FIELD);
        map.put("beforeCommitId", BEFORE_COMMIT_ID_FIELD);
        map.put("afterCommitId", AFTER_COMMIT_ID_FIELD);
        map.put("beforeBlobId", BEFORE_BLOB_ID_FIELD);
        map.put("afterBlobId", AFTER_BLOB_ID_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostCommentForPullRequestResponse, T> g) {
        return obj -> g.apply((PostCommentForPullRequestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PostCommentForPullRequestResponse> {
        /**
         * <p>
         * The name of the repository where you posted a comment on a pull request.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you posted a comment on a pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The system-generated ID of the pull request.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The full commit ID of the commit in the source branch used to create the pull request, or in the case of an
         * updated pull request, the full commit ID of the commit used to update the pull request.
         * </p>
         * 
         * @param beforeCommitId
         *        The full commit ID of the commit in the source branch used to create the pull request, or in the case
         *        of an updated pull request, the full commit ID of the commit used to update the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitId(String beforeCommitId);

        /**
         * <p>
         * The full commit ID of the commit in the destination branch where the pull request is merged.
         * </p>
         * 
         * @param afterCommitId
         *        The full commit ID of the commit in the destination branch where the pull request is merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitId(String afterCommitId);

        /**
         * <p>
         * In the directionality of the pull request, the blob ID of the before blob.
         * </p>
         * 
         * @param beforeBlobId
         *        In the directionality of the pull request, the blob ID of the before blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeBlobId(String beforeBlobId);

        /**
         * <p>
         * In the directionality of the pull request, the blob ID of the after blob.
         * </p>
         * 
         * @param afterBlobId
         *        In the directionality of the pull request, the blob ID of the after blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterBlobId(String afterBlobId);

        /**
         * <p>
         * The location of the change where you posted your comment.
         * </p>
         * 
         * @param location
         *        The location of the change where you posted your comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * The location of the change where you posted your comment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Location.Builder} avoiding the need to
         * create one manually via {@link Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The content of the comment you posted.
         * </p>
         * 
         * @param comment
         *        The content of the comment you posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(Comment comment);

        /**
         * <p>
         * The content of the comment you posted.
         * </p>
         * This is a convenience method that creates an instance of the {@link Comment.Builder} avoiding the need to
         * create one manually via {@link Comment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Comment.Builder#build()} is called immediately and its result is
         * passed to {@link #comment(Comment)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link Comment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(Comment)
         */
        default Builder comment(Consumer<Comment.Builder> comment) {
            return comment(Comment.builder().applyMutation(comment).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String repositoryName;

        private String pullRequestId;

        private String beforeCommitId;

        private String afterCommitId;

        private String beforeBlobId;

        private String afterBlobId;

        private Location location;

        private Comment comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentForPullRequestResponse model) {
            super(model);
            repositoryName(model.repositoryName);
            pullRequestId(model.pullRequestId);
            beforeCommitId(model.beforeCommitId);
            afterCommitId(model.afterCommitId);
            beforeBlobId(model.beforeBlobId);
            afterBlobId(model.afterBlobId);
            location(model.location);
            comment(model.comment);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getBeforeCommitId() {
            return beforeCommitId;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final String getAfterCommitId() {
            return afterCommitId;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final String getBeforeBlobId() {
            return beforeBlobId;
        }

        public final void setBeforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
        }

        @Override
        public final Builder beforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
            return this;
        }

        public final String getAfterBlobId() {
            return afterBlobId;
        }

        public final void setAfterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
        }

        @Override
        public final Builder afterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final Comment.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public PostCommentForPullRequestResponse build() {
            return new PostCommentForPullRequestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
