/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRepositoryEncryptionKeyResponse extends CodeCommitResponse implements
        ToCopyableBuilder<UpdateRepositoryEncryptionKeyResponse.Builder, UpdateRepositoryEncryptionKeyResponse> {
    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryId").getter(getter(UpdateRepositoryEncryptionKeyResponse::repositoryId))
            .setter(setter(Builder::repositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(UpdateRepositoryEncryptionKeyResponse::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> ORIGINAL_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originalKmsKeyId").getter(getter(UpdateRepositoryEncryptionKeyResponse::originalKmsKeyId))
            .setter(setter(Builder::originalKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originalKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ID_FIELD,
            KMS_KEY_ID_FIELD, ORIGINAL_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryId;

    private final String kmsKeyId;

    private final String originalKmsKeyId;

    private UpdateRepositoryEncryptionKeyResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryId = builder.repositoryId;
        this.kmsKeyId = builder.kmsKeyId;
        this.originalKmsKeyId = builder.originalKmsKeyId;
    }

    /**
     * <p>
     * The ID of the repository.
     * </p>
     * 
     * @return The ID of the repository.
     */
    public final String repositoryId() {
        return repositoryId;
    }

    /**
     * <p>
     * The ID of the encryption key.
     * </p>
     * 
     * @return The ID of the encryption key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ID of the encryption key formerly used to encrypt and decrypt the repository.
     * </p>
     * 
     * @return The ID of the encryption key formerly used to encrypt and decrypt the repository.
     */
    public final String originalKmsKeyId() {
        return originalKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(originalKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryEncryptionKeyResponse)) {
            return false;
        }
        UpdateRepositoryEncryptionKeyResponse other = (UpdateRepositoryEncryptionKeyResponse) obj;
        return Objects.equals(repositoryId(), other.repositoryId()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(originalKmsKeyId(), other.originalKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRepositoryEncryptionKeyResponse").add("RepositoryId", repositoryId())
                .add("KmsKeyId", kmsKeyId()).add("OriginalKmsKeyId", originalKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryId":
            return Optional.ofNullable(clazz.cast(repositoryId()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "originalKmsKeyId":
            return Optional.ofNullable(clazz.cast(originalKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryId", REPOSITORY_ID_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("originalKmsKeyId", ORIGINAL_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryEncryptionKeyResponse, T> g) {
        return obj -> g.apply((UpdateRepositoryEncryptionKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRepositoryEncryptionKeyResponse> {
        /**
         * <p>
         * The ID of the repository.
         * </p>
         * 
         * @param repositoryId
         *        The ID of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryId(String repositoryId);

        /**
         * <p>
         * The ID of the encryption key.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ID of the encryption key formerly used to encrypt and decrypt the repository.
         * </p>
         * 
         * @param originalKmsKeyId
         *        The ID of the encryption key formerly used to encrypt and decrypt the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalKmsKeyId(String originalKmsKeyId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String repositoryId;

        private String kmsKeyId;

        private String originalKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryEncryptionKeyResponse model) {
            super(model);
            repositoryId(model.repositoryId);
            kmsKeyId(model.kmsKeyId);
            originalKmsKeyId(model.originalKmsKeyId);
        }

        public final String getRepositoryId() {
            return repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOriginalKmsKeyId() {
            return originalKmsKeyId;
        }

        public final void setOriginalKmsKeyId(String originalKmsKeyId) {
            this.originalKmsKeyId = originalKmsKeyId;
        }

        @Override
        public final Builder originalKmsKeyId(String originalKmsKeyId) {
            this.originalKmsKeyId = originalKmsKeyId;
            return this;
        }

        @Override
        public UpdateRepositoryEncryptionKeyResponse build() {
            return new UpdateRepositoryEncryptionKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
