/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDifferencesRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, GetDifferencesRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(GetDifferencesRequest.getter(GetDifferencesRequest::repositoryName)).setter(GetDifferencesRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BEFORE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeCommitSpecifier").getter(GetDifferencesRequest.getter(GetDifferencesRequest::beforeCommitSpecifier)).setter(GetDifferencesRequest.setter(Builder::beforeCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitSpecifier").build()}).build();
    private static final SdkField<String> AFTER_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterCommitSpecifier").getter(GetDifferencesRequest.getter(GetDifferencesRequest::afterCommitSpecifier)).setter(GetDifferencesRequest.setter(Builder::afterCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitSpecifier").build()}).build();
    private static final SdkField<String> BEFORE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforePath").getter(GetDifferencesRequest.getter(GetDifferencesRequest::beforePath)).setter(GetDifferencesRequest.setter(Builder::beforePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforePath").build()}).build();
    private static final SdkField<String> AFTER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterPath").getter(GetDifferencesRequest.getter(GetDifferencesRequest::afterPath)).setter(GetDifferencesRequest.setter(Builder::afterPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterPath").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetDifferencesRequest.getter(GetDifferencesRequest::maxResults)).setter(GetDifferencesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDifferencesRequest.getter(GetDifferencesRequest::nextToken)).setter(GetDifferencesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BEFORE_COMMIT_SPECIFIER_FIELD, AFTER_COMMIT_SPECIFIER_FIELD, BEFORE_PATH_FIELD, AFTER_PATH_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDifferencesRequest.memberNameToFieldInitializer();
    private final String repositoryName;
    private final String beforeCommitSpecifier;
    private final String afterCommitSpecifier;
    private final String beforePath;
    private final String afterPath;
    private final Integer maxResults;
    private final String nextToken;

    private GetDifferencesRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.beforeCommitSpecifier = builder.beforeCommitSpecifier;
        this.afterCommitSpecifier = builder.afterCommitSpecifier;
        this.beforePath = builder.beforePath;
        this.afterPath = builder.afterPath;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String beforeCommitSpecifier() {
        return this.beforeCommitSpecifier;
    }

    public final String afterCommitSpecifier() {
        return this.afterCommitSpecifier;
    }

    public final String beforePath() {
        return this.beforePath;
    }

    public final String afterPath() {
        return this.afterPath;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDifferencesRequest)) {
            return false;
        }
        GetDifferencesRequest other = (GetDifferencesRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.beforeCommitSpecifier(), other.beforeCommitSpecifier()) && Objects.equals(this.afterCommitSpecifier(), other.afterCommitSpecifier()) && Objects.equals(this.beforePath(), other.beforePath()) && Objects.equals(this.afterPath(), other.afterPath()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDifferencesRequest").add("RepositoryName", (Object)this.repositoryName()).add("BeforeCommitSpecifier", (Object)this.beforeCommitSpecifier()).add("AfterCommitSpecifier", (Object)this.afterCommitSpecifier()).add("BeforePath", (Object)this.beforePath()).add("AfterPath", (Object)this.afterPath()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "beforeCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.beforeCommitSpecifier()));
            }
            case "afterCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.afterCommitSpecifier()));
            }
            case "beforePath": {
                return Optional.ofNullable(clazz.cast(this.beforePath()));
            }
            case "afterPath": {
                return Optional.ofNullable(clazz.cast(this.afterPath()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("beforeCommitSpecifier", BEFORE_COMMIT_SPECIFIER_FIELD);
        map.put("afterCommitSpecifier", AFTER_COMMIT_SPECIFIER_FIELD);
        map.put("beforePath", BEFORE_PATH_FIELD);
        map.put("afterPath", AFTER_PATH_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDifferencesRequest, T> g) {
        return obj -> g.apply((GetDifferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String beforeCommitSpecifier;
        private String afterCommitSpecifier;
        private String beforePath;
        private String afterPath;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDifferencesRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.beforeCommitSpecifier(model.beforeCommitSpecifier);
            this.afterCommitSpecifier(model.afterCommitSpecifier);
            this.beforePath(model.beforePath);
            this.afterPath(model.afterPath);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBeforeCommitSpecifier() {
            return this.beforeCommitSpecifier;
        }

        public final void setBeforeCommitSpecifier(String beforeCommitSpecifier) {
            this.beforeCommitSpecifier = beforeCommitSpecifier;
        }

        @Override
        public final Builder beforeCommitSpecifier(String beforeCommitSpecifier) {
            this.beforeCommitSpecifier = beforeCommitSpecifier;
            return this;
        }

        public final String getAfterCommitSpecifier() {
            return this.afterCommitSpecifier;
        }

        public final void setAfterCommitSpecifier(String afterCommitSpecifier) {
            this.afterCommitSpecifier = afterCommitSpecifier;
        }

        @Override
        public final Builder afterCommitSpecifier(String afterCommitSpecifier) {
            this.afterCommitSpecifier = afterCommitSpecifier;
            return this;
        }

        public final String getBeforePath() {
            return this.beforePath;
        }

        public final void setBeforePath(String beforePath) {
            this.beforePath = beforePath;
        }

        @Override
        public final Builder beforePath(String beforePath) {
            this.beforePath = beforePath;
            return this;
        }

        public final String getAfterPath() {
            return this.afterPath;
        }

        public final void setAfterPath(String afterPath) {
            this.afterPath = afterPath;
        }

        @Override
        public final Builder afterPath(String afterPath) {
            this.afterPath = afterPath;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDifferencesRequest build() {
            return new GetDifferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDifferencesRequest> {
        public Builder repositoryName(String var1);

        public Builder beforeCommitSpecifier(String var1);

        public Builder afterCommitSpecifier(String var1);

        public Builder beforePath(String var1);

        public Builder afterPath(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

