/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OverrideStatus {
    OVERRIDE("OVERRIDE"),
    REVOKE("REVOKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OverrideStatus> VALUE_MAP;
    private final String value;

    private OverrideStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OverrideStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OverrideStatus> knownValues() {
        EnumSet<OverrideStatus> knownValues = EnumSet.allOf(OverrideStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OverrideStatus.class, OverrideStatus::toString);
    }
}

