/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFileRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, DeleteFileRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(DeleteFileRequest.getter(DeleteFileRequest::repositoryName)).setter(DeleteFileRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(DeleteFileRequest.getter(DeleteFileRequest::branchName)).setter(DeleteFileRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(DeleteFileRequest.getter(DeleteFileRequest::filePath)).setter(DeleteFileRequest.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> PARENT_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentCommitId").getter(DeleteFileRequest.getter(DeleteFileRequest::parentCommitId)).setter(DeleteFileRequest.setter(Builder::parentCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentCommitId").build()}).build();
    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("keepEmptyFolders").getter(DeleteFileRequest.getter(DeleteFileRequest::keepEmptyFolders)).setter(DeleteFileRequest.setter(Builder::keepEmptyFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitMessage").getter(DeleteFileRequest.getter(DeleteFileRequest::commitMessage)).setter(DeleteFileRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeleteFileRequest.getter(DeleteFileRequest::name)).setter(DeleteFileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(DeleteFileRequest.getter(DeleteFileRequest::email)).setter(DeleteFileRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BRANCH_NAME_FIELD, FILE_PATH_FIELD, PARENT_COMMIT_ID_FIELD, KEEP_EMPTY_FOLDERS_FIELD, COMMIT_MESSAGE_FIELD, NAME_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteFileRequest.memberNameToFieldInitializer();
    private final String repositoryName;
    private final String branchName;
    private final String filePath;
    private final String parentCommitId;
    private final Boolean keepEmptyFolders;
    private final String commitMessage;
    private final String name;
    private final String email;

    private DeleteFileRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.branchName = builder.branchName;
        this.filePath = builder.filePath;
        this.parentCommitId = builder.parentCommitId;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.commitMessage = builder.commitMessage;
        this.name = builder.name;
        this.email = builder.email;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String parentCommitId() {
        return this.parentCommitId;
    }

    public final Boolean keepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public final String commitMessage() {
        return this.commitMessage;
    }

    public final String name() {
        return this.name;
    }

    public final String email() {
        return this.email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileRequest)) {
            return false;
        }
        DeleteFileRequest other = (DeleteFileRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.parentCommitId(), other.parentCommitId()) && Objects.equals(this.keepEmptyFolders(), other.keepEmptyFolders()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFileRequest").add("RepositoryName", (Object)this.repositoryName()).add("BranchName", (Object)this.branchName()).add("FilePath", (Object)this.filePath()).add("ParentCommitId", (Object)this.parentCommitId()).add("KeepEmptyFolders", (Object)this.keepEmptyFolders()).add("CommitMessage", (Object)this.commitMessage()).add("Name", (Object)this.name()).add("Email", (Object)this.email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "parentCommitId": {
                return Optional.ofNullable(clazz.cast(this.parentCommitId()));
            }
            case "keepEmptyFolders": {
                return Optional.ofNullable(clazz.cast(this.keepEmptyFolders()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("parentCommitId", PARENT_COMMIT_ID_FIELD);
        map.put("keepEmptyFolders", KEEP_EMPTY_FOLDERS_FIELD);
        map.put("commitMessage", COMMIT_MESSAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileRequest, T> g) {
        return obj -> g.apply((DeleteFileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String branchName;
        private String filePath;
        private String parentCommitId;
        private Boolean keepEmptyFolders;
        private String commitMessage;
        private String name;
        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.branchName(model.branchName);
            this.filePath(model.filePath);
            this.parentCommitId(model.parentCommitId);
            this.keepEmptyFolders(model.keepEmptyFolders);
            this.commitMessage(model.commitMessage);
            this.name(model.name);
            this.email(model.email);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getParentCommitId() {
            return this.parentCommitId;
        }

        public final void setParentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
        }

        @Override
        public final Builder parentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
            return this;
        }

        public final Boolean getKeepEmptyFolders() {
            return this.keepEmptyFolders;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        @Override
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileRequest build() {
            return new DeleteFileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFileRequest> {
        public Builder repositoryName(String var1);

        public Builder branchName(String var1);

        public Builder filePath(String var1);

        public Builder parentCommitId(String var1);

        public Builder keepEmptyFolders(Boolean var1);

        public Builder commitMessage(String var1);

        public Builder name(String var1);

        public Builder email(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

