/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.CodeCommitServiceClientConfiguration;
import software.amazon.awssdk.services.codecommit.internal.CodeCommitServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codecommit.model.ActorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateInUseException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalStateRequiredException;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.AuthorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BeforeCommitIdAndAfterCommitIdAreSameException;
import software.amazon.awssdk.services.codecommit.model.BlobIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BlobIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.BranchDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BranchNameExistsException;
import software.amazon.awssdk.services.codecommit.model.BranchNameIsTagNameException;
import software.amazon.awssdk.services.codecommit.model.BranchNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.CannotDeleteApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.CannotModifyApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.ClientRequestTokenRequiredException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitException;
import software.amazon.awssdk.services.codecommit.model.CommentContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommentDeletedException;
import software.amazon.awssdk.services.codecommit.model.CommentDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommentIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentNotCreatedByCallerException;
import software.amazon.awssdk.services.codecommit.model.CommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitMessageLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitRequiredException;
import software.amazon.awssdk.services.codecommit.model.ConcurrentReferenceUpdateException;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreateCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.DefaultBranchCannotBeDeletedException;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DirectoryNameConflictsWithFileNameException;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyAccessDeniedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyDisabledException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyInvalidIdException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyInvalidUsageException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyNotFoundException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyRequiredException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyUnavailableException;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.FileContentAndSourceFileSpecifiedException;
import software.amazon.awssdk.services.codecommit.model.FileContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FileDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.FileEntryRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileModeRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileNameConflictsWithDirectoryNameException;
import software.amazon.awssdk.services.codecommit.model.FilePathConflictsWithSubmodulePathException;
import software.amazon.awssdk.services.codecommit.model.FileTooLargeException;
import software.amazon.awssdk.services.codecommit.model.FolderContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FolderDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.codecommit.model.InvalidActorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalStateException;
import software.amazon.awssdk.services.codecommit.model.InvalidAuthorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidBlobIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidClientRequestTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommentIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictDetailLevelException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionStrategyException;
import software.amazon.awssdk.services.codecommit.model.InvalidContinuationTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidDeletionParameterException;
import software.amazon.awssdk.services.codecommit.model.InvalidDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidDestinationCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidEmailException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileLocationException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileModeException;
import software.amazon.awssdk.services.codecommit.model.InvalidFilePositionException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxConflictFilesException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxMergeHunksException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.codecommit.model.InvalidMergeOptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidOrderException;
import software.amazon.awssdk.services.codecommit.model.InvalidOverrideStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidParentCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPathException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestEventTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusUpdateException;
import software.amazon.awssdk.services.codecommit.model.InvalidReactionUserArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidReactionValueException;
import software.amazon.awssdk.services.codecommit.model.InvalidReferenceNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRelativeFileVersionEnumException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import software.amazon.awssdk.services.codecommit.model.InvalidResourceArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRevisionIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidRuleContentSha256Exception;
import software.amazon.awssdk.services.codecommit.model.InvalidSortByException;
import software.amazon.awssdk.services.codecommit.model.InvalidSourceCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidSystemTagUsageException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagKeysListException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagsMapException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetBranchException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetsException;
import software.amazon.awssdk.services.codecommit.model.InvalidTitleException;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codecommit.model.ManualMergeRequiredException;
import software.amazon.awssdk.services.codecommit.model.MaximumBranchesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumConflictResolutionEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileContentToLoadExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumItemsToCompareExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumNumberOfApprovalsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumOpenPullRequestsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryNamesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRuleTemplatesAssociatedWithRepositoryException;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MergeOptionRequiredException;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MultipleConflictResolutionEntriesException;
import software.amazon.awssdk.services.codecommit.model.MultipleRepositoriesInPullRequestException;
import software.amazon.awssdk.services.codecommit.model.NameLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.NoChangeException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRuleTemplatesExceededException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRulesExceededException;
import software.amazon.awssdk.services.codecommit.model.OperationNotAllowedException;
import software.amazon.awssdk.services.codecommit.model.OverrideAlreadySetException;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.OverrideStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdOutdatedException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PathDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PathRequiredException;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestAlreadyClosedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestApprovalRulesNotSatisfiedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestCannotBeApprovedByAuthorException;
import software.amazon.awssdk.services.codecommit.model.PullRequestDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionResponse;
import software.amazon.awssdk.services.codecommit.model.PutFileEntryConflictException;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ReactionLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.ReactionValueRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ReferenceNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceTypeNotSupportedException;
import software.amazon.awssdk.services.codecommit.model.ReplacementContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReplacementTypeRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.RepositoryLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameExistsException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNamesRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotAssociatedWithPullRequestException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListRequiredException;
import software.amazon.awssdk.services.codecommit.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RestrictedSourceFileException;
import software.amazon.awssdk.services.codecommit.model.RevisionIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.RevisionNotCurrentException;
import software.amazon.awssdk.services.codecommit.model.SameFileContentException;
import software.amazon.awssdk.services.codecommit.model.SamePathRequestException;
import software.amazon.awssdk.services.codecommit.model.SourceAndDestinationAreSameException;
import software.amazon.awssdk.services.codecommit.model.SourceFileOrContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagKeysListRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagPolicyException;
import software.amazon.awssdk.services.codecommit.model.TagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.TagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.TagsMapRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetsRequiredException;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TipOfSourceReferenceIsDifferentException;
import software.amazon.awssdk.services.codecommit.model.TipsDivergenceExceededException;
import software.amazon.awssdk.services.codecommit.model.TitleRequiredException;
import software.amazon.awssdk.services.codecommit.model.TooManyTagsException;
import software.amazon.awssdk.services.codecommit.model.UntagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.UntagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.transform.AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetCommitsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateUnreferencedMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteCommentContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeletePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribePullRequestEventsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DisassociateApprovalRuleTemplateFromRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.EvaluatePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBlobRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentReactionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetDifferencesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeOptionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestApprovalStatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestOverrideStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListApprovalRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListAssociatedApprovalRuleTemplatesForRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListFileCommitHistoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListPullRequestsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesForApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.OverridePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentReplyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutCommentReactionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TestRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateNameRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateDefaultBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalRuleContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestTitleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryNameRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCodeCommitAsyncClient
implements CodeCommitAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeCommitAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeCommitAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CodeCommit#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateApprovalRuleTemplateWithRepositoryResponse> associateApprovalRuleTemplateWithRepository(AssociateApprovalRuleTemplateWithRepositoryRequest associateApprovalRuleTemplateWithRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateApprovalRuleTemplateWithRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, associateApprovalRuleTemplateWithRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateApprovalRuleTemplateWithRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateApprovalRuleTemplateWithRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateApprovalRuleTemplateWithRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateApprovalRuleTemplateWithRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$associateApprovalRuleTemplateWithRepository$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$associateApprovalRuleTemplateWithRepository$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> batchAssociateApprovalRuleTemplateWithRepositories(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest batchAssociateApprovalRuleTemplateWithRepositoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchAssociateApprovalRuleTemplateWithRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, batchAssociateApprovalRuleTemplateWithRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchAssociateApprovalRuleTemplateWithRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchAssociateApprovalRuleTemplateWithRepositories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchAssociateApprovalRuleTemplateWithRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchAssociateApprovalRuleTemplateWithRepositories$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchAssociateApprovalRuleTemplateWithRepositories$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDescribeMergeConflictsResponse> batchDescribeMergeConflicts(BatchDescribeMergeConflictsRequest batchDescribeMergeConflictsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDescribeMergeConflictsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, batchDescribeMergeConflictsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDescribeMergeConflicts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDescribeMergeConflictsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDescribeMergeConflicts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDescribeMergeConflictsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDescribeMergeConflictsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchDescribeMergeConflicts$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchDescribeMergeConflicts$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> batchDisassociateApprovalRuleTemplateFromRepositories(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest batchDisassociateApprovalRuleTemplateFromRepositoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDisassociateApprovalRuleTemplateFromRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, batchDisassociateApprovalRuleTemplateFromRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDisassociateApprovalRuleTemplateFromRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDisassociateApprovalRuleTemplateFromRepositories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDisassociateApprovalRuleTemplateFromRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchDisassociateApprovalRuleTemplateFromRepositories$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchDisassociateApprovalRuleTemplateFromRepositories$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetCommitsResponse> batchGetCommits(BatchGetCommitsRequest batchGetCommitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetCommitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetCommitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetCommits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetCommitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetCommits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetCommitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetCommitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchGetCommits$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchGetCommits$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetRepositoriesResponse> batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetRepositoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetRepositories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchGetRepositories$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchGetRepositories$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApprovalRuleTemplateResponse> createApprovalRuleTemplate(CreateApprovalRuleTemplateRequest createApprovalRuleTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApprovalRuleTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createApprovalRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApprovalRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApprovalRuleTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApprovalRuleTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateApprovalRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApprovalRuleTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createApprovalRuleTemplate$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createApprovalRuleTemplate$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBranchResponse> createBranch(CreateBranchRequest createBranchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBranchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBranch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createBranch$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createBranch$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCommitResponse> createCommit(CreateCommitRequest createCommitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCommitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCommitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCommit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createCommit$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createCommit$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePullRequestResponse> createPullRequest(CreatePullRequestRequest createPullRequestRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPullRequestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createPullRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePullRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePullRequestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePullRequest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPullRequestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createPullRequest$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createPullRequest$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePullRequestApprovalRuleResponse> createPullRequestApprovalRule(CreatePullRequestApprovalRuleRequest createPullRequestApprovalRuleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPullRequestApprovalRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createPullRequestApprovalRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePullRequestApprovalRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePullRequestApprovalRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePullRequestApprovalRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePullRequestApprovalRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPullRequestApprovalRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createPullRequestApprovalRule$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createPullRequestApprovalRule$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createRepository$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createRepository$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUnreferencedMergeCommitResponse> createUnreferencedMergeCommit(CreateUnreferencedMergeCommitRequest createUnreferencedMergeCommitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUnreferencedMergeCommitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, createUnreferencedMergeCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUnreferencedMergeCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUnreferencedMergeCommitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUnreferencedMergeCommit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUnreferencedMergeCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUnreferencedMergeCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createUnreferencedMergeCommit$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createUnreferencedMergeCommit$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApprovalRuleTemplateResponse> deleteApprovalRuleTemplate(DeleteApprovalRuleTemplateRequest deleteApprovalRuleTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApprovalRuleTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApprovalRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApprovalRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApprovalRuleTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApprovalRuleTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApprovalRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApprovalRuleTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteApprovalRuleTemplate$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteApprovalRuleTemplate$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBranchResponse> deleteBranch(DeleteBranchRequest deleteBranchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBranchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
                    }
                    case "InvalidClientRequestTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
                    }
                    case "FolderContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
                    }
                    case "RepositoryNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
                    }
                    case "InvalidReferenceNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
                    }
                    case "CommentContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
                    }
                    case "InvalidTagKeysListException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
                    }
                    case "TagsMapRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
                    }
                    case "PathRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathRequiredException::builder).build());
                    }
                    case "InvalidSystemTagUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
                    }
                    case "CommitIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
                    }
                    case "InvalidParentCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
                    }
                    case "ReferenceNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
                    }
                    case "InvalidMaxConflictFilesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
                    }
                    case "MaximumRuleTemplatesAssociatedWithRepositoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
                    }
                    case "ApprovalRuleTemplateContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build());
                    }
                    case "InvalidCommentIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
                    }
                    case "InvalidApprovalStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
                    }
                    case "InvalidCommitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build());
                    }
                    case "NoChangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoChangeException::builder).build());
                    }
                    case "ApprovalRuleDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
                    }
                    case "MaximumFileContentToLoadExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build());
                    }
                    case "MultipleRepositoriesInPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build());
                    }
                    case "BlobIdDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
                    }
                    case "MergeOptionRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
                    }
                    case "InvalidPullRequestIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
                    }
                    case "ApprovalRuleTemplateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
                    }
                    case "FileDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
                    }
                    case "RepositoryNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
                    }
                    case "PathDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
                    }
                    case "BranchNameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameExistsException::builder).build());
                    }
                    case "EncryptionIntegrityChecksFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
                    }
                    case "InvalidCommitIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
                    }
                    case "InvalidOrderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOrderException::builder).build());
                    }
                    case "PullRequestAlreadyClosedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
                    }
                    case "BranchNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
                    }
                    case "InvalidRepositoryTriggerNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
                    }
                    case "InvalidMergeOptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
                    }
                    case "ParentCommitIdOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
                    }
                    case "CommitIdsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
                    }
                    case "InvalidContinuationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
                    }
                    case "MaximumFileEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
                    }
                    case "PullRequestApprovalRulesNotSatisfiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build());
                    }
                    case "ClientRequestTokenRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
                    }
                    case "NameLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NameLengthExceededException::builder).build());
                    }
                    case "EncryptionKeyDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
                    }
                    case "MultipleConflictResolutionEntriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "FileContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
                    }
                    case "ManualMergeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
                    }
                    case "InvalidRepositoryTriggerBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build());
                    }
                    case "SameFileContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SameFileContentException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "InvalidRepositoryTriggerRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
                    }
                    case "CommentContentSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "ParentCommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
                    }
                    case "FileEntryRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
                    }
                    case "InvalidActorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActorArnException::builder).build());
                    }
                    case "CommitIdsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
                    }
                    case "InvalidDestinationCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build());
                    }
                    case "RepositoryTriggerBranchNameListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
                    }
                    case "DirectoryNameConflictsWithFileNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build());
                    }
                    case "SourceAndDestinationAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
                    }
                    case "InvalidTitleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTitleException::builder).build());
                    }
                    case "EncryptionKeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
                    }
                    case "InvalidRepositoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
                    }
                    case "InvalidBranchNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
                    }
                    case "TargetsRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetsRequiredException::builder).build());
                    }
                    case "RepositoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
                    }
                    case "BranchNameIsTagNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
                    }
                    case "CommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
                    }
                    case "TitleRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TitleRequiredException::builder).build());
                    }
                    case "InvalidTargetsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetsException::builder).build());
                    }
                    case "MaximumRepositoryTriggersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
                    }
                    case "BlobIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
                    }
                    case "InvalidReplacementTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
                    }
                    case "RepositoryNamesRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
                    }
                    case "AuthorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
                    }
                    case "InvalidFilePositionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
                    }
                    case "FileNameConflictsWithDirectoryNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build());
                    }
                    case "InvalidResourceArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
                    }
                    case "EncryptionKeyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
                    }
                    case "PullRequestCannotBeApprovedByAuthorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build());
                    }
                    case "BranchDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
                    }
                    case "ReactionValueRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
                    }
                    case "ApprovalRuleTemplateNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build());
                    }
                    case "InvalidRepositoryTriggerCustomDataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build());
                    }
                    case "ApprovalRuleContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
                    }
                    case "MaximumRepositoryNamesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
                    }
                    case "RepositoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
                    }
                    case "InvalidRevisionIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
                    }
                    case "MaximumOpenPullRequestsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
                    }
                    case "DefaultBranchCannotBeDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
                    }
                    case "EncryptionKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
                    }
                    case "InvalidPathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPathException::builder).build());
                    }
                    case "InvalidConflictResolutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
                    }
                    case "EncryptionKeyRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build());
                    }
                    case "RepositoryTriggerDestinationArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build());
                    }
                    case "InvalidConflictResolutionStrategyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build());
                    }
                    case "InvalidAuthorArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
                    }
                    case "InvalidTargetBranchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
                    }
                    case "ReplacementTypeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
                    }
                    case "RepositoryTriggerNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
                    }
                    case "OperationNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
                    }
                    case "ApprovalStateRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
                    }
                    case "OverrideAlreadySetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
                    }
                    case "NumberOfRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
                    }
                    case "InvalidOverrideStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
                    }
                    case "ApprovalRuleNameRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
                    }
                    case "InvalidPullRequestStatusUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
                    }
                    case "ParentCommitIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
                    }
                    case "InvalidPullRequestEventTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
                    }
                    case "ActorDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
                    }
                    case "IdempotencyParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
                    }
                    case "NumberOfRuleTemplatesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
                    }
                    case "InvalidDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
                    }
                    case "FolderDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
                    }
                    case "PullRequestIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
                    }
                    case "TipOfSourceReferenceIsDifferentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
                    }
                    case "RepositoryTriggersListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
                    }
                    case "InvalidReplacementContentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
                    }
                    case "MaximumNumberOfApprovalsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build());
                    }
                    case "CommitMessageLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
                    }
                    case "InvalidMaxMergeHunksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
                    }
                    case "InvalidEmailException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailException::builder).build());
                    }
                    case "InvalidDeletionParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
                    }
                    case "InvalidRuleContentSha256Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
                    }
                    case "SourceFileOrContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
                    }
                    case "CommentIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
                    }
                    case "CommitRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitRequiredException::builder).build());
                    }
                    case "RevisionNotCurrentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
                    }
                    case "MaximumConflictResolutionEntriesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build());
                    }
                    case "CommentNotCreatedByCallerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
                    }
                    case "TargetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetRequiredException::builder).build());
                    }
                    case "InvalidTagsMapException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
                    }
                    case "RestrictedSourceFileException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
                    }
                    case "FileTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileTooLargeException::builder).build());
                    }
                    case "PutFileEntryConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
                    }
                    case "FileContentAndSourceFileSpecifiedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build());
                    }
                    case "PullRequestStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
                    }
                    case "ConcurrentReferenceUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
                    }
                    case "SamePathRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SamePathRequestException::builder).build());
                    }
                    case "TipsDivergenceExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
                    }
                    case "InvalidSortByException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSortByException::builder).build());
                    }
                    case "CannotDeleteApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build());
                    }
                    case "ReferenceDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
                    }
                    case "OverrideStatusRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
                    }
                    case "ApprovalRuleNameAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "InvalidFileModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileModeException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
                    }
                    case "InvalidSourceCommitSpecifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
                    }
                    case "ReplacementContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBranch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteBranch$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteBranch$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCommentContentResponse> deleteCommentContent(DeleteCommentContentRequest deleteCommentContentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCommentContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCommentContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCommentContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCommentContentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FileContentRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileContentRequiredException::builder).build());
                    }
                    case "InvalidApprovalRuleTemplateDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build());
                    }
                    case "ApprovalRuleTemplateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build());
                    }
                    case "CommentDeletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDeletedException::builder).build());
                    }
                    case "MaximumItemsToCompareExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
                    }
                    case "InvalidBlobIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
                    }
                    case "InvalidRepositoryDescriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
                    }
                    case "InvalidRepositoryTriggerDestinationArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build());
                    }
                    case "CommentDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
                    }
                    case "InvalidConflictDetailLevelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
                    }
                    case "ReactionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
                    }
                    case "BeforeCommitIdAndAfterCommitIdAreSameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build());
                    }
                    case "CannotModifyApprovalRuleFromTemplateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build());
                    }
                    case "RevisionIdRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
                    }
                    case "PullRequestDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
                    }
                    case "ReferenceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
                    }
                    case "FilePathConflictsWithSubmodulePathException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build());
                    }
                    case "RepositoryTriggerEventsListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build());
                    }
                    case "FileModeRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileModeRequiredException::builder).build());
                    }
                    case "CommitDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
                    }
                    case "ResourceArnRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                    }
                    case "InvalidReactionUserArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
                    }
                    case "InvalidRepositoryTriggerEventsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
                    }
                    case "RepositoryNotAssociatedWithPullRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build());
                    }
                    case "InvalidFileLocationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
                    }
                    case "MaximumBranchesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
                    }
                    case "EncryptionKeyInvalidIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
                    }
                    case "InvalidRelativeFileVersionEnumException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
                    }
                    case "InvalidReactionValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
                    }
                    case "TagKeysListRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
          