/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a pull request event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullRequestEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<PullRequestEvent.Builder, PullRequestEvent> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(PullRequestEvent::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<Instant> EVENT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventDate").getter(getter(PullRequestEvent::eventDate)).setter(setter(Builder::eventDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDate").build()).build();

    private static final SdkField<String> PULL_REQUEST_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestEventType").getter(getter(PullRequestEvent::pullRequestEventTypeAsString))
            .setter(setter(Builder::pullRequestEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEventType").build())
            .build();

    private static final SdkField<String> ACTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actorArn").getter(getter(PullRequestEvent::actorArn)).setter(setter(Builder::actorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorArn").build()).build();

    private static final SdkField<PullRequestCreatedEventMetadata> PULL_REQUEST_CREATED_EVENT_METADATA_FIELD = SdkField
            .<PullRequestCreatedEventMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("pullRequestCreatedEventMetadata")
            .getter(getter(PullRequestEvent::pullRequestCreatedEventMetadata))
            .setter(setter(Builder::pullRequestCreatedEventMetadata))
            .constructor(PullRequestCreatedEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestCreatedEventMetadata")
                    .build()).build();

    private static final SdkField<PullRequestStatusChangedEventMetadata> PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD = SdkField
            .<PullRequestStatusChangedEventMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("pullRequestStatusChangedEventMetadata")
            .getter(getter(PullRequestEvent::pullRequestStatusChangedEventMetadata))
            .setter(setter(Builder::pullRequestStatusChangedEventMetadata))
            .constructor(PullRequestStatusChangedEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("pullRequestStatusChangedEventMetadata").build()).build();

    private static final SdkField<PullRequestSourceReferenceUpdatedEventMetadata> PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD = SdkField
            .<PullRequestSourceReferenceUpdatedEventMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("pullRequestSourceReferenceUpdatedEventMetadata")
            .getter(getter(PullRequestEvent::pullRequestSourceReferenceUpdatedEventMetadata))
            .setter(setter(Builder::pullRequestSourceReferenceUpdatedEventMetadata))
            .constructor(PullRequestSourceReferenceUpdatedEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("pullRequestSourceReferenceUpdatedEventMetadata").build()).build();

    private static final SdkField<PullRequestMergedStateChangedEventMetadata> PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD = SdkField
            .<PullRequestMergedStateChangedEventMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("pullRequestMergedStateChangedEventMetadata")
            .getter(getter(PullRequestEvent::pullRequestMergedStateChangedEventMetadata))
            .setter(setter(Builder::pullRequestMergedStateChangedEventMetadata))
            .constructor(PullRequestMergedStateChangedEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("pullRequestMergedStateChangedEventMetadata").build()).build();

    private static final SdkField<ApprovalRuleEventMetadata> APPROVAL_RULE_EVENT_METADATA_FIELD = SdkField
            .<ApprovalRuleEventMetadata> builder(MarshallingType.SDK_POJO).memberName("approvalRuleEventMetadata")
            .getter(getter(PullRequestEvent::approvalRuleEventMetadata)).setter(setter(Builder::approvalRuleEventMetadata))
            .constructor(ApprovalRuleEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleEventMetadata").build())
            .build();

    private static final SdkField<ApprovalStateChangedEventMetadata> APPROVAL_STATE_CHANGED_EVENT_METADATA_FIELD = SdkField
            .<ApprovalStateChangedEventMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("approvalStateChangedEventMetadata")
            .getter(getter(PullRequestEvent::approvalStateChangedEventMetadata))
            .setter(setter(Builder::approvalStateChangedEventMetadata))
            .constructor(ApprovalStateChangedEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalStateChangedEventMetadata")
                    .build()).build();

    private static final SdkField<ApprovalRuleOverriddenEventMetadata> APPROVAL_RULE_OVERRIDDEN_EVENT_METADATA_FIELD = SdkField
            .<ApprovalRuleOverriddenEventMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("approvalRuleOverriddenEventMetadata")
            .getter(getter(PullRequestEvent::approvalRuleOverriddenEventMetadata))
            .setter(setter(Builder::approvalRuleOverriddenEventMetadata))
            .constructor(ApprovalRuleOverriddenEventMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("approvalRuleOverriddenEventMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            EVENT_DATE_FIELD, PULL_REQUEST_EVENT_TYPE_FIELD, ACTOR_ARN_FIELD, PULL_REQUEST_CREATED_EVENT_METADATA_FIELD,
            PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD, PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD,
            PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD, APPROVAL_RULE_EVENT_METADATA_FIELD,
            APPROVAL_STATE_CHANGED_EVENT_METADATA_FIELD, APPROVAL_RULE_OVERRIDDEN_EVENT_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pullRequestId;

    private final Instant eventDate;

    private final String pullRequestEventType;

    private final String actorArn;

    private final PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata;

    private final PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata;

    private final PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata;

    private final PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata;

    private final ApprovalRuleEventMetadata approvalRuleEventMetadata;

    private final ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata;

    private final ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata;

    private PullRequestEvent(BuilderImpl builder) {
        this.pullRequestId = builder.pullRequestId;
        this.eventDate = builder.eventDate;
        this.pullRequestEventType = builder.pullRequestEventType;
        this.actorArn = builder.actorArn;
        this.pullRequestCreatedEventMetadata = builder.pullRequestCreatedEventMetadata;
        this.pullRequestStatusChangedEventMetadata = builder.pullRequestStatusChangedEventMetadata;
        this.pullRequestSourceReferenceUpdatedEventMetadata = builder.pullRequestSourceReferenceUpdatedEventMetadata;
        this.pullRequestMergedStateChangedEventMetadata = builder.pullRequestMergedStateChangedEventMetadata;
        this.approvalRuleEventMetadata = builder.approvalRuleEventMetadata;
        this.approvalStateChangedEventMetadata = builder.approvalStateChangedEventMetadata;
        this.approvalRuleOverriddenEventMetadata = builder.approvalRuleOverriddenEventMetadata;
    }

    /**
     * <p>
     * The system-generated ID of the pull request.
     * </p>
     * 
     * @return The system-generated ID of the pull request.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The day and time of the pull request event, in timestamp format.
     * </p>
     * 
     * @return The day and time of the pull request event, in timestamp format.
     */
    public final Instant eventDate() {
        return eventDate;
    }

    /**
     * <p>
     * The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or update
     * event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullRequestEventType} will return {@link PullRequestEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pullRequestEventTypeAsString}.
     * </p>
     * 
     * @return The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or
     *         update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
     * @see PullRequestEventType
     */
    public final PullRequestEventType pullRequestEventType() {
        return PullRequestEventType.fromValue(pullRequestEventType);
    }

    /**
     * <p>
     * The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or update
     * event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullRequestEventType} will return {@link PullRequestEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pullRequestEventTypeAsString}.
     * </p>
     * 
     * @return The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or
     *         update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
     * @see PullRequestEventType
     */
    public final String pullRequestEventTypeAsString() {
        return pullRequestEventType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the
     * pull request with more commits or changing the status of a pull request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating
     *         the pull request with more commits or changing the status of a pull request.
     */
    public final String actorArn() {
        return actorArn;
    }

    /**
     * <p>
     * Information about the source and destination branches for the pull request.
     * </p>
     * 
     * @return Information about the source and destination branches for the pull request.
     */
    public final PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata() {
        return pullRequestCreatedEventMetadata;
    }

    /**
     * <p>
     * Information about the change in status for the pull request event.
     * </p>
     * 
     * @return Information about the change in status for the pull request event.
     */
    public final PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata() {
        return pullRequestStatusChangedEventMetadata;
    }

    /**
     * <p>
     * Information about the updated source branch for the pull request event.
     * </p>
     * 
     * @return Information about the updated source branch for the pull request event.
     */
    public final PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata() {
        return pullRequestSourceReferenceUpdatedEventMetadata;
    }

    /**
     * <p>
     * Information about the change in mergability state for the pull request event.
     * </p>
     * 
     * @return Information about the change in mergability state for the pull request event.
     */
    public final PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata() {
        return pullRequestMergedStateChangedEventMetadata;
    }

    /**
     * <p>
     * Information about a pull request event.
     * </p>
     * 
     * @return Information about a pull request event.
     */
    public final ApprovalRuleEventMetadata approvalRuleEventMetadata() {
        return approvalRuleEventMetadata;
    }

    /**
     * <p>
     * Information about an approval state change for a pull request.
     * </p>
     * 
     * @return Information about an approval state change for a pull request.
     */
    public final ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata() {
        return approvalStateChangedEventMetadata;
    }

    /**
     * <p>
     * Information about an approval rule override event for a pull request.
     * </p>
     * 
     * @return Information about an approval rule override event for a pull request.
     */
    public final ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata() {
        return approvalRuleOverriddenEventMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(eventDate());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actorArn());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestCreatedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestStatusChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestSourceReferenceUpdatedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestMergedStateChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStateChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleOverriddenEventMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestEvent)) {
            return false;
        }
        PullRequestEvent other = (PullRequestEvent) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(eventDate(), other.eventDate())
                && Objects.equals(pullRequestEventTypeAsString(), other.pullRequestEventTypeAsString())
                && Objects.equals(actorArn(), other.actorArn())
                && Objects.equals(pullRequestCreatedEventMetadata(), other.pullRequestCreatedEventMetadata())
                && Objects.equals(pullRequestStatusChangedEventMetadata(), other.pullRequestStatusChangedEventMetadata())
                && Objects.equals(pullRequestSourceReferenceUpdatedEventMetadata(),
                        other.pullRequestSourceReferenceUpdatedEventMetadata())
                && Objects.equals(pullRequestMergedStateChangedEventMetadata(),
                        other.pullRequestMergedStateChangedEventMetadata())
                && Objects.equals(approvalRuleEventMetadata(), other.approvalRuleEventMetadata())
                && Objects.equals(approvalStateChangedEventMetadata(), other.approvalStateChangedEventMetadata())
                && Objects.equals(approvalRuleOverriddenEventMetadata(), other.approvalRuleOverriddenEventMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PullRequestEvent").add("PullRequestId", pullRequestId()).add("EventDate", eventDate())
                .add("PullRequestEventType", pullRequestEventTypeAsString()).add("ActorArn", actorArn())
                .add("PullRequestCreatedEventMetadata", pullRequestCreatedEventMetadata())
                .add("PullRequestStatusChangedEventMetadata", pullRequestStatusChangedEventMetadata())
                .add("PullRequestSourceReferenceUpdatedEventMetadata", pullRequestSourceReferenceUpdatedEventMetadata())
                .add("PullRequestMergedStateChangedEventMetadata", pullRequestMergedStateChangedEventMetadata())
                .add("ApprovalRuleEventMetadata", approvalRuleEventMetadata())
                .add("ApprovalStateChangedEventMetadata", approvalStateChangedEventMetadata())
                .add("ApprovalRuleOverriddenEventMetadata", approvalRuleOverriddenEventMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "eventDate":
            return Optional.ofNullable(clazz.cast(eventDate()));
        case "pullRequestEventType":
            return Optional.ofNullable(clazz.cast(pullRequestEventTypeAsString()));
        case "actorArn":
            return Optional.ofNullable(clazz.cast(actorArn()));
        case "pullRequestCreatedEventMetadata":
            return Optional.ofNullable(clazz.cast(pullRequestCreatedEventMetadata()));
        case "pullRequestStatusChangedEventMetadata":
            return Optional.ofNullable(clazz.cast(pullRequestStatusChangedEventMetadata()));
        case "pullRequestSourceReferenceUpdatedEventMetadata":
            return Optional.ofNullable(clazz.cast(pullRequestSourceReferenceUpdatedEventMetadata()));
        case "pullRequestMergedStateChangedEventMetadata":
            return Optional.ofNullable(clazz.cast(pullRequestMergedStateChangedEventMetadata()));
        case "approvalRuleEventMetadata":
            return Optional.ofNullable(clazz.cast(approvalRuleEventMetadata()));
        case "approvalStateChangedEventMetadata":
            return Optional.ofNullable(clazz.cast(approvalStateChangedEventMetadata()));
        case "approvalRuleOverriddenEventMetadata":
            return Optional.ofNullable(clazz.cast(approvalRuleOverriddenEventMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pullRequestId", PULL_REQUEST_ID_FIELD);
        map.put("eventDate", EVENT_DATE_FIELD);
        map.put("pullRequestEventType", PULL_REQUEST_EVENT_TYPE_FIELD);
        map.put("actorArn", ACTOR_ARN_FIELD);
        map.put("pullRequestCreatedEventMetadata", PULL_REQUEST_CREATED_EVENT_METADATA_FIELD);
        map.put("pullRequestStatusChangedEventMetadata", PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD);
        map.put("pullRequestSourceReferenceUpdatedEventMetadata", PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD);
        map.put("pullRequestMergedStateChangedEventMetadata", PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD);
        map.put("approvalRuleEventMetadata", APPROVAL_RULE_EVENT_METADATA_FIELD);
        map.put("approvalStateChangedEventMetadata", APPROVAL_STATE_CHANGED_EVENT_METADATA_FIELD);
        map.put("approvalRuleOverriddenEventMetadata", APPROVAL_RULE_OVERRIDDEN_EVENT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PullRequestEvent, T> g) {
        return obj -> g.apply((PullRequestEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullRequestEvent> {
        /**
         * <p>
         * The system-generated ID of the pull request.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The day and time of the pull request event, in timestamp format.
         * </p>
         * 
         * @param eventDate
         *        The day and time of the pull request event, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDate(Instant eventDate);

        /**
         * <p>
         * The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or
         * update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
         * </p>
         * 
         * @param pullRequestEventType
         *        The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED)
         *        or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
         * @see PullRequestEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestEventType
         */
        Builder pullRequestEventType(String pullRequestEventType);

        /**
         * <p>
         * The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or
         * update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
         * </p>
         * 
         * @param pullRequestEventType
         *        The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED)
         *        or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
         * @see PullRequestEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestEventType
         */
        Builder pullRequestEventType(PullRequestEventType pullRequestEventType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the
         * pull request with more commits or changing the status of a pull request.
         * </p>
         * 
         * @param actorArn
         *        The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include
         *        updating the pull request with more commits or changing the status of a pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actorArn(String actorArn);

        /**
         * <p>
         * Information about the source and destination branches for the pull request.
         * </p>
         * 
         * @param pullRequestCreatedEventMetadata
         *        Information about the source and destination branches for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata);

        /**
         * <p>
         * Information about the source and destination branches for the pull request.
         * </p>
         * This is a convenience method that creates an instance of the {@link PullRequestCreatedEventMetadata.Builder}
         * avoiding the need to create one manually via {@link PullRequestCreatedEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PullRequestCreatedEventMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata)}.
         * 
         * @param pullRequestCreatedEventMetadata
         *        a consumer that will call methods on {@link PullRequestCreatedEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata)
         */
        default Builder pullRequestCreatedEventMetadata(
                Consumer<PullRequestCreatedEventMetadata.Builder> pullRequestCreatedEventMetadata) {
            return pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata.builder()
                    .applyMutation(pullRequestCreatedEventMetadata).build());
        }

        /**
         * <p>
         * Information about the change in status for the pull request event.
         * </p>
         * 
         * @param pullRequestStatusChangedEventMetadata
         *        Information about the change in status for the pull request event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata);

        /**
         * <p>
         * Information about the change in status for the pull request event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PullRequestStatusChangedEventMetadata.Builder} avoiding the need to create one manually via
         * {@link PullRequestStatusChangedEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PullRequestStatusChangedEventMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata)}.
         * 
         * @param pullRequestStatusChangedEventMetadata
         *        a consumer that will call methods on {@link PullRequestStatusChangedEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata)
         */
        default Builder pullRequestStatusChangedEventMetadata(
                Consumer<PullRequestStatusChangedEventMetadata.Builder> pullRequestStatusChangedEventMetadata) {
            return pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata.builder()
                    .applyMutation(pullRequestStatusChangedEventMetadata).build());
        }

        /**
         * <p>
         * Information about the updated source branch for the pull request event.
         * </p>
         * 
         * @param pullRequestSourceReferenceUpdatedEventMetadata
         *        Information about the updated source branch for the pull request event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestSourceReferenceUpdatedEventMetadata(
                PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata);

        /**
         * <p>
         * Information about the updated source branch for the pull request event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PullRequestSourceReferenceUpdatedEventMetadata.Builder} avoiding the need to create one manually via
         * {@link PullRequestSourceReferenceUpdatedEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PullRequestSourceReferenceUpdatedEventMetadata.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata)}.
         * 
         * @param pullRequestSourceReferenceUpdatedEventMetadata
         *        a consumer that will call methods on {@link PullRequestSourceReferenceUpdatedEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata)
         */
        default Builder pullRequestSourceReferenceUpdatedEventMetadata(
                Consumer<PullRequestSourceReferenceUpdatedEventMetadata.Builder> pullRequestSourceReferenceUpdatedEventMetadata) {
            return pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata.builder()
                    .applyMutation(pullRequestSourceReferenceUpdatedEventMetadata).build());
        }

        /**
         * <p>
         * Information about the change in mergability state for the pull request event.
         * </p>
         * 
         * @param pullRequestMergedStateChangedEventMetadata
         *        Information about the change in mergability state for the pull request event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestMergedStateChangedEventMetadata(
                PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata);

        /**
         * <p>
         * Information about the change in mergability state for the pull request event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PullRequestMergedStateChangedEventMetadata.Builder} avoiding the need to create one manually via
         * {@link PullRequestMergedStateChangedEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PullRequestMergedStateChangedEventMetadata.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata)}.
         * 
         * @param pullRequestMergedStateChangedEventMetadata
         *        a consumer that will call methods on {@link PullRequestMergedStateChangedEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata)
         */
        default Builder pullRequestMergedStateChangedEventMetadata(
                Consumer<PullRequestMergedStateChangedEventMetadata.Builder> pullRequestMergedStateChangedEventMetadata) {
            return pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata.builder()
                    .applyMutation(pullRequestMergedStateChangedEventMetadata).build());
        }

        /**
         * <p>
         * Information about a pull request event.
         * </p>
         * 
         * @param approvalRuleEventMetadata
         *        Information about a pull request event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleEventMetadata(ApprovalRuleEventMetadata approvalRuleEventMetadata);

        /**
         * <p>
         * Information about a pull request event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalRuleEventMetadata.Builder}
         * avoiding the need to create one manually via {@link ApprovalRuleEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalRuleEventMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #approvalRuleEventMetadata(ApprovalRuleEventMetadata)}.
         * 
         * @param approvalRuleEventMetadata
         *        a consumer that will call methods on {@link ApprovalRuleEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRuleEventMetadata(ApprovalRuleEventMetadata)
         */
        default Builder approvalRuleEventMetadata(Consumer<ApprovalRuleEventMetadata.Builder> approvalRuleEventMetadata) {
            return approvalRuleEventMetadata(ApprovalRuleEventMetadata.builder().applyMutation(approvalRuleEventMetadata).build());
        }

        /**
         * <p>
         * Information about an approval state change for a pull request.
         * </p>
         * 
         * @param approvalStateChangedEventMetadata
         *        Information about an approval state change for a pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata);

        /**
         * <p>
         * Information about an approval state change for a pull request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApprovalStateChangedEventMetadata.Builder} avoiding the need to create one manually via
         * {@link ApprovalStateChangedEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalStateChangedEventMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata)}.
         * 
         * @param approvalStateChangedEventMetadata
         *        a consumer that will call methods on {@link ApprovalStateChangedEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata)
         */
        default Builder approvalStateChangedEventMetadata(
                Consumer<ApprovalStateChangedEventMetadata.Builder> approvalStateChangedEventMetadata) {
            return approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata.builder()
                    .applyMutation(approvalStateChangedEventMetadata).build());
        }

        /**
         * <p>
         * Information about an approval rule override event for a pull request.
         * </p>
         * 
         * @param approvalRuleOverriddenEventMetadata
         *        Information about an approval rule override event for a pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata);

        /**
         * <p>
         * Information about an approval rule override event for a pull request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApprovalRuleOverriddenEventMetadata.Builder} avoiding the need to create one manually via
         * {@link ApprovalRuleOverriddenEventMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalRuleOverriddenEventMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #approvalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata)}.
         * 
         * @param approvalRuleOverriddenEventMetadata
         *        a consumer that will call methods on {@link ApprovalRuleOverriddenEventMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata)
         */
        default Builder approvalRuleOverriddenEventMetadata(
                Consumer<ApprovalRuleOverriddenEventMetadata.Builder> approvalRuleOverriddenEventMetadata) {
            return approvalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata.builder()
                    .applyMutation(approvalRuleOverriddenEventMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String pullRequestId;

        private Instant eventDate;

        private String pullRequestEventType;

        private String actorArn;

        private PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata;

        private PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata;

        private PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata;

        private PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata;

        private ApprovalRuleEventMetadata approvalRuleEventMetadata;

        private ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata;

        private ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestEvent model) {
            pullRequestId(model.pullRequestId);
            eventDate(model.eventDate);
            pullRequestEventType(model.pullRequestEventType);
            actorArn(model.actorArn);
            pullRequestCreatedEventMetadata(model.pullRequestCreatedEventMetadata);
            pullRequestStatusChangedEventMetadata(model.pullRequestStatusChangedEventMetadata);
            pullRequestSourceReferenceUpdatedEventMetadata(model.pullRequestSourceReferenceUpdatedEventMetadata);
            pullRequestMergedStateChangedEventMetadata(model.pullRequestMergedStateChangedEventMetadata);
            approvalRuleEventMetadata(model.approvalRuleEventMetadata);
            approvalStateChangedEventMetadata(model.approvalStateChangedEventMetadata);
            approvalRuleOverriddenEventMetadata(model.approvalRuleOverriddenEventMetadata);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final Instant getEventDate() {
            return eventDate;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public final String getPullRequestEventType() {
            return pullRequestEventType;
        }

        public final void setPullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
        }

        @Override
        public final Builder pullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
            return this;
        }

        @Override
        public final Builder pullRequestEventType(PullRequestEventType pullRequestEventType) {
            this.pullRequestEventType(pullRequestEventType == null ? null : pullRequestEventType.toString());
            return this;
        }

        public final String getActorArn() {
            return actorArn;
        }

        public final void setActorArn(String actorArn) {
            this.actorArn = actorArn;
        }

        @Override
        public final Builder actorArn(String actorArn) {
            this.actorArn = actorArn;
            return this;
        }

        public final PullRequestCreatedEventMetadata.Builder getPullRequestCreatedEventMetadata() {
            return pullRequestCreatedEventMetadata != null ? pullRequestCreatedEventMetadata.toBuilder() : null;
        }

        public final void setPullRequestCreatedEventMetadata(
                PullRequestCreatedEventMetadata.BuilderImpl pullRequestCreatedEventMetadata) {
            this.pullRequestCreatedEventMetadata = pullRequestCreatedEventMetadata != null ? pullRequestCreatedEventMetadata
                    .build() : null;
        }

        @Override
        public final Builder pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata) {
            this.pullRequestCreatedEventMetadata = pullRequestCreatedEventMetadata;
            return this;
        }

        public final PullRequestStatusChangedEventMetadata.Builder getPullRequestStatusChangedEventMetadata() {
            return pullRequestStatusChangedEventMetadata != null ? pullRequestStatusChangedEventMetadata.toBuilder() : null;
        }

        public final void setPullRequestStatusChangedEventMetadata(
                PullRequestStatusChangedEventMetadata.BuilderImpl pullRequestStatusChangedEventMetadata) {
            this.pullRequestStatusChangedEventMetadata = pullRequestStatusChangedEventMetadata != null ? pullRequestStatusChangedEventMetadata
                    .build() : null;
        }

        @Override
        public final Builder pullRequestStatusChangedEventMetadata(
                PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata) {
            this.pullRequestStatusChangedEventMetadata = pullRequestStatusChangedEventMetadata;
            return this;
        }

        public final PullRequestSourceReferenceUpdatedEventMetadata.Builder getPullRequestSourceReferenceUpdatedEventMetadata() {
            return pullRequestSourceReferenceUpdatedEventMetadata != null ? pullRequestSourceReferenceUpdatedEventMetadata
                    .toBuilder() : null;
        }

        public final void setPullRequestSourceReferenceUpdatedEventMetadata(
                PullRequestSourceReferenceUpdatedEventMetadata.BuilderImpl pullRequestSourceReferenceUpdatedEventMetadata) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = pullRequestSourceReferenceUpdatedEventMetadata != null ? pullRequestSourceReferenceUpdatedEventMetadata
                    .build() : null;
        }

        @Override
        public final Builder pullRequestSourceReferenceUpdatedEventMetadata(
                PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = pullRequestSourceReferenceUpdatedEventMetadata;
            return this;
        }

        public final PullRequestMergedStateChangedEventMetadata.Builder getPullRequestMergedStateChangedEventMetadata() {
            return pullRequestMergedStateChangedEventMetadata != null ? pullRequestMergedStateChangedEventMetadata.toBuilder()
                    : null;
        }

        public final void setPullRequestMergedStateChangedEventMetadata(
                PullRequestMergedStateChangedEventMetadata.BuilderImpl pullRequestMergedStateChangedEventMetadata) {
            this.pullRequestMergedStateChangedEventMetadata = pullRequestMergedStateChangedEventMetadata != null ? pullRequestMergedStateChangedEventMetadata
                    .build() : null;
        }

        @Override
        public final Builder pullRequestMergedStateChangedEventMetadata(
                PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata) {
            this.pullRequestMergedStateChangedEventMetadata = pullRequestMergedStateChangedEventMetadata;
            return this;
        }

        public final ApprovalRuleEventMetadata.Builder getApprovalRuleEventMetadata() {
            return approvalRuleEventMetadata != null ? approvalRuleEventMetadata.toBuilder() : null;
        }

        public final void setApprovalRuleEventMetadata(ApprovalRuleEventMetadata.BuilderImpl approvalRuleEventMetadata) {
            this.approvalRuleEventMetadata = approvalRuleEventMetadata != null ? approvalRuleEventMetadata.build() : null;
        }

        @Override
        public final Builder approvalRuleEventMetadata(ApprovalRuleEventMetadata approvalRuleEventMetadata) {
            this.approvalRuleEventMetadata = approvalRuleEventMetadata;
            return this;
        }

        public final ApprovalStateChangedEventMetadata.Builder getApprovalStateChangedEventMetadata() {
            return approvalStateChangedEventMetadata != null ? approvalStateChangedEventMetadata.toBuilder() : null;
        }

        public final void setApprovalStateChangedEventMetadata(
                ApprovalStateChangedEventMetadata.BuilderImpl approvalStateChangedEventMetadata) {
            this.approvalStateChangedEventMetadata = approvalStateChangedEventMetadata != null ? approvalStateChangedEventMetadata
                    .build() : null;
        }

        @Override
        public final Builder approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata) {
            this.approvalStateChangedEventMetadata = approvalStateChangedEventMetadata;
            return this;
        }

        public final ApprovalRuleOverriddenEventMetadata.Builder getApprovalRuleOverriddenEventMetadata() {
            return approvalRuleOverriddenEventMetadata != null ? approvalRuleOverriddenEventMetadata.toBuilder() : null;
        }

        public final void setApprovalRuleOverriddenEventMetadata(
                ApprovalRuleOverriddenEventMetadata.BuilderImpl approvalRuleOverriddenEventMetadata) {
            this.approvalRuleOverriddenEventMetadata = approvalRuleOverriddenEventMetadata != null ? approvalRuleOverriddenEventMetadata
                    .build() : null;
        }

        @Override
        public final Builder approvalRuleOverriddenEventMetadata(
                ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata) {
            this.approvalRuleOverriddenEventMetadata = approvalRuleOverriddenEventMetadata;
            return this;
        }

        @Override
        public PullRequestEvent build() {
            return new PullRequestEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
