/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codecommit.model.ActorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.AuthorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BeforeCommitIdAndAfterCommitIdAreSameException;
import software.amazon.awssdk.services.codecommit.model.BlobIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BlobIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.BranchDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BranchNameExistsException;
import software.amazon.awssdk.services.codecommit.model.BranchNameIsTagNameException;
import software.amazon.awssdk.services.codecommit.model.BranchNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ClientRequestTokenRequiredException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CommentContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommentDeletedException;
import software.amazon.awssdk.services.codecommit.model.CommentDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommentIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentNotCreatedByCallerException;
import software.amazon.awssdk.services.codecommit.model.CommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitMessageLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitRequiredException;
import software.amazon.awssdk.services.codecommit.model.ConcurrentReferenceUpdateException;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreateCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.DefaultBranchCannotBeDeletedException;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DirectoryNameConflictsWithFileNameException;
import software.amazon.awssdk.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyAccessDeniedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyDisabledException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyNotFoundException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyUnavailableException;
import software.amazon.awssdk.services.codecommit.model.FileContentAndSourceFileSpecifiedException;
import software.amazon.awssdk.services.codecommit.model.FileContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FileDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.FileEntryRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileModeRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileNameConflictsWithDirectoryNameException;
import software.amazon.awssdk.services.codecommit.model.FilePathConflictsWithSubmodulePathException;
import software.amazon.awssdk.services.codecommit.model.FileTooLargeException;
import software.amazon.awssdk.services.codecommit.model.FolderContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FolderDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.codecommit.model.InvalidActorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidAuthorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidBlobIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidClientRequestTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommentIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictDetailLevelException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionStrategyException;
import software.amazon.awssdk.services.codecommit.model.InvalidContinuationTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidDeletionParameterException;
import software.amazon.awssdk.services.codecommit.model.InvalidDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidDestinationCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidEmailException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileLocationException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileModeException;
import software.amazon.awssdk.services.codecommit.model.InvalidFilePositionException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxConflictFilesException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxMergeHunksException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.codecommit.model.InvalidMergeOptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidOrderException;
import software.amazon.awssdk.services.codecommit.model.InvalidParentCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPathException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestEventTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusUpdateException;
import software.amazon.awssdk.services.codecommit.model.InvalidReferenceNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRelativeFileVersionEnumException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import software.amazon.awssdk.services.codecommit.model.InvalidResourceArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidSortByException;
import software.amazon.awssdk.services.codecommit.model.InvalidSourceCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidSystemTagUsageException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagKeysListException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagsMapException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetBranchException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetsException;
import software.amazon.awssdk.services.codecommit.model.InvalidTitleException;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codecommit.model.ManualMergeRequiredException;
import software.amazon.awssdk.services.codecommit.model.MaximumBranchesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumConflictResolutionEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileContentToLoadExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumItemsToCompareExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumOpenPullRequestsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryNamesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MergeOptionRequiredException;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MultipleConflictResolutionEntriesException;
import software.amazon.awssdk.services.codecommit.model.MultipleRepositoriesInPullRequestException;
import software.amazon.awssdk.services.codecommit.model.NameLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.NoChangeException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdOutdatedException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PathDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PathRequiredException;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestAlreadyClosedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.PutFileEntryConflictException;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ReferenceDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ReferenceNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceTypeNotSupportedException;
import software.amazon.awssdk.services.codecommit.model.ReplacementContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReplacementTypeRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.RepositoryLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameExistsException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNamesRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotAssociatedWithPullRequestException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListRequiredException;
import software.amazon.awssdk.services.codecommit.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RestrictedSourceFileException;
import software.amazon.awssdk.services.codecommit.model.SameFileContentException;
import software.amazon.awssdk.services.codecommit.model.SamePathRequestException;
import software.amazon.awssdk.services.codecommit.model.SourceAndDestinationAreSameException;
import software.amazon.awssdk.services.codecommit.model.SourceFileOrContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagKeysListRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagPolicyException;
import software.amazon.awssdk.services.codecommit.model.TagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.TagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.TagsMapRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetsRequiredException;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TipOfSourceReferenceIsDifferentException;
import software.amazon.awssdk.services.codecommit.model.TipsDivergenceExceededException;
import software.amazon.awssdk.services.codecommit.model.TitleRequiredException;
import software.amazon.awssdk.services.codecommit.model.TooManyTagsException;
import software.amazon.awssdk.services.codecommit.model.UntagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.UntagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher;
import software.amazon.awssdk.services.codecommit.transform.BatchDescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetCommitsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateUnreferencedMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteCommentContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribePullRequestEventsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBlobRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetDifferencesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeOptionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListPullRequestsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentReplyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TestRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateDefaultBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestTitleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryNameRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CodeCommitAsyncClient}.
 *
 * @see CodeCommitAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeCommitAsyncClient implements CodeCommitAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeCommitAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeCommitAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy.
     * </p>
     *
     * @param batchDescribeMergeConflictsRequest
     * @return A Java Future containing the result of the BatchDescribeMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchDescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDescribeMergeConflictsResponse> batchDescribeMergeConflicts(
            BatchDescribeMergeConflictsRequest batchDescribeMergeConflictsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDescribeMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDescribeMergeConflictsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDescribeMergeConflictsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeMergeConflictsRequest, BatchDescribeMergeConflictsResponse>()
                            .withOperationName("BatchDescribeMergeConflicts")
                            .withMarshaller(new BatchDescribeMergeConflictsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchDescribeMergeConflictsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the contents of one or more commits in a repository.
     * </p>
     *
     * @param batchGetCommitsRequest
     * @return A Java Future containing the result of the BatchGetCommits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommitIdsListRequiredException</li>
     *         <li>CommitIdsLimitExceededException The maximum number of allowed commit IDs in a batch request is 100.
     *         Verify that your batch requests contains no more than 100 commit IDs, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchGetCommits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetCommits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetCommitsResponse> batchGetCommits(BatchGetCommitsRequest batchGetCommitsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetCommitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetCommitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetCommitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetCommitsRequest, BatchGetCommitsResponse>()
                            .withOperationName("BatchGetCommits")
                            .withMarshaller(new BatchGetCommitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchGetCommitsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more repositories.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a web page could expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a web page.
     * </p>
     * </note>
     *
     * @param batchGetRepositoriesRequest
     *        Represents the input of a batch get repositories operation.
     * @return A Java Future containing the result of the BatchGetRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNamesRequiredException A repository names object is required but was not specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 25.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchGetRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetRepositoriesResponse> batchGetRepositories(
            BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetRepositoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetRepositoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetRepositoriesRequest, BatchGetRepositoriesResponse>()
                            .withOperationName("BatchGetRepositories")
                            .withMarshaller(new BatchGetRepositoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchGetRepositoriesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new branch in a repository and points the branch to a commit.
     * </p>
     * <note>
     * <p>
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update
     * default branch operation.
     * </p>
     * </note>
     *
     * @param createBranchRequest
     *        Represents the input of a create branch operation.
     * @return A Java Future containing the result of the CreateBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>BranchNameExistsException The specified branch name already exists.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBranchResponse> createBranch(CreateBranchRequest createBranchRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBranchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBranchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBranchRequest, CreateBranchResponse>()
                            .withOperationName("CreateBranch").withMarshaller(new CreateBranchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createBranchRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a commit for a repository on the tip of a specified branch.
     * </p>
     *
     * @param createCommitRequest
     * @return A Java Future containing the result of the CreateCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Type
     *         the name of a current branch in the repository. For a list of valid branch names, use
     *         <a>ListBranches</a>.</li>
     *         <li>FileEntryRequiredException The commit cannot be created because no files have been specified as
     *         added, updated, or changed (PutFile or DeleteFile) for the commit.</li>
     *         <li>MaximumFileEntriesExceededException The number of specified files to change as part of this commit
     *         exceeds the maximum number of files that can be changed in a single commit. Consider using a Git client
     *         for these changes.</li>
     *         <li>PutFileEntryConflictException The commit cannot be created because one or more files specified in the
     *         commit reference both a file and a folder.</li>
     *         <li>SourceFileOrContentRequiredException The commit cannot be created because no source files or file
     *         content have been specified for the commit.</li>
     *         <li>FileContentAndSourceFileSpecifiedException The commit cannot be created because both a source file
     *         and file content have been specified for the same file. You cannot provide both. Either specify a source
     *         file, or provide the file content directly.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>SamePathRequestException The commit cannot be created because one or more changes in this commit
     *         duplicate actions in the same file path. For example, you cannot make the same delete request to the same
     *         file in the same file path twice, or make a delete request and a move request to the same file as part of
     *         the same commit.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have provided the
     *         correct name of the file, including its full path and extension.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>InvalidDeletionParameterException The specified deletion parameter is not valid.</li>
     *         <li>RestrictedSourceFileException The commit cannot be created because one of the changes specifies
     *         copying or moving a .gitkeep file.</li>
     *         <li>FileModeRequiredException The commit cannot be created because a file mode is required to update mode
     *         permissions for an existing file, but no file mode has been specified.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>NoChangeException The commit cannot be created because no changes will be made to the repository as a
     *         result of this commit. A commit must contain at least one change.</li>
     *         <li>FileNameConflictsWithDirectoryNameException A file cannot be added to the repository because the
     *         specified file name has the same name as a directory in this repository. Either provide another name for
     *         the file, or add the file in a directory that does not match the file name.</li>
     *         <li>DirectoryNameConflictsWithFileNameException A file cannot be added to the repository because the
     *         specified path name has the same name as a file that already exists in this repository. Either provide a
     *         different name for the file, or specify a different path for the file.</li>
     *         <li>FilePathConflictsWithSubmodulePathException The commit cannot be created because a specified file
     *         path points to a submodule. Verify that the destination files have valid file paths that do not point to
     *         a submodule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCommitResponse> createCommit(CreateCommitRequest createCommitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCommitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateCommitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCommitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCommitRequest, CreateCommitResponse>()
                            .withOperationName("CreateCommit").withMarshaller(new CreateCommitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCommitRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a pull request in the specified repository.
     * </p>
     *
     * @param createPullRequestRequest
     * @return A Java Future containing the result of the CreatePullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that when provided in a request, ensures the request cannot be
     *         repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request will return information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be re-used.</li>
     *         <li>ReferenceNameRequiredException A reference name is required, but none was provided.</li>
     *         <li>InvalidReferenceNameException The specified reference name format is not valid. Reference names must
     *         conform to the Git references format, for example refs/heads/master. For more information, see <a
     *         href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or
     *         consult your Git documentation.</li>
     *         <li>ReferenceDoesNotExistException The specified reference does not exist. You must provide a full commit
     *         ID.</li>
     *         <li>ReferenceTypeNotSupportedException The specified reference is not a supported type.</li>
     *         <li>TitleRequiredException A pull request title is required. It cannot be empty or null.</li>
     *         <li>InvalidTitleException The title of the pull request is not valid. Pull request titles cannot exceed
     *         100 characters in length.</li>
     *         <li>InvalidDescriptionException The pull request description is not valid. Descriptions are limited to
     *         1,000 characters in length.</li>
     *         <li>TargetsRequiredException An array of target objects is required. It cannot be empty or null.</li>
     *         <li>InvalidTargetsException The targets for the pull request is not valid or not in a valid format.
     *         Targets are a list of target objects. Each target object must contain the full values for the repository
     *         name, source branch, and destination branch for a pull request.</li>
     *         <li>TargetRequiredException A pull request target is required. It cannot be empty or null. A pull request
     *         target must contain the full values for the repository name, source branch, and destination branch for
     *         the pull request.</li>
     *         <li>InvalidTargetException The target for the pull request is not valid. A target must contain the full
     *         values for the repository name, source branch, and destination branch for the pull request.</li>
     *         <li>MultipleRepositoriesInPullRequestException You cannot include more than one repository in a pull
     *         request. Make sure you have specified only one repository name in your request, and then try again.</li>
     *         <li>MaximumOpenPullRequestsExceededException You cannot create the pull request because the repository
     *         has too many open pull requests. The maximum number of open pull requests for a repository is 1,000.
     *         Close one or more open pull requests, and then try again.</li>
     *         <li>SourceAndDestinationAreSameException The source branch and the destination branch for the pull
     *         request are the same. You must specify different branches for the source and destination.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreatePullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePullRequestResponse> createPullRequest(CreatePullRequestRequest createPullRequestRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePullRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePullRequestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePullRequestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePullRequestRequest, CreatePullRequestResponse>()
                            .withOperationName("CreatePullRequest")
                            .withMarshaller(new CreatePullRequestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createPullRequestRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new, empty repository.
     * </p>
     *
     * @param createRepositoryRequest
     *        Represents the input of a create repository operation.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameExistsException The specified repository name already exists.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidRepositoryDescriptionException The specified repository description is not valid.</li>
     *         <li>RepositoryLimitExceededException A repository resource limit was exceeded.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidTagsMapException The map of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRepositoryRequest, CreateRepositoryResponse>()
                            .withOperationName("CreateRepository")
                            .withMarshaller(new CreateRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRepositoryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge
     * strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the
     * fast-forward merge strategy, as that strategy does not create a merge commit.
     * </p>
     * <note>
     * <p>
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git
     * fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     * </p>
     * </note>
     *
     * @param createUnreferencedMergeCommitRequest
     * @return A Java Future containing the result of the CreateUnreferencedMergeCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified but no replacement content has been
     *         provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>FileModeRequiredException The commit cannot be created because a file mode is required to update mode
     *         permissions for an existing file, but no file mode has been specified.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateUnreferencedMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateUnreferencedMergeCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUnreferencedMergeCommitResponse> createUnreferencedMergeCommit(
            CreateUnreferencedMergeCommitRequest createUnreferencedMergeCommitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUnreferencedMergeCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUnreferencedMergeCommitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUnreferencedMergeCommitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUnreferencedMergeCommitRequest, CreateUnreferencedMergeCommitResponse>()
                            .withOperationName("CreateUnreferencedMergeCommit")
                            .withMarshaller(new CreateUnreferencedMergeCommitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createUnreferencedMergeCommitRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     * </p>
     *
     * @param deleteBranchRequest
     *        Represents the input of a delete branch operation.
     * @return A Java Future containing the result of the DeleteBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>DefaultBranchCannotBeDeletedException The specified branch is the default branch for the repository,
     *         and cannot be deleted. To delete this branch, you must first set another branch as the default branch.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBranchResponse> deleteBranch(DeleteBranchRequest deleteBranchRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBranchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBranchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBranchRequest, DeleteBranchResponse>()
                            .withOperationName("DeleteBranch").withMarshaller(new DeleteBranchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteBranchRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     * </p>
     *
     * @param deleteCommentContentRequest
     * @return A Java Future containing the result of the DeleteCommentContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have provided
     *         the correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteCommentContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCommentContentResponse> deleteCommentContent(
            DeleteCommentContentRequest deleteCommentContentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCommentContentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCommentContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCommentContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCommentContentRequest, DeleteCommentContentResponse>()
                            .withOperationName("DeleteCommentContent")
                            .withMarshaller(new DeleteCommentContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteCommentContentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision.
     * The file will still exist in the commits prior to the commit that contains the deletion.
     * </p>
     *
     * @param deleteFileRequest
     * @return A Java Future containing the result of the DeleteFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have provided the
     *         correct name of the file, including its full path and extension.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Type
     *         the name of a current branch in the repository. For a list of valid branch names, use
     *         <a>ListBranches</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteFile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFileResponse> deleteFile(DeleteFileRequest deleteFileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFileRequest, DeleteFileResponse>().withOperationName("DeleteFile")
                            .withMarshaller(new DeleteFileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a repository. If a specified repository was already deleted, a null repository ID will be returned.
     * </p>
     * <important>
     * <p>
     * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future
     * push calls to the deleted repository will fail.
     * </p>
     * </important>
     *
     * @param deleteRepositoryRequest
     *        Represents the input of a delete repository operation.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRepositoryRequest, DeleteRepositoryResponse>()
                            .withOperationName("DeleteRepository")
                            .withMarshaller(new DeleteRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRepositoryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception will be thrown.
     * </p>
     *
     * @param describeMergeConflictsRequest
     * @return A Java Future containing the result of the DescribeMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have provided the
     *         correct name of the file, including its full path and extension.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMergeConflictsResponse> describeMergeConflicts(
            DescribeMergeConflictsRequest describeMergeConflictsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMergeConflictsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMergeConflictsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMergeConflictsRequest, DescribeMergeConflictsResponse>()
                            .withOperationName("DescribeMergeConflicts")
                            .withMarshaller(new DescribeMergeConflictsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeMergeConflictsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception will be thrown.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher publisher = client.describeMergeConflictsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher publisher = client.describeMergeConflictsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMergeConflictsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have provided the
     *         correct name of the file, including its full path and extension.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMergeConflictsPublisher describeMergeConflictsPaginator(
            DescribeMergeConflictsRequest describeMergeConflictsRequest) {
        return new DescribeMergeConflictsPublisher(this, applyPaginatorUserAgent(describeMergeConflictsRequest));
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     *
     * @param describePullRequestEventsRequest
     * @return A Java Future containing the result of the DescribePullRequestEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestEventTypeException The pull request event type is not valid.</li>
     *         <li>InvalidActorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the user who initiated the change for the pull request, and then try again.</li>
     *         <li>ActorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePullRequestEventsResponse> describePullRequestEvents(
            DescribePullRequestEventsRequest describePullRequestEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePullRequestEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePullRequestEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePullRequestEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePullRequestEventsRequest, DescribePullRequestEventsResponse>()
                            .withOperationName("DescribePullRequestEvents")
                            .withMarshaller(new DescribePullRequestEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePullRequestEventsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher publisher = client.describePullRequestEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher publisher = client.describePullRequestEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePullRequestEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestEventTypeException The pull request event type is not valid.</li>
     *         <li>InvalidActorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the user who initiated the change for the pull request, and then try again.</li>
     *         <li>ActorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribePullRequestEventsPublisher describePullRequestEventsPaginator(
            DescribePullRequestEventsRequest describePullRequestEventsRequest) {
        return new DescribePullRequestEventsPublisher(this, applyPaginatorUserAgent(describePullRequestEventsRequest));
    }

    /**
     * <p>
     * Returns the base-64 encoded content of an individual blob within a repository.
     * </p>
     *
     * @param getBlobRequest
     *        Represents the input of a get blob operation.
     * @return A Java Future containing the result of the GetBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>BlobIdRequiredException A blob ID is required but was not specified.</li>
     *         <li>InvalidBlobIdException The specified blob is not valid.</li>
     *         <li>BlobIdDoesNotExistException The specified blob does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>FileTooLargeException The specified file exceeds the file size limit for AWS CodeCommit. For more
     *         information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlobResponse> getBlob(GetBlobRequest getBlobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBlobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBlobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBlobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBlobRequest, GetBlobResponse>().withOperationName("GetBlob")
                            .withMarshaller(new GetBlobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getBlobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a repository branch, including its name and the last commit ID.
     * </p>
     *
     * @param getBranchRequest
     *        Represents the input of a get branch operation.
     * @return A Java Future containing the result of the GetBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBranchResponse> getBranch(GetBranchRequest getBranchRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBranchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBranchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBranchRequest, GetBranchResponse>().withOperationName("GetBranch")
                            .withMarshaller(new GetBranchRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getBranchRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the content of a comment made on a change, file, or commit in a repository.
     * </p>
     *
     * @param getCommentRequest
     * @return A Java Future containing the result of the GetComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have provided
     *         the correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCommentResponse> getComment(GetCommentRequest getCommentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCommentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCommentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCommentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCommentRequest, GetCommentResponse>().withOperationName("GetComment")
                            .withMarshaller(new GetCommentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCommentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     * @return A Java Future containing the result of the GetCommentsForComparedCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCommentsForComparedCommitResponse> getCommentsForComparedCommit(
            GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCommentsForComparedCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCommentsForComparedCommitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCommentsForComparedCommitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCommentsForComparedCommitRequest, GetCommentsForComparedCommitResponse>()
                            .withOperationName("GetCommentsForComparedCommit")
                            .withMarshaller(new GetCommentsForComparedCommitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCommentsForComparedCommitRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher publisher = client.getCommentsForComparedCommitPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher publisher = client.getCommentsForComparedCommitPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    public GetCommentsForComparedCommitPublisher getCommentsForComparedCommitPaginator(
            GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) {
        return new GetCommentsForComparedCommitPublisher(this, applyPaginatorUserAgent(getCommentsForComparedCommitRequest));
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     * @return A Java Future containing the result of the GetCommentsForPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCommentsForPullRequestResponse> getCommentsForPullRequest(
            GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCommentsForPullRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCommentsForPullRequestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCommentsForPullRequestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCommentsForPullRequestRequest, GetCommentsForPullRequestResponse>()
                            .withOperationName("GetCommentsForPullRequest")
                            .withMarshaller(new GetCommentsForPullRequestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCommentsForPullRequestRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher publisher = client.getCommentsForPullRequestPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher publisher = client.getCommentsForPullRequestPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    public GetCommentsForPullRequestPublisher getCommentsForPullRequestPaginator(
            GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) {
        return new GetCommentsForPullRequestPublisher(this, applyPaginatorUserAgent(getCommentsForPullRequestRequest));
    }

    /**
     * <p>
     * Returns information about a commit, including commit message and committer information.
     * </p>
     *
     * @param getCommitRequest
     *        Represents the input of a get commit operation.
     * @return A Java Future containing the result of the GetCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitIdDoesNotExistException The specified commit ID does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCommitResponse> getCommit(GetCommitRequest getCommitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCommitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCommitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCommitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCommitRequest, GetCommitResponse>().withOperationName("GetCommit")
                            .withMarshaller(new GetCommitRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getCommitRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     *
     * @param getDifferencesRequest
     * @return A Java Future containing the result of the GetDifferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDifferencesResponse> getDifferences(GetDifferencesRequest getDifferencesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDifferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDifferencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDifferencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDifferencesRequest, GetDifferencesResponse>()
                            .withOperationName("GetDifferences")
                            .withMarshaller(new GetDifferencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getDifferencesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher publisher = client.getDifferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher publisher = client.getDifferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation.</b>
     * </p>
     *
     * @param getDifferencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    public GetDifferencesPublisher getDifferencesPaginator(GetDifferencesRequest getDifferencesRequest) {
        return new GetDifferencesPublisher(this, applyPaginatorUserAgent(getDifferencesRequest));
    }

    /**
     * <p>
     * Returns the base-64 encoded contents of a specified file and its metadata.
     * </p>
     *
     * @param getFileRequest
     * @return A Java Future containing the result of the GetFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have provided the
     *         correct name of the file, including its full path and extension.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>FileTooLargeException The specified file exceeds the file size limit for AWS CodeCommit. For more
     *         information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFileResponse> getFile(GetFileRequest getFileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFileRequest, GetFileResponse>().withOperationName("GetFile")
                            .withMarshaller(new GetFileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getFileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the contents of a specified folder in a repository.
     * </p>
     *
     * @param getFolderRequest
     * @return A Java Future containing the result of the GetFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FolderDoesNotExistException The specified folder does not exist. Either the folder name is not
     *         correct, or you did not provide the full path to the folder.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetFolder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFolderResponse> getFolder(GetFolderRequest getFolderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFolderRequest, GetFolderResponse>().withOperationName("GetFolder")
                            .withMarshaller(new GetFolderRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getFolderRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specified merge commit.
     * </p>
     *
     * @param getMergeCommitRequest
     * @return A Java Future containing the result of the GetMergeCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMergeCommitResponse> getMergeCommit(GetMergeCommitRequest getMergeCommitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMergeCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMergeCommitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMergeCommitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMergeCommitRequest, GetMergeCommitResponse>()
                            .withOperationName("GetMergeCommit")
                            .withMarshaller(new GetMergeCommitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMergeCommitRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     *
     * @param getMergeConflictsRequest
     * @return A Java Future containing the result of the GetMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidDestinationCommitSpecifierException The destination commit specifier is not valid. You must
     *         provide a valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidSourceCommitSpecifierException The source commit specifier is not valid. You must provide a
     *         valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMergeConflictsResponse> getMergeConflicts(GetMergeConflictsRequest getMergeConflictsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMergeConflictsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMergeConflictsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMergeConflictsRequest, GetMergeConflictsResponse>()
                            .withOperationName("GetMergeConflicts")
                            .withMarshaller(new GetMergeConflictsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMergeConflictsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher publisher = client.getMergeConflictsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher publisher = client.getMergeConflictsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getMergeConflictsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidDestinationCommitSpecifierException The destination commit specifier is not valid. You must
     *         provide a valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidSourceCommitSpecifierException The source commit specifier is not valid. You must provide a
     *         valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    public GetMergeConflictsPublisher getMergeConflictsPaginator(GetMergeConflictsRequest getMergeConflictsRequest) {
        return new GetMergeConflictsPublisher(this, applyPaginatorUserAgent(getMergeConflictsRequest));
    }

    /**
     * <p>
     * Returns information about the merge options available for merging two specified branches. For details about why a
     * particular merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
     * </p>
     *
     * @param getMergeOptionsRequest
     * @return A Java Future containing the result of the GetMergeOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMergeOptionsResponse> getMergeOptions(GetMergeOptionsRequest getMergeOptionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMergeOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMergeOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMergeOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMergeOptionsRequest, GetMergeOptionsResponse>()
                            .withOperationName("GetMergeOptions")
                            .withMarshaller(new GetMergeOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMergeOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a pull request in a specified repository.
     * </p>
     *
     * @param getPullRequestRequest
     * @return A Java Future containing the result of the GetPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPullRequestResponse> getPullRequest(GetPullRequestRequest getPullRequestRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPullRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPullRequestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPullRequestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPullRequestRequest, GetPullRequestResponse>()
                            .withOperationName("GetPullRequest")
                            .withMarshaller(new GetPullRequestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getPullRequestRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a web page could expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a web page.
     * </p>
     * </note>
     *
     * @param getRepositoryRequest
     *        Represents the input of a get repository operation.
     * @return A Java Future containing the result of the GetRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRepositoryResponse> getRepository(GetRepositoryRequest getRepositoryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRepositoryRequest, GetRepositoryResponse>()
                            .withOperationName("GetRepository")
                            .withMarshaller(new GetRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRepositoryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about triggers configured for a repository.
     * </p>
     *
     * @param getRepositoryTriggersRequest
     *        Represents the input of a get repository triggers operation.
     * @return A Java Future containing the result of the GetRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRepositoryTriggersResponse> getRepositoryTriggers(
            GetRepositoryTriggersRequest getRepositoryTriggersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRepositoryTriggersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRepositoryTriggersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRepositoryTriggersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRepositoryTriggersRequest, GetRepositoryTriggersResponse>()
                            .withOperationName("GetRepositoryTriggers")
                            .withMarshaller(new GetRepositoryTriggersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRepositoryTriggersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     *
     * @param listBranchesRequest
     *        Represents the input of a list branches operation.
     * @return A Java Future containing the result of the ListBranches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBranchesResponse> listBranches(ListBranchesRequest listBranchesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBranchesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBranchesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBranchesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBranchesRequest, ListBranchesResponse>()
                            .withOperationName("ListBranches").withMarshaller(new ListBranchesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBranchesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher publisher = client.listBranchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher publisher = client.listBranchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListBranchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListBranchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)} operation.</b>
     * </p>
     *
     * @param listBranchesRequest
     *        Represents the input of a list branches operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    public ListBranchesPublisher listBranchesPaginator(ListBranchesRequest listBranchesRequest) {
        return new ListBranchesPublisher(this, applyPaginatorUserAgent(listBranchesRequest));
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     *
     * @param listPullRequestsRequest
     * @return A Java Future containing the result of the ListPullRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>InvalidAuthorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the author of the pull request, and then try again.</li>
     *         <li>AuthorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPullRequestsResponse> listPullRequests(ListPullRequestsRequest listPullRequestsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPullRequestsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPullRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPullRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPullRequestsRequest, ListPullRequestsResponse>()
                            .withOperationName("ListPullRequests")
                            .withMarshaller(new ListPullRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPullRequestsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher publisher = client.listPullRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher publisher = client.listPullRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPullRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>InvalidAuthorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the author of the pull request, and then try again.</li>
     *         <li>AuthorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    public ListPullRequestsPublisher listPullRequestsPaginator(ListPullRequestsRequest listPullRequestsRequest) {
        return new ListPullRequestsPublisher(this, applyPaginatorUserAgent(listPullRequestsRequest));
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     *
     * @param listRepositoriesRequest
     *        Represents the input of a list repositories operation.
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRepositoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRepositoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRepositoriesRequest, ListRepositoriesResponse>()
                            .withOperationName("ListRepositories")
                            .withMarshaller(new ListRepositoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listRepositoriesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesRequest
     *        Represents the input of a list repositories operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    public ListRepositoriesPublisher listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) {
        return new ListRepositoriesPublisher(this, applyPaginatorUserAgent(listRepositoriesRequest));
    }

    /**
     * <p>
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid
     * resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTagsForResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Merges two branches using the fast-forward merge strategy.
     * </p>
     *
     * @param mergeBranchesByFastForwardRequest
     * @return A Java Future containing the result of the MergeBranchesByFastForward operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Type
     *         the name of a current branch in the repository. For a list of valid branch names, use
     *         <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<MergeBranchesByFastForwardResponse> mergeBranchesByFastForward(
            MergeBranchesByFastForwardRequest mergeBranchesByFastForwardRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<MergeBranchesByFastForwardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, MergeBranchesByFastForwardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<MergeBranchesByFastForwardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<MergeBranchesByFastForwardRequest, MergeBranchesByFastForwardResponse>()
                            .withOperationName("MergeBranchesByFastForward")
                            .withMarshaller(new MergeBranchesByFastForwardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mergeBranchesByFastForwardRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Merges two branches using the squash merge strategy.
     * </p>
     *
     * @param mergeBranchesBySquashRequest
     * @return A Java Future containing the result of the MergeBranchesBySquash operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Type
     *         the name of a current branch in the repository. For a list of valid branch names, use
     *         <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified but no replacement content has been
     *         provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>FileModeRequiredException The commit cannot be created because a file mode is required to update mode
     *         permissions for an existing file, but no file mode has been specified.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<MergeBranchesBySquashResponse> mergeBranchesBySquash(
            MergeBranchesBySquashRequest mergeBranchesBySquashRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<MergeBranchesBySquashResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, MergeBranchesBySquashResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<MergeBranchesBySquashResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<MergeBranchesBySquashRequest, MergeBranchesBySquashResponse>()
                            .withOperationName("MergeBranchesBySquash")
                            .withMarshaller(new MergeBranchesBySquashRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mergeBranchesBySquashRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Merges two specified branches using the three-way merge strategy.
     * </p>
     *
     * @param mergeBranchesByThreeWayRequest
     * @return A Java Future containing the result of the MergeBranchesByThreeWay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Type
     *         the name of a current branch in the repository. For a list of valid branch names, use
     *         <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified but no replacement content has been
     *         provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>FileModeRequiredException The commit cannot be created because a file mode is required to update mode
     *         permissions for an existing file, but no file mode has been specified.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<MergeBranchesByThreeWayResponse> mergeBranchesByThreeWay(
            MergeBranchesByThreeWayRequest mergeBranchesByThreeWayRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<MergeBranchesByThreeWayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, MergeBranchesByThreeWayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<MergeBranchesByThreeWayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<MergeBranchesByThreeWayRequest, MergeBranchesByThreeWayResponse>()
                            .withOperationName("MergeBranchesByThreeWay")
                            .withMarshaller(new MergeBranchesByThreeWayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mergeBranchesByThreeWayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     *
     * @param mergePullRequestByFastForwardRequest
     * @return A Java Future containing the result of the MergePullRequestByFastForward operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>ReferenceDoesNotExistException The specified reference does not exist. You must provide a full commit
     *         ID.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<MergePullRequestByFastForwardResponse> mergePullRequestByFastForward(
            MergePullRequestByFastForwardRequest mergePullRequestByFastForwardRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<MergePullRequestByFastForwardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, MergePullRequestByFastForwardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<MergePullRequestByFastForwardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<MergePullRequestByFastForwardRequest, MergePullRequestByFastForwardResponse>()
                            .withOperationName("MergePullRequestByFastForward")
                            .withMarshaller(new MergePullRequestByFastForwardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mergePullRequestByFastForwardRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
     * </p>
     *
     * @param mergePullRequestBySquashRequest
     * @return A Java Future containing the result of the MergePullRequestBySquash operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified but no replacement content has been
     *         provided.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<MergePullRequestBySquashResponse> mergePullRequestBySquash(
            MergePullRequestBySquashRequest mergePullRequestBySquashRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<MergePullRequestBySquashResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, MergePullRequestBySquashResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<MergePullRequestBySquashResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<MergePullRequestBySquashRequest, MergePullRequestBySquashResponse>()
                            .withOperationName("MergePullRequestBySquash")
                            .withMarshaller(new MergePullRequestBySquashRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mergePullRequestBySquashRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     *
     * @param mergePullRequestByThreeWayRequest
     * @return A Java Future containing the result of the MergePullRequestByThreeWay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified but no replacement content has been
     *         provided.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The maximum number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<MergePullRequestByThreeWayResponse> mergePullRequestByThreeWay(
            MergePullRequestByThreeWayRequest mergePullRequestByThreeWayRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<MergePullRequestByThreeWayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, MergePullRequestByThreeWayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<MergePullRequestByThreeWayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<MergePullRequestByThreeWayRequest, MergePullRequestByThreeWayResponse>()
                            .withOperationName("MergePullRequestByThreeWay")
                            .withMarshaller(new MergePullRequestByThreeWayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mergePullRequestByThreeWayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Posts a comment on the comparison between two commits.
     * </p>
     *
     * @param postCommentForComparedCommitRequest
     * @return A Java Future containing the result of the PostCommentForComparedCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that when provided in a request, ensures the request cannot be
     *         repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request will return information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be re-used.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>InvalidFileLocationException The location of the file is not valid. Make sure that you include the
     *         extension of the file as well as the file name.</li>
     *         <li>InvalidRelativeFileVersionEnumException Either the enum is not in a valid format, or the specified
     *         file version enum is not valid in respect to the current file version.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidFilePositionException The position is not valid. Make sure that the line number exists in the
     *         version of the file you want to comment on.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>BeforeCommitIdAndAfterCommitIdAreSameException The before commit ID and the after commit ID are the
     *         same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PostCommentForComparedCommitResponse> postCommentForComparedCommit(
            PostCommentForComparedCommitRequest postCommentForComparedCommitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PostCommentForComparedCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PostCommentForComparedCommitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PostCommentForComparedCommitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PostCommentForComparedCommitRequest, PostCommentForComparedCommitResponse>()
                            .withOperationName("PostCommentForComparedCommit")
                            .withMarshaller(new PostCommentForComparedCommitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(postCommentForComparedCommitRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Posts a comment on a pull request.
     * </p>
     *
     * @param postCommentForPullRequestRequest
     * @return A Java Future containing the result of the PostCommentForPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that when provided in a request, ensures the request cannot be
     *         repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request will return information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be re-used.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>InvalidFileLocationException The location of the file is not valid. Make sure that you include the
     *         extension of the file as well as the file name.</li>
     *         <li>InvalidRelativeFileVersionEnumException Either the enum is not in a valid format, or the specified
     *         file version enum is not valid in respect to the current file version.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidFilePositionException The position is not valid. Make sure that the line number exists in the
     *         version of the file you want to comment on.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>BeforeCommitIdAndAfterCommitIdAreSameException The before commit ID and the after commit ID are the
     *         same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PostCommentForPullRequestResponse> postCommentForPullRequest(
            PostCommentForPullRequestRequest postCommentForPullRequestRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PostCommentForPullRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PostCommentForPullRequestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PostCommentForPullRequestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PostCommentForPullRequestRequest, PostCommentForPullRequestResponse>()
                            .withOperationName("PostCommentForPullRequest")
                            .withMarshaller(new PostCommentForPullRequestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(postCommentForPullRequestRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
     * </p>
     *
     * @param postCommentReplyRequest
     * @return A Java Future containing the result of the PostCommentReply operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that when provided in a request, ensures the request cannot be
     *         repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request will return information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be re-used.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have provided
     *         the correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentReply
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentReply" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PostCommentReplyResponse> postCommentReply(PostCommentReplyRequest postCommentReplyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PostCommentReplyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PostCommentReplyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PostCommentReplyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PostCommentReplyRequest, PostCommentReplyResponse>()
                            .withOperationName("PostCommentReply")
                            .withMarshaller(new PostCommentReplyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(postCommentReplyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in
     * the specified branch.
     * </p>
     *
     * @param putFileRequest
     * @return A Java Future containing the result of the PutFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>FileContentRequiredException The file cannot be added because it is empty. Empty files cannot be
     *         added to the repository with this API.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size that can be added is 6 MB, and the combined file content change size is 7 MB. Consider making
     *         these changes using a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Type
     *         the name of a current branch in the repository. For a list of valid branch names, use
     *         <a>ListBranches</a>.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidDeletionParameterException The specified deletion parameter is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SameFileContentException The file was not added or updated because the content of the file is exactly
     *         the same as the content of that file in the repository and branch that you specified.</li>
     *         <li>FileNameConflictsWithDirectoryNameException A file cannot be added to the repository because the
     *         specified file name has the same name as a directory in this repository. Either provide another name for
     *         the file, or add the file in a directory that does not match the file name.</li>
     *         <li>DirectoryNameConflictsWithFileNameException A file cannot be added to the repository because the
     *         specified path name has the same name as a file that already exists in this repository. Either provide a
     *         different name for the file, or specify a different path for the file.</li>
     *         <li>FilePathConflictsWithSubmodulePathException The commit cannot be created because a specified file
     *         path points to a submodule. Verify that the destination files have valid file paths that do not point to
     *         a submodule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutFileResponse> putFile(PutFileRequest putFileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutFileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutFileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutFileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutFileRequest, PutFileResponse>().withOperationName("PutFile")
                            .withMarshaller(new PutFileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putFileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces all triggers for a repository. This can be used to create or delete triggers.
     * </p>
     *
     * @param putRepositoryTriggersRequest
     *        Represents the input ofa put repository triggers operation.
     * @return A Java Future containing the result of the PutRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryTriggersListRequiredException The list of triggers for the repository is required but was
     *         not specified.</li>
     *         <li>MaximumRepositoryTriggersExceededException The number of triggers allowed for the repository was
     *         exceeded.</li>
     *         <li>InvalidRepositoryTriggerNameException The name of the trigger is not valid.</li>
     *         <li>InvalidRepositoryTriggerDestinationArnException The Amazon Resource Name (ARN) for the trigger is not
     *         valid for the specified destination. The most common reason for this error is that the ARN does not meet
     *         the requirements for the service type.</li>
     *         <li>InvalidRepositoryTriggerRegionException The region for the trigger target does not match the region
     *         for the repository. Triggers must be created in the same region as the target for the trigger.</li>
     *         <li>InvalidRepositoryTriggerCustomDataException The custom data provided for the trigger is not valid.</li>
     *         <li>MaximumBranchesExceededException The number of branches for the trigger was exceeded.</li>
     *         <li>InvalidRepositoryTriggerBranchNameException One or more branch names specified for the trigger is not
     *         valid.</li>
     *         <li>InvalidRepositoryTriggerEventsException One or more events specified for the trigger is not valid.
     *         Check to make sure that all events specified match the requirements for allowed events.</li>
     *         <li>RepositoryTriggerNameRequiredException A name for the trigger is required but was not specified.</li>
     *         <li>RepositoryTriggerDestinationArnRequiredException A destination ARN for the target service for the
     *         trigger is required but was not specified.</li>
     *         <li>RepositoryTriggerBranchNameListRequiredException At least one branch name is required but was not
     *         specified in the trigger configuration.</li>
     *         <li>RepositoryTriggerEventsListRequiredException At least one event for the trigger is required but was
     *         not specified.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRepositoryTriggersResponse> putRepositoryTriggers(
            PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRepositoryTriggersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRepositoryTriggersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRepositoryTriggersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRepositoryTriggersRequest, PutRepositoryTriggersResponse>()
                            .withOperationName("PutRepositoryTriggers")
                            .withMarshaller(new PutRepositoryTriggersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putRepositoryTriggersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a
     * href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>TagsMapRequiredException A map of tags is required.</li>
     *         <li>InvalidTagsMapException The map of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(tagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests the functionality of repository triggers by sending information to the trigger target. If real data is
     * available in the repository, the test will send data from the last commit. If no data is available, sample data
     * will be generated.
     * </p>
     *
     * @param testRepositoryTriggersRequest
     *        Represents the input of a test repository triggers operation.
     * @return A Java Future containing the result of the TestRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryTriggersListRequiredException The list of triggers for the repository is required but was
     *         not specified.</li>
     *         <li>MaximumRepositoryTriggersExceededException The number of triggers allowed for the repository was
     *         exceeded.</li>
     *         <li>InvalidRepositoryTriggerNameException The name of the trigger is not valid.</li>
     *         <li>InvalidRepositoryTriggerDestinationArnException The Amazon Resource Name (ARN) for the trigger is not
     *         valid for the specified destination. The most common reason for this error is that the ARN does not meet
     *         the requirements for the service type.</li>
     *         <li>InvalidRepositoryTriggerRegionException The region for the trigger target does not match the region
     *         for the repository. Triggers must be created in the same region as the target for the trigger.</li>
     *         <li>InvalidRepositoryTriggerCustomDataException The custom data provided for the trigger is not valid.</li>
     *         <li>MaximumBranchesExceededException The number of branches for the trigger was exceeded.</li>
     *         <li>InvalidRepositoryTriggerBranchNameException One or more branch names specified for the trigger is not
     *         valid.</li>
     *         <li>InvalidRepositoryTriggerEventsException One or more events specified for the trigger is not valid.
     *         Check to make sure that all events specified match the requirements for allowed events.</li>
     *         <li>RepositoryTriggerNameRequiredException A name for the trigger is required but was not specified.</li>
     *         <li>RepositoryTriggerDestinationArnRequiredException A destination ARN for the target service for the
     *         trigger is required but was not specified.</li>
     *         <li>RepositoryTriggerBranchNameListRequiredException At least one branch name is required but was not
     *         specified in the trigger configuration.</li>
     *         <li>RepositoryTriggerEventsListRequiredException At least one event for the trigger is required but was
     *         not specified.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.TestRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestRepositoryTriggersResponse> testRepositoryTriggers(
            TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestRepositoryTriggersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestRepositoryTriggersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestRepositoryTriggersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestRepositoryTriggersRequest, TestRepositoryTriggersResponse>()
                            .withOperationName("TestRepositoryTriggers")
                            .withMarshaller(new TestRepositoryTriggersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(testRepositoryTriggersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>TagKeysListRequiredException A list of tag keys is required. The list cannot be empty or null.</li>
     *         <li>InvalidTagKeysListException The list of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(untagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the contents of a comment.
     * </p>
     *
     * @param updateCommentRequest
     * @return A Java Future containing the result of the UpdateComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have provided
     *         the correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentNotCreatedByCallerException You cannot modify or delete this comment. Only comment authors can
     *         modify or delete their comments.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCommentResponse> updateComment(UpdateCommentRequest updateCommentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCommentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateCommentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCommentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCommentRequest, UpdateCommentResponse>()
                            .withOperationName("UpdateComment")
                            .withMarshaller(new UpdateCommentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateCommentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets or changes the default branch name for the specified repository.
     * </p>
     * <note>
     * <p>
     * If you use this operation to change the default branch name to the current default branch name, a success message
     * is returned even though the default branch did not change.
     * </p>
     * </note>
     *
     * @param updateDefaultBranchRequest
     *        Represents the input of an update default branch operation.
     * @return A Java Future containing the result of the UpdateDefaultBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateDefaultBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDefaultBranchResponse> updateDefaultBranch(
            UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDefaultBranchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDefaultBranchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDefaultBranchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDefaultBranchRequest, UpdateDefaultBranchResponse>()
                            .withOperationName("UpdateDefaultBranch")
                            .withMarshaller(new UpdateDefaultBranchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDefaultBranchRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the contents of the description of a pull request.
     * </p>
     *
     * @param updatePullRequestDescriptionRequest
     * @return A Java Future containing the result of the UpdatePullRequestDescription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidDescriptionException The pull request description is not valid. Descriptions are limited to
     *         1,000 characters in length.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePullRequestDescriptionResponse> updatePullRequestDescription(
            UpdatePullRequestDescriptionRequest updatePullRequestDescriptionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePullRequestDescriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePullRequestDescriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePullRequestDescriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePullRequestDescriptionRequest, UpdatePullRequestDescriptionResponse>()
                            .withOperationName("UpdatePullRequestDescription")
                            .withMarshaller(new UpdatePullRequestDescriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updatePullRequestDescriptionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a pull request.
     * </p>
     *
     * @param updatePullRequestStatusRequest
     * @return A Java Future containing the result of the UpdatePullRequestStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestStatusUpdateException The pull request status update is not valid. The only valid
     *         update is from <code>OPEN</code> to <code>CLOSED</code>.</li>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>PullRequestStatusRequiredException A pull request status is required, but none was provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePullRequestStatusResponse> updatePullRequestStatus(
            UpdatePullRequestStatusRequest updatePullRequestStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePullRequestStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePullRequestStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePullRequestStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePullRequestStatusRequest, UpdatePullRequestStatusResponse>()
                            .withOperationName("UpdatePullRequestStatus")
                            .withMarshaller(new UpdatePullRequestStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updatePullRequestStatusRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the title of a pull request.
     * </p>
     *
     * @param updatePullRequestTitleRequest
     * @return A Java Future containing the result of the UpdatePullRequestTitle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>TitleRequiredException A pull request title is required. It cannot be empty or null.</li>
     *         <li>InvalidTitleException The title of the pull request is not valid. Pull request titles cannot exceed
     *         100 characters in length.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestTitle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestTitle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePullRequestTitleResponse> updatePullRequestTitle(
            UpdatePullRequestTitleRequest updatePullRequestTitleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePullRequestTitleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePullRequestTitleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePullRequestTitleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePullRequestTitleRequest, UpdatePullRequestTitleResponse>()
                            .withOperationName("UpdatePullRequestTitle")
                            .withMarshaller(new UpdatePullRequestTitleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updatePullRequestTitleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets or changes the comment or description for a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a web page could expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a web page.
     * </p>
     * </note>
     *
     * @param updateRepositoryDescriptionRequest
     *        Represents the input of an update repository description operation.
     * @return A Java Future containing the result of the UpdateRepositoryDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidRepositoryDescriptionException The specified repository description is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateRepositoryDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRepositoryDescriptionResponse> updateRepositoryDescription(
            UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRepositoryDescriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRepositoryDescriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRepositoryDescriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRepositoryDescriptionRequest, UpdateRepositoryDescriptionResponse>()
                            .withOperationName("UpdateRepositoryDescription")
                            .withMarshaller(new UpdateRepositoryDescriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRepositoryDescriptionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Renames a repository. The repository name must be unique across the calling AWS account. In addition, repository
     * names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters.
     * The suffix ".git" is prohibited. For a full description of the limits on repository names, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit User
     * Guide.
     * </p>
     *
     * @param updateRepositoryNameRequest
     *        Represents the input of an update repository description operation.
     * @return A Java Future containing the result of the UpdateRepositoryName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameExistsException The specified repository name already exists.</li>
     *         <li>RepositoryNameRequiredException A repository name is required but was not specified.</li>
     *         <li>InvalidRepositoryNameException At least one specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception only occurs when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateRepositoryName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRepositoryNameResponse> updateRepositoryName(
            UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRepositoryNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRepositoryNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRepositoryNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRepositoryNameRequest, UpdateRepositoryNameResponse>()
                            .withOperationName("UpdateRepositoryName")
                            .withMarshaller(new UpdateRepositoryNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRepositoryNameRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CodeCommitException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetsRequiredException")
                                .exceptionBuilderSupplier(TargetsRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException")
                                .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileContentRequiredException")
                                .exceptionBuilderSupplier(FileContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException")
                                .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdRequiredException")
                                .exceptionBuilderSupplier(CommitIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentDeletedException")
                                .exceptionBuilderSupplier(CommentDeletedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                                .exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TitleRequiredException")
                                .exceptionBuilderSupplier(TitleRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBlobIdException")
                                .exceptionBuilderSupplier(InvalidBlobIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                                .exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetsException")
                                .exceptionBuilderSupplier(InvalidTargetsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentDoesNotExistException")
                                .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                                .exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                                .exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlobIdRequiredException")
                                .exceptionBuilderSupplier(BlobIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException")
                                .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException")
                                .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException")
                                .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilePositionException")
                                .exceptionBuilderSupplier(InvalidFilePositionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                                .exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceArnException")
                                .exceptionBuilderSupplier(InvalidResourceArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                                .exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                                .exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchDoesNotExistException")
                                .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException")
                                .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                                .exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                                .exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileModeRequiredException")
                                .exceptionBuilderSupplier(FileModeRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitDoesNotExistException")
                                .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceArnRequiredException")
                                .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                                .exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                                .exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException")
                                .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFileLocationException")
                                .exceptionBuilderSupplier(InvalidFileLocationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                                .exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                                .exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException")
                                .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException")
                                .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPathException")
                                .exceptionBuilderSupplier(InvalidPathException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                                .exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagKeysListRequiredException")
                                .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                                .exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                                .exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                                .exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException")
                                .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReferenceNameException")
                                .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                                .exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAuthorArnException")
                                .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentContentRequiredException")
                                .exceptionBuilderSupplier(CommentContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagKeysListException")
                                .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetBranchException")
                                .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagsMapRequiredException")
                                .exceptionBuilderSupplier(TagsMapRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PathRequiredException")
                                .exceptionBuilderSupplier(PathRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException")
                                .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException")
                                .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException")
                                .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException")
                                .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException")
                                .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException")
                                .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                                .exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException")
                                .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException")
                                .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommentIdException")
                                .exceptionBuilderSupplier(InvalidCommentIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                                .exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommitException")
                                .exceptionBuilderSupplier(InvalidCommitException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ActorDoesNotExistException")
                                .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoChangeException")
                                .exceptionBuilderSupplier(NoChangeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDescriptionException")
                                .exceptionBuilderSupplier(InvalidDescriptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                                .exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException")
                                .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MergeOptionRequiredException")
                                .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FolderDoesNotExistException")
                                .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException")
                                .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException")
                                .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileDoesNotExistException")
                                .exceptionBuilderSupplier(FileDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNameExistsException")
                                .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PathDoesNotExistException")
                                .exceptionBuilderSupplier(PathDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                                .exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchNameExistsException")
                                .exceptionBuilderSupplier(BranchNameExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                                .exceptionBuilderSupplier(InvalidReplacementContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                                .exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                                .exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException")
                                .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommitIdException")
                                .exceptionBuilderSupplier(InvalidCommitIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOrderException")
                                .exceptionBuilderSupplier(InvalidOrderException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEmailException")
                                .exceptionBuilderSupplier(InvalidEmailException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException")
                                .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchNameRequiredException")
                                .exceptionBuilderSupplier(BranchNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException")
                                .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                                .exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentIdRequiredException")
                                .exceptionBuilderSupplier(CommentIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMergeOptionException")
                                .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException")
                                .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException")
                                .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException")
                                .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitRequiredException")
                                .exceptionBuilderSupplier(CommitRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                                .exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                                .exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameLengthExceededException")
                                .exceptionBuilderSupplier(NameLengthExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                                .exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException")
                                .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                                .exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                                .exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                                .exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetRequiredException")
                                .exceptionBuilderSupplier(TargetRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagsMapException")
                                .exceptionBuilderSupplier(InvalidTagsMapException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RestrictedSourceFileException")
                                .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileTooLargeException")
                                .exceptionBuilderSupplier(FileTooLargeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ManualMergeRequiredException")
                                .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PutFileEntryConflictException")
                                .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                                .exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                                .exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                                .exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SamePathRequestException")
                                .exceptionBuilderSupplier(SamePathRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException")
                                .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSortByException")
                                .exceptionBuilderSupplier(InvalidSortByException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SameFileContentException")
                                .exceptionBuilderSupplier(SameFileContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetException")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException")
                                .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                                .exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxResultsException")
                                .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException")
                                .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileEntryRequiredException")
                                .exceptionBuilderSupplier(FileEntryRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidActorArnException")
                                .exceptionBuilderSupplier(InvalidActorArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException")
                                .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                                .exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagPolicyException")
                                .exceptionBuilderSupplier(TagPolicyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFileModeException")
                                .exceptionBuilderSupplier(InvalidFileModeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                                .exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                                .exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                                .exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTitleException")
                                .exceptionBuilderSupplier(InvalidTitleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException")
                                .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException")
                                .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                                .exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBranchNameException")
                                .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
    }

    private <T extends CodeCommitRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
