/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeBranchesBySquashRequest extends CodeCommitRequest implements
        ToCopyableBuilder<MergeBranchesBySquashRequest.Builder, MergeBranchesBySquashRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::sourceCommitSpecifier)).setter(setter(Builder::sourceCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build())
            .build();

    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::destinationCommitSpecifier))
            .setter(setter(Builder::destinationCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build())
            .build();

    private static final SdkField<String> TARGET_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::targetBranch)).setter(setter(Builder::targetBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBranch").build()).build();

    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::conflictDetailLevelAsString))
            .setter(setter(Builder::conflictDetailLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build())
            .build();

    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::conflictResolutionStrategyAsString))
            .setter(setter(Builder::conflictResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build())
            .build();

    private static final SdkField<String> AUTHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::authorName)).setter(setter(Builder::authorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorName").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashRequest::commitMessage)).setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()).build();

    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MergeBranchesBySquashRequest::keepEmptyFolders)).setter(setter(Builder::keepEmptyFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()).build();

    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField
            .<ConflictResolution> builder(MarshallingType.SDK_POJO)
            .getter(getter(MergeBranchesBySquashRequest::conflictResolution)).setter(setter(Builder::conflictResolution))
            .constructor(ConflictResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, TARGET_BRANCH_FIELD, CONFLICT_DETAIL_LEVEL_FIELD,
            CONFLICT_RESOLUTION_STRATEGY_FIELD, AUTHOR_NAME_FIELD, EMAIL_FIELD, COMMIT_MESSAGE_FIELD, KEEP_EMPTY_FOLDERS_FIELD,
            CONFLICT_RESOLUTION_FIELD));

    private final String repositoryName;

    private final String sourceCommitSpecifier;

    private final String destinationCommitSpecifier;

    private final String targetBranch;

    private final String conflictDetailLevel;

    private final String conflictResolutionStrategy;

    private final String authorName;

    private final String email;

    private final String commitMessage;

    private final Boolean keepEmptyFolders;

    private final ConflictResolution conflictResolution;

    private MergeBranchesBySquashRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.targetBranch = builder.targetBranch;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.authorName = builder.authorName;
        this.email = builder.email;
        this.commitMessage = builder.commitMessage;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.conflictResolution = builder.conflictResolution;
    }

    /**
     * <p>
     * The name of the repository where you want to merge two branches.
     * </p>
     * 
     * @return The name of the repository where you want to merge two branches.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a branch name
     * or a full commit ID.
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a
     *         branch name or a full commit ID.
     */
    public String sourceCommitSpecifier() {
        return sourceCommitSpecifier;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a branch name
     * or a full commit ID.
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a
     *         branch name or a full commit ID.
     */
    public String destinationCommitSpecifier() {
        return destinationCommitSpecifier;
    }

    /**
     * <p>
     * The branch where the merge will be applied.
     * </p>
     * 
     * @return The branch where the merge will be applied.
     */
    public String targetBranch() {
        return targetBranch;
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return a not
     * mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict will
     * be considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return a
     *         not mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict will be considered not mergeable if the same file in both branches has differences on the same
     *         line.
     * @see ConflictDetailLevelTypeEnum
     */
    public ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(conflictDetailLevel);
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return a not
     * mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict will
     * be considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return a
     *         not mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict will be considered not mergeable if the same file in both branches has differences on the same
     *         line.
     * @see ConflictDetailLevelTypeEnum
     */
    public String conflictDetailLevelAsString() {
        return conflictDetailLevel;
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * will be successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation will be successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(conflictResolutionStrategy);
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * will be successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation will be successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public String conflictResolutionStrategyAsString() {
        return conflictResolutionStrategy;
    }

    /**
     * <p>
     * The name of the author who created the commit. This information will be used as both the author and committer for
     * the commit.
     * </p>
     * 
     * @return The name of the author who created the commit. This information will be used as both the author and
     *         committer for the commit.
     */
    public String authorName() {
        return authorName;
    }

    /**
     * <p>
     * The email address of the person merging the branches. This information will be used in the commit information for
     * the merge.
     * </p>
     * 
     * @return The email address of the person merging the branches. This information will be used in the commit
     *         information for the merge.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The commit message for the merge.
     * </p>
     * 
     * @return The commit message for the merge.
     */
    public String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders
     * empty. If this is specified as true, a .gitkeep file will be created for empty folders. The default is false.
     * </p>
     * 
     * @return If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the
     *         folders empty. If this is specified as true, a .gitkeep file will be created for empty folders. The
     *         default is false.
     */
    public Boolean keepEmptyFolders() {
        return keepEmptyFolders;
    }

    /**
     * <p>
     * A list of inputs to use when resolving conflicts during a merge if AUTOMERGE is chosen as the conflict resolution
     * strategy.
     * </p>
     * 
     * @return A list of inputs to use when resolving conflicts during a merge if AUTOMERGE is chosen as the conflict
     *         resolution strategy.
     */
    public ConflictResolution conflictResolution() {
        return conflictResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetBranch());
        hashCode = 31 * hashCode + Objects.hashCode(conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorName());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolution());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesBySquashRequest)) {
            return false;
        }
        MergeBranchesBySquashRequest other = (MergeBranchesBySquashRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceCommitSpecifier(), other.sourceCommitSpecifier())
                && Objects.equals(destinationCommitSpecifier(), other.destinationCommitSpecifier())
                && Objects.equals(targetBranch(), other.targetBranch())
                && Objects.equals(conflictDetailLevelAsString(), other.conflictDetailLevelAsString())
                && Objects.equals(conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString())
                && Objects.equals(authorName(), other.authorName()) && Objects.equals(email(), other.email())
                && Objects.equals(commitMessage(), other.commitMessage())
                && Objects.equals(keepEmptyFolders(), other.keepEmptyFolders())
                && Objects.equals(conflictResolution(), other.conflictResolution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MergeBranchesBySquashRequest").add("RepositoryName", repositoryName())
                .add("SourceCommitSpecifier", sourceCommitSpecifier())
                .add("DestinationCommitSpecifier", destinationCommitSpecifier()).add("TargetBranch", targetBranch())
                .add("ConflictDetailLevel", conflictDetailLevelAsString())
                .add("ConflictResolutionStrategy", conflictResolutionStrategyAsString()).add("AuthorName", authorName())
                .add("Email", email()).add("CommitMessage", commitMessage()).add("KeepEmptyFolders", keepEmptyFolders())
                .add("ConflictResolution", conflictResolution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceCommitSpecifier":
            return Optional.ofNullable(clazz.cast(sourceCommitSpecifier()));
        case "destinationCommitSpecifier":
            return Optional.ofNullable(clazz.cast(destinationCommitSpecifier()));
        case "targetBranch":
            return Optional.ofNullable(clazz.cast(targetBranch()));
        case "conflictDetailLevel":
            return Optional.ofNullable(clazz.cast(conflictDetailLevelAsString()));
        case "conflictResolutionStrategy":
            return Optional.ofNullable(clazz.cast(conflictResolutionStrategyAsString()));
        case "authorName":
            return Optional.ofNullable(clazz.cast(authorName()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "commitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "keepEmptyFolders":
            return Optional.ofNullable(clazz.cast(keepEmptyFolders()));
        case "conflictResolution":
            return Optional.ofNullable(clazz.cast(conflictResolution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesBySquashRequest, T> g) {
        return obj -> g.apply((MergeBranchesBySquashRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, MergeBranchesBySquashRequest> {
        /**
         * <p>
         * The name of the repository where you want to merge two branches.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you want to merge two branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a branch
         * name or a full commit ID.
         * </p>
         * 
         * @param sourceCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a
         *        branch name or a full commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitSpecifier(String sourceCommitSpecifier);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a branch
         * name or a full commit ID.
         * </p>
         * 
         * @param destinationCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit. For example, a
         *        branch name or a full commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitSpecifier(String destinationCommitSpecifier);

        /**
         * <p>
         * The branch where the merge will be applied.
         * </p>
         * 
         * @param targetBranch
         *        The branch where the merge will be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBranch(String targetBranch);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return a not
         * mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict
         * will be considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return
         *        a not mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified,
         *        a conflict will be considered not mergeable if the same file in both branches has differences on the
         *        same line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(String conflictDetailLevel);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return a not
         * mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict
         * will be considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which will return
         *        a not mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified,
         *        a conflict will be considered not mergeable if the same file in both branches has differences on the
         *        same line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation will be successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation will be successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(String conflictResolutionStrategy);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation will be successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation will be successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy);

        /**
         * <p>
         * The name of the author who created the commit. This information will be used as both the author and committer
         * for the commit.
         * </p>
         * 
         * @param authorName
         *        The name of the author who created the commit. This information will be used as both the author and
         *        committer for the commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorName(String authorName);

        /**
         * <p>
         * The email address of the person merging the branches. This information will be used in the commit information
         * for the merge.
         * </p>
         * 
         * @param email
         *        The email address of the person merging the branches. This information will be used in the commit
         *        information for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The commit message for the merge.
         * </p>
         * 
         * @param commitMessage
         *        The commit message for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the
         * folders empty. If this is specified as true, a .gitkeep file will be created for empty folders. The default
         * is false.
         * </p>
         * 
         * @param keepEmptyFolders
         *        If the commit contains deletions, whether to keep a folder or folder structure if the changes leave
         *        the folders empty. If this is specified as true, a .gitkeep file will be created for empty folders.
         *        The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keepEmptyFolders(Boolean keepEmptyFolders);

        /**
         * <p>
         * A list of inputs to use when resolving conflicts during a merge if AUTOMERGE is chosen as the conflict
         * resolution strategy.
         * </p>
         * 
         * @param conflictResolution
         *        A list of inputs to use when resolving conflicts during a merge if AUTOMERGE is chosen as the conflict
         *        resolution strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictResolution(ConflictResolution conflictResolution);

        /**
         * <p>
         * A list of inputs to use when resolving conflicts during a merge if AUTOMERGE is chosen as the conflict
         * resolution strategy.
         * </p>
         * This is a convenience that creates an instance of the {@link ConflictResolution.Builder} avoiding the need to
         * create one manually via {@link ConflictResolution#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConflictResolution.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictResolution(ConflictResolution)}.
         * 
         * @param conflictResolution
         *        a consumer that will call methods on {@link ConflictResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictResolution(ConflictResolution)
         */
        default Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return conflictResolution(ConflictResolution.builder().applyMutation(conflictResolution).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String sourceCommitSpecifier;

        private String destinationCommitSpecifier;

        private String targetBranch;

        private String conflictDetailLevel;

        private String conflictResolutionStrategy;

        private String authorName;

        private String email;

        private String commitMessage;

        private Boolean keepEmptyFolders;

        private ConflictResolution conflictResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesBySquashRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            sourceCommitSpecifier(model.sourceCommitSpecifier);
            destinationCommitSpecifier(model.destinationCommitSpecifier);
            targetBranch(model.targetBranch);
            conflictDetailLevel(model.conflictDetailLevel);
            conflictResolutionStrategy(model.conflictResolutionStrategy);
            authorName(model.authorName);
            email(model.email);
            commitMessage(model.commitMessage);
            keepEmptyFolders(model.keepEmptyFolders);
            conflictResolution(model.conflictResolution);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceCommitSpecifier() {
            return sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getDestinationCommitSpecifier() {
            return destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getTargetBranch() {
            return targetBranch;
        }

        @Override
        public final Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        public final void setTargetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
        }

        public final String getConflictDetailLevelAsString() {
            return conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        public final String getConflictResolutionStrategyAsString() {
            return conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        public final String getAuthorName() {
            return authorName;
        }

        @Override
        public final Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final Boolean getKeepEmptyFolders() {
            return keepEmptyFolders;
        }

        @Override
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return conflictResolution != null ? conflictResolution.toBuilder() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeBranchesBySquashRequest build() {
            return new MergeBranchesBySquashRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
