/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the details of a merge hunk that contains a conflict in a merge or pull request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeHunkDetail implements SdkPojo, Serializable, ToCopyableBuilder<MergeHunkDetail.Builder, MergeHunkDetail> {
    private static final SdkField<Integer> START_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MergeHunkDetail::startLine)).setter(setter(Builder::startLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startLine").build()).build();

    private static final SdkField<Integer> END_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MergeHunkDetail::endLine)).setter(setter(Builder::endLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endLine").build()).build();

    private static final SdkField<String> HUNK_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeHunkDetail::hunkContent)).setter(setter(Builder::hunkContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hunkContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_LINE_FIELD,
            END_LINE_FIELD, HUNK_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer startLine;

    private final Integer endLine;

    private final String hunkContent;

    private MergeHunkDetail(BuilderImpl builder) {
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.hunkContent = builder.hunkContent;
    }

    /**
     * <p>
     * The start position of the hunk in the merge result.
     * </p>
     * 
     * @return The start position of the hunk in the merge result.
     */
    public Integer startLine() {
        return startLine;
    }

    /**
     * <p>
     * The end position of the hunk in the merge result.
     * </p>
     * 
     * @return The end position of the hunk in the merge result.
     */
    public Integer endLine() {
        return endLine;
    }

    /**
     * <p>
     * The base-64 encoded content of the hunk merged region that might or might not contain a conflict.
     * </p>
     * 
     * @return The base-64 encoded content of the hunk merged region that might or might not contain a conflict.
     */
    public String hunkContent() {
        return hunkContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startLine());
        hashCode = 31 * hashCode + Objects.hashCode(endLine());
        hashCode = 31 * hashCode + Objects.hashCode(hunkContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeHunkDetail)) {
            return false;
        }
        MergeHunkDetail other = (MergeHunkDetail) obj;
        return Objects.equals(startLine(), other.startLine()) && Objects.equals(endLine(), other.endLine())
                && Objects.equals(hunkContent(), other.hunkContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MergeHunkDetail").add("StartLine", startLine()).add("EndLine", endLine())
                .add("HunkContent", hunkContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startLine":
            return Optional.ofNullable(clazz.cast(startLine()));
        case "endLine":
            return Optional.ofNullable(clazz.cast(endLine()));
        case "hunkContent":
            return Optional.ofNullable(clazz.cast(hunkContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeHunkDetail, T> g) {
        return obj -> g.apply((MergeHunkDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeHunkDetail> {
        /**
         * <p>
         * The start position of the hunk in the merge result.
         * </p>
         * 
         * @param startLine
         *        The start position of the hunk in the merge result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLine(Integer startLine);

        /**
         * <p>
         * The end position of the hunk in the merge result.
         * </p>
         * 
         * @param endLine
         *        The end position of the hunk in the merge result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endLine(Integer endLine);

        /**
         * <p>
         * The base-64 encoded content of the hunk merged region that might or might not contain a conflict.
         * </p>
         * 
         * @param hunkContent
         *        The base-64 encoded content of the hunk merged region that might or might not contain a conflict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hunkContent(String hunkContent);
    }

    static final class BuilderImpl implements Builder {
        private Integer startLine;

        private Integer endLine;

        private String hunkContent;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeHunkDetail model) {
            startLine(model.startLine);
            endLine(model.endLine);
            hunkContent(model.hunkContent);
        }

        public final Integer getStartLine() {
            return startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        public final Integer getEndLine() {
            return endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        public final String getHunkContent() {
            return hunkContent;
        }

        @Override
        public final Builder hunkContent(String hunkContent) {
            this.hunkContent = hunkContent;
            return this;
        }

        public final void setHunkContent(String hunkContent) {
            this.hunkContent = hunkContent;
        }

        @Override
        public MergeHunkDetail build() {
            return new MergeHunkDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
