/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostCommentForComparedCommitResponse extends CodeCommitResponse implements
        ToCopyableBuilder<PostCommentForComparedCommitResponse.Builder, PostCommentForComparedCommitResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitResponse::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitResponse::beforeCommitId)).setter(setter(Builder::beforeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()).build();

    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitResponse::afterCommitId)).setter(setter(Builder::afterCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()).build();

    private static final SdkField<String> BEFORE_BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitResponse::beforeBlobId)).setter(setter(Builder::beforeBlobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlobId").build()).build();

    private static final SdkField<String> AFTER_BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitResponse::afterBlobId)).setter(setter(Builder::afterBlobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlobId").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(PostCommentForComparedCommitResponse::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Comment> COMMENT_FIELD = SdkField.<Comment> builder(MarshallingType.SDK_POJO)
            .getter(getter(PostCommentForComparedCommitResponse::comment)).setter(setter(Builder::comment))
            .constructor(Comment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, BEFORE_BLOB_ID_FIELD, AFTER_BLOB_ID_FIELD, LOCATION_FIELD,
            COMMENT_FIELD));

    private final String repositoryName;

    private final String beforeCommitId;

    private final String afterCommitId;

    private final String beforeBlobId;

    private final String afterBlobId;

    private final Location location;

    private final Comment comment;

    private PostCommentForComparedCommitResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.beforeBlobId = builder.beforeBlobId;
        this.afterBlobId = builder.afterBlobId;
        this.location = builder.location;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The name of the repository where you posted a comment on the comparison between commits.
     * </p>
     * 
     * @return The name of the repository where you posted a comment on the comparison between commits.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * In the directionality you established, the full commit ID of the 'before' commit.
     * </p>
     * 
     * @return In the directionality you established, the full commit ID of the 'before' commit.
     */
    public String beforeCommitId() {
        return beforeCommitId;
    }

    /**
     * <p>
     * In the directionality you established, the full commit ID of the 'after' commit.
     * </p>
     * 
     * @return In the directionality you established, the full commit ID of the 'after' commit.
     */
    public String afterCommitId() {
        return afterCommitId;
    }

    /**
     * <p>
     * In the directionality you established, the blob ID of the 'before' blob.
     * </p>
     * 
     * @return In the directionality you established, the blob ID of the 'before' blob.
     */
    public String beforeBlobId() {
        return beforeBlobId;
    }

    /**
     * <p>
     * In the directionality you established, the blob ID of the 'after' blob.
     * </p>
     * 
     * @return In the directionality you established, the blob ID of the 'after' blob.
     */
    public String afterBlobId() {
        return afterBlobId;
    }

    /**
     * <p>
     * The location of the comment in the comparison between the two commits.
     * </p>
     * 
     * @return The location of the comment in the comparison between the two commits.
     */
    public Location location() {
        return location;
    }

    /**
     * <p>
     * The content of the comment you posted.
     * </p>
     * 
     * @return The content of the comment you posted.
     */
    public Comment comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(beforeBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(afterBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentForComparedCommitResponse)) {
            return false;
        }
        PostCommentForComparedCommitResponse other = (PostCommentForComparedCommitResponse) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(beforeCommitId(), other.beforeCommitId())
                && Objects.equals(afterCommitId(), other.afterCommitId()) && Objects.equals(beforeBlobId(), other.beforeBlobId())
                && Objects.equals(afterBlobId(), other.afterBlobId()) && Objects.equals(location(), other.location())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PostCommentForComparedCommitResponse").add("RepositoryName", repositoryName())
                .add("BeforeCommitId", beforeCommitId()).add("AfterCommitId", afterCommitId())
                .add("BeforeBlobId", beforeBlobId()).add("AfterBlobId", afterBlobId()).add("Location", location())
                .add("Comment", comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "beforeCommitId":
            return Optional.ofNullable(clazz.cast(beforeCommitId()));
        case "afterCommitId":
            return Optional.ofNullable(clazz.cast(afterCommitId()));
        case "beforeBlobId":
            return Optional.ofNullable(clazz.cast(beforeBlobId()));
        case "afterBlobId":
            return Optional.ofNullable(clazz.cast(afterBlobId()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostCommentForComparedCommitResponse, T> g) {
        return obj -> g.apply((PostCommentForComparedCommitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PostCommentForComparedCommitResponse> {
        /**
         * <p>
         * The name of the repository where you posted a comment on the comparison between commits.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you posted a comment on the comparison between commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * In the directionality you established, the full commit ID of the 'before' commit.
         * </p>
         * 
         * @param beforeCommitId
         *        In the directionality you established, the full commit ID of the 'before' commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitId(String beforeCommitId);

        /**
         * <p>
         * In the directionality you established, the full commit ID of the 'after' commit.
         * </p>
         * 
         * @param afterCommitId
         *        In the directionality you established, the full commit ID of the 'after' commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitId(String afterCommitId);

        /**
         * <p>
         * In the directionality you established, the blob ID of the 'before' blob.
         * </p>
         * 
         * @param beforeBlobId
         *        In the directionality you established, the blob ID of the 'before' blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeBlobId(String beforeBlobId);

        /**
         * <p>
         * In the directionality you established, the blob ID of the 'after' blob.
         * </p>
         * 
         * @param afterBlobId
         *        In the directionality you established, the blob ID of the 'after' blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterBlobId(String afterBlobId);

        /**
         * <p>
         * The location of the comment in the comparison between the two commits.
         * </p>
         * 
         * @param location
         *        The location of the comment in the comparison between the two commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * The location of the comment in the comparison between the two commits.
         * </p>
         * This is a convenience that creates an instance of the {@link Location.Builder} avoiding the need to create
         * one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The content of the comment you posted.
         * </p>
         * 
         * @param comment
         *        The content of the comment you posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(Comment comment);

        /**
         * <p>
         * The content of the comment you posted.
         * </p>
         * This is a convenience that creates an instance of the {@link Comment.Builder} avoiding the need to create one
         * manually via {@link Comment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Comment.Builder#build()} is called immediately and its result is
         * passed to {@link #comment(Comment)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link Comment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(Comment)
         */
        default Builder comment(Consumer<Comment.Builder> comment) {
            return comment(Comment.builder().applyMutation(comment).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String repositoryName;

        private String beforeCommitId;

        private String afterCommitId;

        private String beforeBlobId;

        private String afterBlobId;

        private Location location;

        private Comment comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentForComparedCommitResponse model) {
            super(model);
            repositoryName(model.repositoryName);
            beforeCommitId(model.beforeCommitId);
            afterCommitId(model.afterCommitId);
            beforeBlobId(model.beforeBlobId);
            afterBlobId(model.afterBlobId);
            location(model.location);
            comment(model.comment);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBeforeCommitId() {
            return beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        public final String getAfterCommitId() {
            return afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        public final String getBeforeBlobId() {
            return beforeBlobId;
        }

        @Override
        public final Builder beforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
            return this;
        }

        public final void setBeforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
        }

        public final String getAfterBlobId() {
            return afterBlobId;
        }

        @Override
        public final Builder afterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
            return this;
        }

        public final void setAfterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Comment.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public PostCommentForComparedCommitResponse build() {
            return new PostCommentForComparedCommitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
