/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ConflictMetadata;
import software.amazon.awssdk.services.codecommit.model.MergeHunk;
import software.amazon.awssdk.services.codecommit.model.MergeHunksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Conflict
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Conflict> {
    private static final SdkField<ConflictMetadata> CONFLICT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Conflict.getter(Conflict::conflictMetadata)).setter(Conflict.setter(Builder::conflictMetadata)).constructor(ConflictMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictMetadata").build()}).build();
    private static final SdkField<List<MergeHunk>> MERGE_HUNKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Conflict.getter(Conflict::mergeHunks)).setter(Conflict.setter(Builder::mergeHunks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeHunks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MergeHunk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_METADATA_FIELD, MERGE_HUNKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConflictMetadata conflictMetadata;
    private final List<MergeHunk> mergeHunks;

    private Conflict(BuilderImpl builder) {
        this.conflictMetadata = builder.conflictMetadata;
        this.mergeHunks = builder.mergeHunks;
    }

    public ConflictMetadata conflictMetadata() {
        return this.conflictMetadata;
    }

    public List<MergeHunk> mergeHunks() {
        return this.mergeHunks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeHunks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Conflict)) {
            return false;
        }
        Conflict other = (Conflict)obj;
        return Objects.equals(this.conflictMetadata(), other.conflictMetadata()) && Objects.equals(this.mergeHunks(), other.mergeHunks());
    }

    public String toString() {
        return ToString.builder((String)"Conflict").add("ConflictMetadata", (Object)this.conflictMetadata()).add("MergeHunks", this.mergeHunks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conflictMetadata": {
                return Optional.ofNullable(clazz.cast(this.conflictMetadata()));
            }
            case "mergeHunks": {
                return Optional.ofNullable(clazz.cast(this.mergeHunks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Conflict, T> g) {
        return obj -> g.apply((Conflict)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConflictMetadata conflictMetadata;
        private List<MergeHunk> mergeHunks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Conflict model) {
            this.conflictMetadata(model.conflictMetadata);
            this.mergeHunks(model.mergeHunks);
        }

        public final ConflictMetadata.Builder getConflictMetadata() {
            return this.conflictMetadata != null ? this.conflictMetadata.toBuilder() : null;
        }

        @Override
        public final Builder conflictMetadata(ConflictMetadata conflictMetadata) {
            this.conflictMetadata = conflictMetadata;
            return this;
        }

        public final void setConflictMetadata(ConflictMetadata.BuilderImpl conflictMetadata) {
            this.conflictMetadata = conflictMetadata != null ? conflictMetadata.build() : null;
        }

        public final Collection<MergeHunk.Builder> getMergeHunks() {
            return this.mergeHunks != null ? (Collection)this.mergeHunks.stream().map(MergeHunk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mergeHunks(Collection<MergeHunk> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copy(mergeHunks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(MergeHunk ... mergeHunks) {
            this.mergeHunks(Arrays.asList(mergeHunks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(Consumer<MergeHunk.Builder> ... mergeHunks) {
            this.mergeHunks(Stream.of(mergeHunks).map(c -> (MergeHunk)((MergeHunk.Builder)MergeHunk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMergeHunks(Collection<MergeHunk.BuilderImpl> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copyFromBuilder(mergeHunks);
        }

        public Conflict build() {
            return new Conflict(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Conflict> {
        public Builder conflictMetadata(ConflictMetadata var1);

        default public Builder conflictMetadata(Consumer<ConflictMetadata.Builder> conflictMetadata) {
            return this.conflictMetadata((ConflictMetadata)((ConflictMetadata.Builder)ConflictMetadata.builder().applyMutation(conflictMetadata)).build());
        }

        public Builder mergeHunks(Collection<MergeHunk> var1);

        public Builder mergeHunks(MergeHunk ... var1);

        public Builder mergeHunks(Consumer<MergeHunk.Builder> ... var1);
    }
}

