/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.DeleteFileEntry;
import software.amazon.awssdk.services.codecommit.model.PutFileEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.PutFileEntry;
import software.amazon.awssdk.services.codecommit.model.SetFileModeEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.SetFileModeEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCommitRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, CreateCommitRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitRequest.getter(CreateCommitRequest::repositoryName)).setter(CreateCommitRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitRequest.getter(CreateCommitRequest::branchName)).setter(CreateCommitRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> PARENT_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitRequest.getter(CreateCommitRequest::parentCommitId)).setter(CreateCommitRequest.setter(Builder::parentCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentCommitId").build()}).build();
    private static final SdkField<String> AUTHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitRequest.getter(CreateCommitRequest::authorName)).setter(CreateCommitRequest.setter(Builder::authorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitRequest.getter(CreateCommitRequest::email)).setter(CreateCommitRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitRequest.getter(CreateCommitRequest::commitMessage)).setter(CreateCommitRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateCommitRequest.getter(CreateCommitRequest::keepEmptyFolders)).setter(CreateCommitRequest.setter(Builder::keepEmptyFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()}).build();
    private static final SdkField<List<PutFileEntry>> PUT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCommitRequest.getter(CreateCommitRequest::putFiles)).setter(CreateCommitRequest.setter(Builder::putFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("putFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutFileEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeleteFileEntry>> DELETE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCommitRequest.getter(CreateCommitRequest::deleteFiles)).setter(CreateCommitRequest.setter(Builder::deleteFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteFileEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SetFileModeEntry>> SET_FILE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCommitRequest.getter(CreateCommitRequest::setFileModes)).setter(CreateCommitRequest.setter(Builder::setFileModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setFileModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SetFileModeEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BRANCH_NAME_FIELD, PARENT_COMMIT_ID_FIELD, AUTHOR_NAME_FIELD, EMAIL_FIELD, COMMIT_MESSAGE_FIELD, KEEP_EMPTY_FOLDERS_FIELD, PUT_FILES_FIELD, DELETE_FILES_FIELD, SET_FILE_MODES_FIELD));
    private final String repositoryName;
    private final String branchName;
    private final String parentCommitId;
    private final String authorName;
    private final String email;
    private final String commitMessage;
    private final Boolean keepEmptyFolders;
    private final List<PutFileEntry> putFiles;
    private final List<DeleteFileEntry> deleteFiles;
    private final List<SetFileModeEntry> setFileModes;

    private CreateCommitRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.branchName = builder.branchName;
        this.parentCommitId = builder.parentCommitId;
        this.authorName = builder.authorName;
        this.email = builder.email;
        this.commitMessage = builder.commitMessage;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.putFiles = builder.putFiles;
        this.deleteFiles = builder.deleteFiles;
        this.setFileModes = builder.setFileModes;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String branchName() {
        return this.branchName;
    }

    public String parentCommitId() {
        return this.parentCommitId;
    }

    public String authorName() {
        return this.authorName;
    }

    public String email() {
        return this.email;
    }

    public String commitMessage() {
        return this.commitMessage;
    }

    public Boolean keepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public List<PutFileEntry> putFiles() {
        return this.putFiles;
    }

    public List<DeleteFileEntry> deleteFiles() {
        return this.deleteFiles;
    }

    public List<SetFileModeEntry> setFileModes() {
        return this.setFileModes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.putFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.setFileModes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommitRequest)) {
            return false;
        }
        CreateCommitRequest other = (CreateCommitRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.parentCommitId(), other.parentCommitId()) && Objects.equals(this.authorName(), other.authorName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.keepEmptyFolders(), other.keepEmptyFolders()) && Objects.equals(this.putFiles(), other.putFiles()) && Objects.equals(this.deleteFiles(), other.deleteFiles()) && Objects.equals(this.setFileModes(), other.setFileModes());
    }

    public String toString() {
        return ToString.builder((String)"CreateCommitRequest").add("RepositoryName", (Object)this.repositoryName()).add("BranchName", (Object)this.branchName()).add("ParentCommitId", (Object)this.parentCommitId()).add("AuthorName", (Object)this.authorName()).add("Email", (Object)this.email()).add("CommitMessage", (Object)this.commitMessage()).add("KeepEmptyFolders", (Object)this.keepEmptyFolders()).add("PutFiles", this.putFiles()).add("DeleteFiles", this.deleteFiles()).add("SetFileModes", this.setFileModes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "parentCommitId": {
                return Optional.ofNullable(clazz.cast(this.parentCommitId()));
            }
            case "authorName": {
                return Optional.ofNullable(clazz.cast(this.authorName()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "keepEmptyFolders": {
                return Optional.ofNullable(clazz.cast(this.keepEmptyFolders()));
            }
            case "putFiles": {
                return Optional.ofNullable(clazz.cast(this.putFiles()));
            }
            case "deleteFiles": {
                return Optional.ofNullable(clazz.cast(this.deleteFiles()));
            }
            case "setFileModes": {
                return Optional.ofNullable(clazz.cast(this.setFileModes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCommitRequest, T> g) {
        return obj -> g.apply((CreateCommitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String branchName;
        private String parentCommitId;
        private String authorName;
        private String email;
        private String commitMessage;
        private Boolean keepEmptyFolders;
        private List<PutFileEntry> putFiles = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteFileEntry> deleteFiles = DefaultSdkAutoConstructList.getInstance();
        private List<SetFileModeEntry> setFileModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommitRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.branchName(model.branchName);
            this.parentCommitId(model.parentCommitId);
            this.authorName(model.authorName);
            this.email(model.email);
            this.commitMessage(model.commitMessage);
            this.keepEmptyFolders(model.keepEmptyFolders);
            this.putFiles(model.putFiles);
            this.deleteFiles(model.deleteFiles);
            this.setFileModes(model.setFileModes);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getParentCommitId() {
            return this.parentCommitId;
        }

        @Override
        public final Builder parentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
            return this;
        }

        public final void setParentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
        }

        public final String getAuthorName() {
            return this.authorName;
        }

        @Override
        public final Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final Boolean getKeepEmptyFolders() {
            return this.keepEmptyFolders;
        }

        @Override
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        public final Collection<PutFileEntry.Builder> getPutFiles() {
            return this.putFiles != null ? (Collection)this.putFiles.stream().map(PutFileEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder putFiles(Collection<PutFileEntry> putFiles) {
            this.putFiles = PutFileEntriesCopier.copy(putFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder putFiles(PutFileEntry ... putFiles) {
            this.putFiles(Arrays.asList(putFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder putFiles(Consumer<PutFileEntry.Builder> ... putFiles) {
            this.putFiles(Stream.of(putFiles).map(c -> (PutFileEntry)((PutFileEntry.Builder)PutFileEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPutFiles(Collection<PutFileEntry.BuilderImpl> putFiles) {
            this.putFiles = PutFileEntriesCopier.copyFromBuilder(putFiles);
        }

        public final Collection<DeleteFileEntry.Builder> getDeleteFiles() {
            return this.deleteFiles != null ? (Collection)this.deleteFiles.stream().map(DeleteFileEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deleteFiles(Collection<DeleteFileEntry> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copy(deleteFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(DeleteFileEntry ... deleteFiles) {
            this.deleteFiles(Arrays.asList(deleteFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(Consumer<DeleteFileEntry.Builder> ... deleteFiles) {
            this.deleteFiles(Stream.of(deleteFiles).map(c -> (DeleteFileEntry)((DeleteFileEntry.Builder)DeleteFileEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeleteFiles(Collection<DeleteFileEntry.BuilderImpl> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copyFromBuilder(deleteFiles);
        }

        public final Collection<SetFileModeEntry.Builder> getSetFileModes() {
            return this.setFileModes != null ? (Collection)this.setFileModes.stream().map(SetFileModeEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder setFileModes(Collection<SetFileModeEntry> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copy(setFileModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setFileModes(SetFileModeEntry ... setFileModes) {
            this.setFileModes(Arrays.asList(setFileModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setFileModes(Consumer<SetFileModeEntry.Builder> ... setFileModes) {
            this.setFileModes(Stream.of(setFileModes).map(c -> (SetFileModeEntry)((SetFileModeEntry.Builder)SetFileModeEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSetFileModes(Collection<SetFileModeEntry.BuilderImpl> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copyFromBuilder(setFileModes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCommitRequest build() {
            return new CreateCommitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCommitRequest> {
        public Builder repositoryName(String var1);

        public Builder branchName(String var1);

        public Builder parentCommitId(String var1);

        public Builder authorName(String var1);

        public Builder email(String var1);

        public Builder commitMessage(String var1);

        public Builder keepEmptyFolders(Boolean var1);

        public Builder putFiles(Collection<PutFileEntry> var1);

        public Builder putFiles(PutFileEntry ... var1);

        public Builder putFiles(Consumer<PutFileEntry.Builder> ... var1);

        public Builder deleteFiles(Collection<DeleteFileEntry> var1);

        public Builder deleteFiles(DeleteFileEntry ... var1);

        public Builder deleteFiles(Consumer<DeleteFileEntry.Builder> ... var1);

        public Builder setFileModes(Collection<SetFileModeEntry> var1);

        public Builder setFileModes(SetFileModeEntry ... var1);

        public Builder setFileModes(Consumer<SetFileModeEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

