/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileMetadata> {
    private static final SdkField<String> ABSOLUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileMetadata.getter(FileMetadata::absolutePath)).setter(FileMetadata.setter(Builder::absolutePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolutePath").build()}).build();
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileMetadata.getter(FileMetadata::blobId)).setter(FileMetadata.setter(Builder::blobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()}).build();
    private static final SdkField<String> FILE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileMetadata.getter(FileMetadata::fileModeAsString)).setter(FileMetadata.setter(Builder::fileMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABSOLUTE_PATH_FIELD, BLOB_ID_FIELD, FILE_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String absolutePath;
    private final String blobId;
    private final String fileMode;

    private FileMetadata(BuilderImpl builder) {
        this.absolutePath = builder.absolutePath;
        this.blobId = builder.blobId;
        this.fileMode = builder.fileMode;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public String blobId() {
        return this.blobId;
    }

    public FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(this.fileMode);
    }

    public String fileModeAsString() {
        return this.fileMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.absolutePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileMetadata)) {
            return false;
        }
        FileMetadata other = (FileMetadata)obj;
        return Objects.equals(this.absolutePath(), other.absolutePath()) && Objects.equals(this.blobId(), other.blobId()) && Objects.equals(this.fileModeAsString(), other.fileModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"FileMetadata").add("AbsolutePath", (Object)this.absolutePath()).add("BlobId", (Object)this.blobId()).add("FileMode", (Object)this.fileModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "absolutePath": {
                return Optional.ofNullable(clazz.cast(this.absolutePath()));
            }
            case "blobId": {
                return Optional.ofNullable(clazz.cast(this.blobId()));
            }
            case "fileMode": {
                return Optional.ofNullable(clazz.cast(this.fileModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileMetadata, T> g) {
        return obj -> g.apply((FileMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String absolutePath;
        private String blobId;
        private String fileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FileMetadata model) {
            this.absolutePath(model.absolutePath);
            this.blobId(model.blobId);
            this.fileMode(model.fileMode);
        }

        public final String getAbsolutePath() {
            return this.absolutePath;
        }

        @Override
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
            return this;
        }

        public final void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public final String getBlobId() {
            return this.blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getFileModeAsString() {
            return this.fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        public FileMetadata build() {
            return new FileMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileMetadata> {
        public Builder absolutePath(String var1);

        public Builder blobId(String var1);

        public Builder fileMode(String var1);

        public Builder fileMode(FileModeTypeEnum var1);
    }
}

