/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.Difference;
import software.amazon.awssdk.services.codecommit.model.DifferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDifferencesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetDifferencesResponse> {
    private static final SdkField<List<Difference>> DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDifferencesResponse.getter(GetDifferencesResponse::differences)).setter(GetDifferencesResponse.setter(Builder::differences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Difference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDifferencesResponse.getter(GetDifferencesResponse::nextToken)).setter(GetDifferencesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIFFERENCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Difference> differences;
    private final String nextToken;

    private GetDifferencesResponse(BuilderImpl builder) {
        super(builder);
        this.differences = builder.differences;
        this.nextToken = builder.nextToken;
    }

    public List<Difference> differences() {
        return this.differences;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.differences());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDifferencesResponse)) {
            return false;
        }
        GetDifferencesResponse other = (GetDifferencesResponse)((Object)obj);
        return Objects.equals(this.differences(), other.differences()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDifferencesResponse").add("Differences", this.differences()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "differences": {
                return Optional.ofNullable(clazz.cast(this.differences()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDifferencesResponse, T> g) {
        return obj -> g.apply((GetDifferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<Difference> differences = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDifferencesResponse model) {
            super(model);
            this.differences(model.differences);
            this.nextToken(model.nextToken);
        }

        public final Collection<Difference.Builder> getDifferences() {
            return this.differences != null ? (Collection)this.differences.stream().map(Difference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder differences(Collection<Difference> differences) {
            this.differences = DifferenceListCopier.copy(differences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder differences(Difference ... differences) {
            this.differences(Arrays.asList(differences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder differences(Consumer<Difference.Builder> ... differences) {
            this.differences(Stream.of(differences).map(c -> (Difference)((Difference.Builder)Difference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDifferences(Collection<Difference.BuilderImpl> differences) {
            this.differences = DifferenceListCopier.copyFromBuilder(differences);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDifferencesResponse build() {
            return new GetDifferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDifferencesResponse> {
        public Builder differences(Collection<Difference> var1);

        public Builder differences(Difference ... var1);

        public Builder differences(Consumer<Difference.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

