/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeOperations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MergeOperations> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeOperations.getter(MergeOperations::sourceAsString)).setter(MergeOperations.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeOperations.getter(MergeOperations::destinationAsString)).setter(MergeOperations.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String destination;

    private MergeOperations(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
    }

    public ChangeTypeEnum source() {
        return ChangeTypeEnum.fromValue(this.source);
    }

    public String sourceAsString() {
        return this.source;
    }

    public ChangeTypeEnum destination() {
        return ChangeTypeEnum.fromValue(this.destination);
    }

    public String destinationAsString() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeOperations)) {
            return false;
        }
        MergeOperations other = (MergeOperations)obj;
        return Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.destinationAsString(), other.destinationAsString());
    }

    public String toString() {
        return ToString.builder((String)"MergeOperations").add("Source", (Object)this.sourceAsString()).add("Destination", (Object)this.destinationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeOperations, T> g) {
        return obj -> g.apply((MergeOperations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeOperations model) {
            this.source(model.source);
            this.destination(model.destination);
        }

        public final String getSourceAsString() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(ChangeTypeEnum source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDestinationAsString() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(ChangeTypeEnum destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public MergeOperations build() {
            return new MergeOperations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MergeOperations> {
        public Builder source(String var1);

        public Builder source(ChangeTypeEnum var1);

        public Builder destination(String var1);

        public Builder destination(ChangeTypeEnum var1);
    }
}

