/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestEventType;
import software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequestEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequestEvent> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestEvent.getter(PullRequestEvent::pullRequestId)).setter(PullRequestEvent.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<Instant> EVENT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PullRequestEvent.getter(PullRequestEvent::eventDate)).setter(PullRequestEvent.setter(Builder::eventDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDate").build()}).build();
    private static final SdkField<String> PULL_REQUEST_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestEvent.getter(PullRequestEvent::pullRequestEventTypeAsString)).setter(PullRequestEvent.setter(Builder::pullRequestEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEventType").build()}).build();
    private static final SdkField<String> ACTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestEvent.getter(PullRequestEvent::actorArn)).setter(PullRequestEvent.setter(Builder::actorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorArn").build()}).build();
    private static final SdkField<PullRequestCreatedEventMetadata> PULL_REQUEST_CREATED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PullRequestEvent.getter(PullRequestEvent::pullRequestCreatedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestCreatedEventMetadata)).constructor(PullRequestCreatedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestCreatedEventMetadata").build()}).build();
    private static final SdkField<PullRequestStatusChangedEventMetadata> PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PullRequestEvent.getter(PullRequestEvent::pullRequestStatusChangedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestStatusChangedEventMetadata)).constructor(PullRequestStatusChangedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatusChangedEventMetadata").build()}).build();
    private static final SdkField<PullRequestSourceReferenceUpdatedEventMetadata> PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PullRequestEvent.getter(PullRequestEvent::pullRequestSourceReferenceUpdatedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestSourceReferenceUpdatedEventMetadata)).constructor(PullRequestSourceReferenceUpdatedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestSourceReferenceUpdatedEventMetadata").build()}).build();
    private static final SdkField<PullRequestMergedStateChangedEventMetadata> PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PullRequestEvent.getter(PullRequestEvent::pullRequestMergedStateChangedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestMergedStateChangedEventMetadata)).constructor(PullRequestMergedStateChangedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestMergedStateChangedEventMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, EVENT_DATE_FIELD, PULL_REQUEST_EVENT_TYPE_FIELD, ACTOR_ARN_FIELD, PULL_REQUEST_CREATED_EVENT_METADATA_FIELD, PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD, PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD, PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pullRequestId;
    private final Instant eventDate;
    private final String pullRequestEventType;
    private final String actorArn;
    private final PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata;
    private final PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata;
    private final PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata;
    private final PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata;

    private PullRequestEvent(BuilderImpl builder) {
        this.pullRequestId = builder.pullRequestId;
        this.eventDate = builder.eventDate;
        this.pullRequestEventType = builder.pullRequestEventType;
        this.actorArn = builder.actorArn;
        this.pullRequestCreatedEventMetadata = builder.pullRequestCreatedEventMetadata;
        this.pullRequestStatusChangedEventMetadata = builder.pullRequestStatusChangedEventMetadata;
        this.pullRequestSourceReferenceUpdatedEventMetadata = builder.pullRequestSourceReferenceUpdatedEventMetadata;
        this.pullRequestMergedStateChangedEventMetadata = builder.pullRequestMergedStateChangedEventMetadata;
    }

    public String pullRequestId() {
        return this.pullRequestId;
    }

    public Instant eventDate() {
        return this.eventDate;
    }

    public PullRequestEventType pullRequestEventType() {
        return PullRequestEventType.fromValue(this.pullRequestEventType);
    }

    public String pullRequestEventTypeAsString() {
        return this.pullRequestEventType;
    }

    public String actorArn() {
        return this.actorArn;
    }

    public PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata() {
        return this.pullRequestCreatedEventMetadata;
    }

    public PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata() {
        return this.pullRequestStatusChangedEventMetadata;
    }

    public PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata() {
        return this.pullRequestSourceReferenceUpdatedEventMetadata;
    }

    public PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata() {
        return this.pullRequestMergedStateChangedEventMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestCreatedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestStatusChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestSourceReferenceUpdatedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestMergedStateChangedEventMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestEvent)) {
            return false;
        }
        PullRequestEvent other = (PullRequestEvent)obj;
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.eventDate(), other.eventDate()) && Objects.equals(this.pullRequestEventTypeAsString(), other.pullRequestEventTypeAsString()) && Objects.equals(this.actorArn(), other.actorArn()) && Objects.equals(this.pullRequestCreatedEventMetadata(), other.pullRequestCreatedEventMetadata()) && Objects.equals(this.pullRequestStatusChangedEventMetadata(), other.pullRequestStatusChangedEventMetadata()) && Objects.equals(this.pullRequestSourceReferenceUpdatedEventMetadata(), other.pullRequestSourceReferenceUpdatedEventMetadata()) && Objects.equals(this.pullRequestMergedStateChangedEventMetadata(), other.pullRequestMergedStateChangedEventMetadata());
    }

    public String toString() {
        return ToString.builder((String)"PullRequestEvent").add("PullRequestId", (Object)this.pullRequestId()).add("EventDate", (Object)this.eventDate()).add("PullRequestEventType", (Object)this.pullRequestEventTypeAsString()).add("ActorArn", (Object)this.actorArn()).add("PullRequestCreatedEventMetadata", (Object)this.pullRequestCreatedEventMetadata()).add("PullRequestStatusChangedEventMetadata", (Object)this.pullRequestStatusChangedEventMetadata()).add("PullRequestSourceReferenceUpdatedEventMetadata", (Object)this.pullRequestSourceReferenceUpdatedEventMetadata()).add("PullRequestMergedStateChangedEventMetadata", (Object)this.pullRequestMergedStateChangedEventMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "eventDate": {
                return Optional.ofNullable(clazz.cast(this.eventDate()));
            }
            case "pullRequestEventType": {
                return Optional.ofNullable(clazz.cast(this.pullRequestEventTypeAsString()));
            }
            case "actorArn": {
                return Optional.ofNullable(clazz.cast(this.actorArn()));
            }
            case "pullRequestCreatedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestCreatedEventMetadata()));
            }
            case "pullRequestStatusChangedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestStatusChangedEventMetadata()));
            }
            case "pullRequestSourceReferenceUpdatedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestSourceReferenceUpdatedEventMetadata()));
            }
            case "pullRequestMergedStateChangedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestMergedStateChangedEventMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestEvent, T> g) {
        return obj -> g.apply((PullRequestEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pullRequestId;
        private Instant eventDate;
        private String pullRequestEventType;
        private String actorArn;
        private PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata;
        private PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata;
        private PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata;
        private PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestEvent model) {
            this.pullRequestId(model.pullRequestId);
            this.eventDate(model.eventDate);
            this.pullRequestEventType(model.pullRequestEventType);
            this.actorArn(model.actorArn);
            this.pullRequestCreatedEventMetadata(model.pullRequestCreatedEventMetadata);
            this.pullRequestStatusChangedEventMetadata(model.pullRequestStatusChangedEventMetadata);
            this.pullRequestSourceReferenceUpdatedEventMetadata(model.pullRequestSourceReferenceUpdatedEventMetadata);
            this.pullRequestMergedStateChangedEventMetadata(model.pullRequestMergedStateChangedEventMetadata);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final Instant getEventDate() {
            return this.eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        public final String getPullRequestEventTypeAsString() {
            return this.pullRequestEventType;
        }

        @Override
        public final Builder pullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
            return this;
        }

        @Override
        public final Builder pullRequestEventType(PullRequestEventType pullRequestEventType) {
            this.pullRequestEventType(pullRequestEventType == null ? null : pullRequestEventType.toString());
            return this;
        }

        public final void setPullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
        }

        public final String getActorArn() {
            return this.actorArn;
        }

        @Override
        public final Builder actorArn(String actorArn) {
            this.actorArn = actorArn;
            return this;
        }

        public final void setActorArn(String actorArn) {
            this.actorArn = actorArn;
        }

        public final PullRequestCreatedEventMetadata.Builder getPullRequestCreatedEventMetadata() {
            return this.pullRequestCreatedEventMetadata != null ? this.pullRequestCreatedEventMetadata.toBuilder() : null;
        }

        @Override
        public final Builder pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata) {
            this.pullRequestCreatedEventMetadata = pullRequestCreatedEventMetadata;
            return this;
        }

        public final void setPullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata.BuilderImpl pullRequestCreatedEventMetadata) {
            this.pullRequestCreatedEventMetadata = pullRequestCreatedEventMetadata != null ? pullRequestCreatedEventMetadata.build() : null;
        }

        public final PullRequestStatusChangedEventMetadata.Builder getPullRequestStatusChangedEventMetadata() {
            return this.pullRequestStatusChangedEventMetadata != null ? this.pullRequestStatusChangedEventMetadata.toBuilder() : null;
        }

        @Override
        public final Builder pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata) {
            this.pullRequestStatusChangedEventMetadata = pullRequestStatusChangedEventMetadata;
            return this;
        }

        public final void setPullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata.BuilderImpl pullRequestStatusChangedEventMetadata) {
            this.pullRequestStatusChangedEventMetadata = pullRequestStatusChangedEventMetadata != null ? pullRequestStatusChangedEventMetadata.build() : null;
        }

        public final PullRequestSourceReferenceUpdatedEventMetadata.Builder getPullRequestSourceReferenceUpdatedEventMetadata() {
            return this.pullRequestSourceReferenceUpdatedEventMetadata != null ? this.pullRequestSourceReferenceUpdatedEventMetadata.toBuilder() : null;
        }

        @Override
        public final Builder pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = pullRequestSourceReferenceUpdatedEventMetadata;
            return this;
        }

        public final void setPullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata.BuilderImpl pullRequestSourceReferenceUpdatedEventMetadata) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = pullRequestSourceReferenceUpdatedEventMetadata != null ? pullRequestSourceReferenceUpdatedEventMetadata.build() : null;
        }

        public final PullRequestMergedStateChangedEventMetadata.Builder getPullRequestMergedStateChangedEventMetadata() {
            return this.pullRequestMergedStateChangedEventMetadata != null ? this.pullRequestMergedStateChangedEventMetadata.toBuilder() : null;
        }

        @Override
        public final Builder pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata) {
            this.pullRequestMergedStateChangedEventMetadata = pullRequestMergedStateChangedEventMetadata;
            return this;
        }

        public final void setPullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata.BuilderImpl pullRequestMergedStateChangedEventMetadata) {
            this.pullRequestMergedStateChangedEventMetadata = pullRequestMergedStateChangedEventMetadata != null ? pullRequestMergedStateChangedEventMetadata.build() : null;
        }

        public PullRequestEvent build() {
            return new PullRequestEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequestEvent> {
        public Builder pullRequestId(String var1);

        public Builder eventDate(Instant var1);

        public Builder pullRequestEventType(String var1);

        public Builder pullRequestEventType(PullRequestEventType var1);

        public Builder actorArn(String var1);

        public Builder pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata var1);

        default public Builder pullRequestCreatedEventMetadata(Consumer<PullRequestCreatedEventMetadata.Builder> pullRequestCreatedEventMetadata) {
            return this.pullRequestCreatedEventMetadata((PullRequestCreatedEventMetadata)((PullRequestCreatedEventMetadata.Builder)PullRequestCreatedEventMetadata.builder().applyMutation(pullRequestCreatedEventMetadata)).build());
        }

        public Builder pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata var1);

        default public Builder pullRequestStatusChangedEventMetadata(Consumer<PullRequestStatusChangedEventMetadata.Builder> pullRequestStatusChangedEventMetadata) {
            return this.pullRequestStatusChangedEventMetadata((PullRequestStatusChangedEventMetadata)((PullRequestStatusChangedEventMetadata.Builder)PullRequestStatusChangedEventMetadata.builder().applyMutation(pullRequestStatusChangedEventMetadata)).build());
        }

        public Builder pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata var1);

        default public Builder pullRequestSourceReferenceUpdatedEventMetadata(Consumer<PullRequestSourceReferenceUpdatedEventMetadata.Builder> pullRequestSourceReferenceUpdatedEventMetadata) {
            return this.pullRequestSourceReferenceUpdatedEventMetadata((PullRequestSourceReferenceUpdatedEventMetadata)((PullRequestSourceReferenceUpdatedEventMetadata.Builder)PullRequestSourceReferenceUpdatedEventMetadata.builder().applyMutation(pullRequestSourceReferenceUpdatedEventMetadata)).build());
        }

        public Builder pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata var1);

        default public Builder pullRequestMergedStateChangedEventMetadata(Consumer<PullRequestMergedStateChangedEventMetadata.Builder> pullRequestMergedStateChangedEventMetadata) {
            return this.pullRequestMergedStateChangedEventMetadata((PullRequestMergedStateChangedEventMetadata)((PullRequestMergedStateChangedEventMetadata.Builder)PullRequestMergedStateChangedEventMetadata.builder().applyMutation(pullRequestMergedStateChangedEventMetadata)).build());
        }
    }
}

