/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum;
import software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceContentEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplaceContentEntry> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceContentEntry.getter(ReplaceContentEntry::filePath)).setter(ReplaceContentEntry.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> REPLACEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceContentEntry.getter(ReplaceContentEntry::replacementTypeAsString)).setter(ReplaceContentEntry.setter(Builder::replacementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacementType").build()}).build();
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ReplaceContentEntry.getter(ReplaceContentEntry::content)).setter(ReplaceContentEntry.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> FILE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceContentEntry.getter(ReplaceContentEntry::fileModeAsString)).setter(ReplaceContentEntry.setter(Builder::fileMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, REPLACEMENT_TYPE_FIELD, CONTENT_FIELD, FILE_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String replacementType;
    private final SdkBytes content;
    private final String fileMode;

    private ReplaceContentEntry(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.replacementType = builder.replacementType;
        this.content = builder.content;
        this.fileMode = builder.fileMode;
    }

    public String filePath() {
        return this.filePath;
    }

    public ReplacementTypeEnum replacementType() {
        return ReplacementTypeEnum.fromValue(this.replacementType);
    }

    public String replacementTypeAsString() {
        return this.replacementType;
    }

    public SdkBytes content() {
        return this.content;
    }

    public FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(this.fileMode);
    }

    public String fileModeAsString() {
        return this.fileMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceContentEntry)) {
            return false;
        }
        ReplaceContentEntry other = (ReplaceContentEntry)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.replacementTypeAsString(), other.replacementTypeAsString()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.fileModeAsString(), other.fileModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReplaceContentEntry").add("FilePath", (Object)this.filePath()).add("ReplacementType", (Object)this.replacementTypeAsString()).add("Content", (Object)this.content()).add("FileMode", (Object)this.fileModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "replacementType": {
                return Optional.ofNullable(clazz.cast(this.replacementTypeAsString()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "fileMode": {
                return Optional.ofNullable(clazz.cast(this.fileModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceContentEntry, T> g) {
        return obj -> g.apply((ReplaceContentEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private String replacementType;
        private SdkBytes content;
        private String fileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceContentEntry model) {
            this.filePath(model.filePath);
            this.replacementType(model.replacementType);
            this.content(model.content);
            this.fileMode(model.fileMode);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public final String getReplacementTypeAsString() {
            return this.replacementType;
        }

        @Override
        public final Builder replacementType(String replacementType) {
            this.replacementType = replacementType;
            return this;
        }

        @Override
        public final Builder replacementType(ReplacementTypeEnum replacementType) {
            this.replacementType(replacementType == null ? null : replacementType.toString());
            return this;
        }

        public final void setReplacementType(String replacementType) {
            this.replacementType = replacementType;
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = StandardMemberCopier.copy((SdkBytes)content);
            return this;
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        public final String getFileModeAsString() {
            return this.fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        public ReplaceContentEntry build() {
            return new ReplaceContentEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplaceContentEntry> {
        public Builder filePath(String var1);

        public Builder replacementType(String var1);

        public Builder replacementType(ReplacementTypeEnum var1);

        public Builder content(SdkBytes var1);

        public Builder fileMode(String var1);

        public Builder fileMode(FileModeTypeEnum var1);
    }
}

