/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePullRequestEventsResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DescribePullRequestEventsResponse.Builder, DescribePullRequestEventsResponse> {
    private static final SdkField<List<PullRequestEvent>> PULL_REQUEST_EVENTS_FIELD = SdkField
            .<List<PullRequestEvent>> builder(MarshallingType.LIST)
            .getter(getter(DescribePullRequestEventsResponse::pullRequestEvents))
            .setter(setter(Builder::pullRequestEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PullRequestEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(PullRequestEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePullRequestEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PullRequestEvent> pullRequestEvents;

    private final String nextToken;

    private DescribePullRequestEventsResponse(BuilderImpl builder) {
        super(builder);
        this.pullRequestEvents = builder.pullRequestEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the pull request events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the pull request events.
     */
    public List<PullRequestEvent> pullRequestEvents() {
        return pullRequestEvents;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEvents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePullRequestEventsResponse)) {
            return false;
        }
        DescribePullRequestEventsResponse other = (DescribePullRequestEventsResponse) obj;
        return Objects.equals(pullRequestEvents(), other.pullRequestEvents()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePullRequestEventsResponse").add("PullRequestEvents", pullRequestEvents())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestEvents":
            return Optional.ofNullable(clazz.cast(pullRequestEvents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePullRequestEventsResponse, T> g) {
        return obj -> g.apply((DescribePullRequestEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePullRequestEventsResponse> {
        /**
         * <p>
         * Information about the pull request events.
         * </p>
         * 
         * @param pullRequestEvents
         *        Information about the pull request events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestEvents(Collection<PullRequestEvent> pullRequestEvents);

        /**
         * <p>
         * Information about the pull request events.
         * </p>
         * 
         * @param pullRequestEvents
         *        Information about the pull request events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestEvents(PullRequestEvent... pullRequestEvents);

        /**
         * <p>
         * Information about the pull request events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PullRequestEvent>.Builder} avoiding the
         * need to create one manually via {@link List<PullRequestEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PullRequestEvent>.Builder#build()} is called immediately and
         * its result is passed to {@link #pullRequestEvents(List<PullRequestEvent>)}.
         * 
         * @param pullRequestEvents
         *        a consumer that will call methods on {@link List<PullRequestEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullRequestEvents(List<PullRequestEvent>)
         */
        Builder pullRequestEvents(Consumer<PullRequestEvent.Builder>... pullRequestEvents);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<PullRequestEvent> pullRequestEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePullRequestEventsResponse model) {
            super(model);
            pullRequestEvents(model.pullRequestEvents);
            nextToken(model.nextToken);
        }

        public final Collection<PullRequestEvent.Builder> getPullRequestEvents() {
            return pullRequestEvents != null ? pullRequestEvents.stream().map(PullRequestEvent::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pullRequestEvents(Collection<PullRequestEvent> pullRequestEvents) {
            this.pullRequestEvents = PullRequestEventListCopier.copy(pullRequestEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestEvents(PullRequestEvent... pullRequestEvents) {
            pullRequestEvents(Arrays.asList(pullRequestEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestEvents(Consumer<PullRequestEvent.Builder>... pullRequestEvents) {
            pullRequestEvents(Stream.of(pullRequestEvents).map(c -> PullRequestEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPullRequestEvents(Collection<PullRequestEvent.BuilderImpl> pullRequestEvents) {
            this.pullRequestEvents = PullRequestEventListCopier.copyFromBuilder(pullRequestEvents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePullRequestEventsResponse build() {
            return new DescribePullRequestEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
