/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommentsForPullRequestRequest extends CodeCommitRequest implements
        ToCopyableBuilder<GetCommentsForPullRequestRequest.Builder, GetCommentsForPullRequestRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommentsForPullRequestRequest::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommentsForPullRequestRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommentsForPullRequestRequest::beforeCommitId)).setter(setter(Builder::beforeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()).build();

    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommentsForPullRequestRequest::afterCommitId)).setter(setter(Builder::afterCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommentsForPullRequestRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetCommentsForPullRequestRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            REPOSITORY_NAME_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String pullRequestId;

    private final String repositoryName;

    private final String beforeCommitId;

    private final String afterCommitId;

    private final String nextToken;

    private final Integer maxResults;

    private GetCommentsForPullRequestRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     * </p>
     * 
     * @return The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     */
    public String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The name of the repository that contains the pull request.
     * </p>
     * 
     * @return The name of the repository that contains the pull request.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull
     * request was created.
     * </p>
     * 
     * @return The full commit ID of the commit in the destination branch that was the tip of the branch at the time the
     *         pull request was created.
     */
    public String beforeCommitId() {
        return beforeCommitId;
    }

    /**
     * <p>
     * The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was
     * made.
     * </p>
     * 
     * @return The full commit ID of the commit in the source branch that was the tip of the branch at the time the
     *         comment was made.
     */
    public String afterCommitId() {
        return afterCommitId;
    }

    /**
     * <p>
     * An enumeration token that when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that when provided in a request, returns the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A non-negative integer used to limit the number of returned results. The default is 100 comments. You can return
     * up to 500 comments with a single request.
     * </p>
     * 
     * @return A non-negative integer used to limit the number of returned results. The default is 100 comments. You can
     *         return up to 500 comments with a single request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentsForPullRequestRequest)) {
            return false;
        }
        GetCommentsForPullRequestRequest other = (GetCommentsForPullRequestRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(beforeCommitId(), other.beforeCommitId())
                && Objects.equals(afterCommitId(), other.afterCommitId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCommentsForPullRequestRequest").add("PullRequestId", pullRequestId())
                .add("RepositoryName", repositoryName()).add("BeforeCommitId", beforeCommitId())
                .add("AfterCommitId", afterCommitId()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "beforeCommitId":
            return Optional.ofNullable(clazz.cast(beforeCommitId()));
        case "afterCommitId":
            return Optional.ofNullable(clazz.cast(afterCommitId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommentsForPullRequestRequest, T> g) {
        return obj -> g.apply((GetCommentsForPullRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCommentsForPullRequestRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The name of the repository that contains the pull request.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The full commit ID of the commit in the destination branch that was the tip of the branch at the time the
         * pull request was created.
         * </p>
         * 
         * @param beforeCommitId
         *        The full commit ID of the commit in the destination branch that was the tip of the branch at the time
         *        the pull request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitId(String beforeCommitId);

        /**
         * <p>
         * The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment
         * was made.
         * </p>
         * 
         * @param afterCommitId
         *        The full commit ID of the commit in the source branch that was the tip of the branch at the time the
         *        comment was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitId(String afterCommitId);

        /**
         * <p>
         * An enumeration token that when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A non-negative integer used to limit the number of returned results. The default is 100 comments. You can
         * return up to 500 comments with a single request.
         * </p>
         * 
         * @param maxResults
         *        A non-negative integer used to limit the number of returned results. The default is 100 comments. You
         *        can return up to 500 comments with a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String repositoryName;

        private String beforeCommitId;

        private String afterCommitId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentsForPullRequestRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            repositoryName(model.repositoryName);
            beforeCommitId(model.beforeCommitId);
            afterCommitId(model.afterCommitId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBeforeCommitId() {
            return beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        public final String getAfterCommitId() {
            return afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommentsForPullRequestRequest build() {
            return new GetCommentsForPullRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
