/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMergeCommitResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetMergeCommitResponse.Builder, GetMergeCommitResponse> {
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeCommitResponse::sourceCommitId)).setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeCommitResponse::destinationCommitId)).setter(setter(Builder::destinationCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build())
            .build();

    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeCommitResponse::baseCommitId)).setter(setter(Builder::baseCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()).build();

    private static final SdkField<String> MERGED_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeCommitResponse::mergedCommitId)).setter(setter(Builder::mergedCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedCommitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COMMIT_ID_FIELD,
            DESTINATION_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD, MERGED_COMMIT_ID_FIELD));

    private final String sourceCommitId;

    private final String destinationCommitId;

    private final String baseCommitId;

    private final String mergedCommitId;

    private GetMergeCommitResponse(BuilderImpl builder) {
        super(builder);
        this.sourceCommitId = builder.sourceCommitId;
        this.destinationCommitId = builder.destinationCommitId;
        this.baseCommitId = builder.baseCommitId;
        this.mergedCommitId = builder.mergedCommitId;
    }

    /**
     * <p>
     * The commit ID of the source commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the source commit specifier that was used in the merge evaluation.
     */
    public String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The commit ID of the destination commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the destination commit specifier that was used in the merge evaluation.
     */
    public String destinationCommitId() {
        return destinationCommitId;
    }

    /**
     * <p>
     * The commit ID of the merge base.
     * </p>
     * 
     * @return The commit ID of the merge base.
     */
    public String baseCommitId() {
        return baseCommitId;
    }

    /**
     * <p>
     * The commit ID for the merge commit created when the source branch was merged into the destination branch. If the
     * fast-forward merge strategy was used, no merge commit exists.
     * </p>
     * 
     * @return The commit ID for the merge commit created when the source branch was merged into the destination branch.
     *         If the fast-forward merge strategy was used, no merge commit exists.
     */
    public String mergedCommitId() {
        return mergedCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(baseCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(mergedCommitId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeCommitResponse)) {
            return false;
        }
        GetMergeCommitResponse other = (GetMergeCommitResponse) obj;
        return Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(destinationCommitId(), other.destinationCommitId())
                && Objects.equals(baseCommitId(), other.baseCommitId())
                && Objects.equals(mergedCommitId(), other.mergedCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMergeCommitResponse").add("SourceCommitId", sourceCommitId())
                .add("DestinationCommitId", destinationCommitId()).add("BaseCommitId", baseCommitId())
                .add("MergedCommitId", mergedCommitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "destinationCommitId":
            return Optional.ofNullable(clazz.cast(destinationCommitId()));
        case "baseCommitId":
            return Optional.ofNullable(clazz.cast(baseCommitId()));
        case "mergedCommitId":
            return Optional.ofNullable(clazz.cast(mergedCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeCommitResponse, T> g) {
        return obj -> g.apply((GetMergeCommitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMergeCommitResponse> {
        /**
         * <p>
         * The commit ID of the source commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param sourceCommitId
         *        The commit ID of the source commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The commit ID of the destination commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param destinationCommitId
         *        The commit ID of the destination commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitId(String destinationCommitId);

        /**
         * <p>
         * The commit ID of the merge base.
         * </p>
         * 
         * @param baseCommitId
         *        The commit ID of the merge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCommitId(String baseCommitId);

        /**
         * <p>
         * The commit ID for the merge commit created when the source branch was merged into the destination branch. If
         * the fast-forward merge strategy was used, no merge commit exists.
         * </p>
         * 
         * @param mergedCommitId
         *        The commit ID for the merge commit created when the source branch was merged into the destination
         *        branch. If the fast-forward merge strategy was used, no merge commit exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedCommitId(String mergedCommitId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String sourceCommitId;

        private String destinationCommitId;

        private String baseCommitId;

        private String mergedCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeCommitResponse model) {
            super(model);
            sourceCommitId(model.sourceCommitId);
            destinationCommitId(model.destinationCommitId);
            baseCommitId(model.baseCommitId);
            mergedCommitId(model.mergedCommitId);
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        public final String getDestinationCommitId() {
            return destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getBaseCommitId() {
            return baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        public final String getMergedCommitId() {
            return mergedCommitId;
        }

        @Override
        public final Builder mergedCommitId(String mergedCommitId) {
            this.mergedCommitId = mergedCommitId;
            return this;
        }

        public final void setMergedCommitId(String mergedCommitId) {
            this.mergedCommitId = mergedCommitId;
        }

        @Override
        public GetMergeCommitResponse build() {
            return new GetMergeCommitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
