/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMergeOptionsResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetMergeOptionsResponse.Builder, GetMergeOptionsResponse> {
    private static final SdkField<List<String>> MERGE_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetMergeOptionsResponse::mergeOptionsAsStrings))
            .setter(setter(Builder::mergeOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeOptionsResponse::sourceCommitId)).setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeOptionsResponse::destinationCommitId)).setter(setter(Builder::destinationCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build())
            .build();

    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeOptionsResponse::baseCommitId)).setter(setter(Builder::baseCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_OPTIONS_FIELD,
            SOURCE_COMMIT_ID_FIELD, DESTINATION_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD));

    private final List<String> mergeOptions;

    private final String sourceCommitId;

    private final String destinationCommitId;

    private final String baseCommitId;

    private GetMergeOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.mergeOptions = builder.mergeOptions;
        this.sourceCommitId = builder.sourceCommitId;
        this.destinationCommitId = builder.destinationCommitId;
        this.baseCommitId = builder.baseCommitId;
    }

    /**
     * <p>
     * The merge option or strategy used to merge the code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The merge option or strategy used to merge the code.
     */
    public List<MergeOptionTypeEnum> mergeOptions() {
        return MergeOptionsCopier.copyStringToEnum(mergeOptions);
    }

    /**
     * <p>
     * The merge option or strategy used to merge the code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The merge option or strategy used to merge the code.
     */
    public List<String> mergeOptionsAsStrings() {
        return mergeOptions;
    }

    /**
     * <p>
     * The commit ID of the source commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the source commit specifier that was used in the merge evaluation.
     */
    public String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The commit ID of the destination commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the destination commit specifier that was used in the merge evaluation.
     */
    public String destinationCommitId() {
        return destinationCommitId;
    }

    /**
     * <p>
     * The commit ID of the merge base.
     * </p>
     * 
     * @return The commit ID of the merge base.
     */
    public String baseCommitId() {
        return baseCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mergeOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(baseCommitId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeOptionsResponse)) {
            return false;
        }
        GetMergeOptionsResponse other = (GetMergeOptionsResponse) obj;
        return Objects.equals(mergeOptionsAsStrings(), other.mergeOptionsAsStrings())
                && Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(destinationCommitId(), other.destinationCommitId())
                && Objects.equals(baseCommitId(), other.baseCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMergeOptionsResponse").add("MergeOptions", mergeOptionsAsStrings())
                .add("SourceCommitId", sourceCommitId()).add("DestinationCommitId", destinationCommitId())
                .add("BaseCommitId", baseCommitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mergeOptions":
            return Optional.ofNullable(clazz.cast(mergeOptionsAsStrings()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "destinationCommitId":
            return Optional.ofNullable(clazz.cast(destinationCommitId()));
        case "baseCommitId":
            return Optional.ofNullable(clazz.cast(baseCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeOptionsResponse, T> g) {
        return obj -> g.apply((GetMergeOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMergeOptionsResponse> {
        /**
         * <p>
         * The merge option or strategy used to merge the code.
         * </p>
         * 
         * @param mergeOptions
         *        The merge option or strategy used to merge the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeOptionsWithStrings(Collection<String> mergeOptions);

        /**
         * <p>
         * The merge option or strategy used to merge the code.
         * </p>
         * 
         * @param mergeOptions
         *        The merge option or strategy used to merge the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeOptionsWithStrings(String... mergeOptions);

        /**
         * <p>
         * The merge option or strategy used to merge the code.
         * </p>
         * 
         * @param mergeOptions
         *        The merge option or strategy used to merge the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeOptions(Collection<MergeOptionTypeEnum> mergeOptions);

        /**
         * <p>
         * The merge option or strategy used to merge the code.
         * </p>
         * 
         * @param mergeOptions
         *        The merge option or strategy used to merge the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeOptions(MergeOptionTypeEnum... mergeOptions);

        /**
         * <p>
         * The commit ID of the source commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param sourceCommitId
         *        The commit ID of the source commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The commit ID of the destination commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param destinationCommitId
         *        The commit ID of the destination commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitId(String destinationCommitId);

        /**
         * <p>
         * The commit ID of the merge base.
         * </p>
         * 
         * @param baseCommitId
         *        The commit ID of the merge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCommitId(String baseCommitId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> mergeOptions = DefaultSdkAutoConstructList.getInstance();

        private String sourceCommitId;

        private String destinationCommitId;

        private String baseCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeOptionsResponse model) {
            super(model);
            mergeOptionsWithStrings(model.mergeOptions);
            sourceCommitId(model.sourceCommitId);
            destinationCommitId(model.destinationCommitId);
            baseCommitId(model.baseCommitId);
        }

        public final Collection<String> getMergeOptionsAsStrings() {
            return mergeOptions;
        }

        @Override
        public final Builder mergeOptionsWithStrings(Collection<String> mergeOptions) {
            this.mergeOptions = MergeOptionsCopier.copy(mergeOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeOptionsWithStrings(String... mergeOptions) {
            mergeOptionsWithStrings(Arrays.asList(mergeOptions));
            return this;
        }

        @Override
        public final Builder mergeOptions(Collection<MergeOptionTypeEnum> mergeOptions) {
            this.mergeOptions = MergeOptionsCopier.copyEnumToString(mergeOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeOptions(MergeOptionTypeEnum... mergeOptions) {
            mergeOptions(Arrays.asList(mergeOptions));
            return this;
        }

        public final void setMergeOptionsWithStrings(Collection<String> mergeOptions) {
            this.mergeOptions = MergeOptionsCopier.copy(mergeOptions);
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        public final String getDestinationCommitId() {
            return destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getBaseCommitId() {
            return baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public GetMergeOptionsResponse build() {
            return new GetMergeOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
