/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostCommentForComparedCommitRequest extends CodeCommitRequest implements
        ToCopyableBuilder<PostCommentForComparedCommitRequest.Builder, PostCommentForComparedCommitRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitRequest::beforeCommitId)).setter(setter(Builder::beforeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()).build();

    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitRequest::afterCommitId)).setter(setter(Builder::afterCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(PostCommentForComparedCommitRequest::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PostCommentForComparedCommitRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, LOCATION_FIELD, CONTENT_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String repositoryName;

    private final String beforeCommitId;

    private final String afterCommitId;

    private final Location location;

    private final String content;

    private final String clientRequestToken;

    private PostCommentForComparedCommitRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.location = builder.location;
        this.content = builder.content;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the repository where you want to post a comment on the comparison between commits.
     * </p>
     * 
     * @return The name of the repository where you want to post a comment on the comparison between commits.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * To establish the directionality of the comparison, the full commit ID of the 'before' commit.
     * </p>
     * <note>
     * <p>
     * This is required for commenting on any commit unless that commit is the initial commit.
     * </p>
     * </note>
     * 
     * @return To establish the directionality of the comparison, the full commit ID of the 'before' commit.</p> <note>
     *         <p>
     *         This is required for commenting on any commit unless that commit is the initial commit.
     *         </p>
     */
    public String beforeCommitId() {
        return beforeCommitId;
    }

    /**
     * <p>
     * To establish the directionality of the comparison, the full commit ID of the 'after' commit.
     * </p>
     * 
     * @return To establish the directionality of the comparison, the full commit ID of the 'after' commit.
     */
    public String afterCommitId() {
        return afterCommitId;
    }

    /**
     * <p>
     * The location of the comparison where you want to comment.
     * </p>
     * 
     * @return The location of the comparison where you want to comment.
     */
    public Location location() {
        return location;
    }

    /**
     * <p>
     * The content of the comment you want to make.
     * </p>
     * 
     * @return The content of the comment you want to make.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * A unique, client-generated idempotency token that when provided in a request, ensures the request cannot be
     * repeated with a changed parameter. If a request is received with the same parameters and a token is included, the
     * request will return information about the initial request that used that token.
     * </p>
     * 
     * @return A unique, client-generated idempotency token that when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request will return information about the initial request that used that token.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentForComparedCommitRequest)) {
            return false;
        }
        PostCommentForComparedCommitRequest other = (PostCommentForComparedCommitRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(beforeCommitId(), other.beforeCommitId())
                && Objects.equals(afterCommitId(), other.afterCommitId()) && Objects.equals(location(), other.location())
                && Objects.equals(content(), other.content()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PostCommentForComparedCommitRequest").add("RepositoryName", repositoryName())
                .add("BeforeCommitId", beforeCommitId()).add("AfterCommitId", afterCommitId()).add("Location", location())
                .add("Content", content()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "beforeCommitId":
            return Optional.ofNullable(clazz.cast(beforeCommitId()));
        case "afterCommitId":
            return Optional.ofNullable(clazz.cast(afterCommitId()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostCommentForComparedCommitRequest, T> g) {
        return obj -> g.apply((PostCommentForComparedCommitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PostCommentForComparedCommitRequest> {
        /**
         * <p>
         * The name of the repository where you want to post a comment on the comparison between commits.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you want to post a comment on the comparison between commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * To establish the directionality of the comparison, the full commit ID of the 'before' commit.
         * </p>
         * <note>
         * <p>
         * This is required for commenting on any commit unless that commit is the initial commit.
         * </p>
         * </note>
         * 
         * @param beforeCommitId
         *        To establish the directionality of the comparison, the full commit ID of the 'before' commit.</p>
         *        <note>
         *        <p>
         *        This is required for commenting on any commit unless that commit is the initial commit.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitId(String beforeCommitId);

        /**
         * <p>
         * To establish the directionality of the comparison, the full commit ID of the 'after' commit.
         * </p>
         * 
         * @param afterCommitId
         *        To establish the directionality of the comparison, the full commit ID of the 'after' commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitId(String afterCommitId);

        /**
         * <p>
         * The location of the comparison where you want to comment.
         * </p>
         * 
         * @param location
         *        The location of the comparison where you want to comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * The location of the comparison where you want to comment.
         * </p>
         * This is a convenience that creates an instance of the {@link Location.Builder} avoiding the need to create
         * one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The content of the comment you want to make.
         * </p>
         * 
         * @param content
         *        The content of the comment you want to make.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A unique, client-generated idempotency token that when provided in a request, ensures the request cannot be
         * repeated with a changed parameter. If a request is received with the same parameters and a token is included,
         * the request will return information about the initial request that used that token.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, client-generated idempotency token that when provided in a request, ensures the request
         *        cannot be repeated with a changed parameter. If a request is received with the same parameters and a
         *        token is included, the request will return information about the initial request that used that token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String beforeCommitId;

        private String afterCommitId;

        private Location location;

        private String content;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentForComparedCommitRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            beforeCommitId(model.beforeCommitId);
            afterCommitId(model.afterCommitId);
            location(model.location);
            content(model.content);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBeforeCommitId() {
            return beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        public final String getAfterCommitId() {
            return afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostCommentForComparedCommitRequest build() {
            return new PostCommentForComparedCommitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
