/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a put repository triggers operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRepositoryTriggersResponse extends CodeCommitResponse implements
        ToCopyableBuilder<PutRepositoryTriggersResponse.Builder, PutRepositoryTriggersResponse> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutRepositoryTriggersResponse::configurationId)).setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD));

    private final String configurationId;

    private PutRepositoryTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
    }

    /**
     * <p>
     * The system-generated unique ID for the create or update operation.
     * </p>
     * 
     * @return The system-generated unique ID for the create or update operation.
     */
    public String configurationId() {
        return configurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRepositoryTriggersResponse)) {
            return false;
        }
        PutRepositoryTriggersResponse other = (PutRepositoryTriggersResponse) obj;
        return Objects.equals(configurationId(), other.configurationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRepositoryTriggersResponse").add("ConfigurationId", configurationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRepositoryTriggersResponse, T> g) {
        return obj -> g.apply((PutRepositoryTriggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRepositoryTriggersResponse> {
        /**
         * <p>
         * The system-generated unique ID for the create or update operation.
         * </p>
         * 
         * @param configurationId
         *        The system-generated unique ID for the create or update operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String configurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRepositoryTriggersResponse model) {
            super(model);
            configurationId(model.configurationId);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public PutRepositoryTriggersResponse build() {
            return new PutRepositoryTriggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
