/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a repository with a sync configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositorySyncDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositorySyncDefinition.Builder, RepositorySyncDefinition> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(RepositorySyncDefinition::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Directory").getter(getter(RepositorySyncDefinition::directory)).setter(setter(Builder::directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directory").build()).build();

    private static final SdkField<String> PARENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Parent")
            .getter(getter(RepositorySyncDefinition::parent)).setter(setter(Builder::parent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parent").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(RepositorySyncDefinition::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, DIRECTORY_FIELD,
            PARENT_FIELD, TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String branch;

    private final String directory;

    private final String parent;

    private final String target;

    private RepositorySyncDefinition(BuilderImpl builder) {
        this.branch = builder.branch;
        this.directory = builder.directory;
        this.parent = builder.parent;
        this.target = builder.target;
    }

    /**
     * <p>
     * The branch specified for a repository sync definition.
     * </p>
     * 
     * @return The branch specified for a repository sync definition.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The configuration file for a repository sync definition. This value comes from creating or updating the
     * <code>config-file</code> field of a <code>sync-configuration</code>.
     * </p>
     * 
     * @return The configuration file for a repository sync definition. This value comes from creating or updating the
     *         <code>config-file</code> field of a <code>sync-configuration</code>.
     */
    public final String directory() {
        return directory;
    }

    /**
     * <p>
     * The parent resource specified for a repository sync definition.
     * </p>
     * 
     * @return The parent resource specified for a repository sync definition.
     */
    public final String parent() {
        return parent;
    }

    /**
     * <p>
     * The target resource specified for a repository sync definition. In some cases, such as CFN_STACK_SYNC, the parent
     * and target resource are the same.
     * </p>
     * 
     * @return The target resource specified for a repository sync definition. In some cases, such as CFN_STACK_SYNC,
     *         the parent and target resource are the same.
     */
    public final String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(directory());
        hashCode = 31 * hashCode + Objects.hashCode(parent());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySyncDefinition)) {
            return false;
        }
        RepositorySyncDefinition other = (RepositorySyncDefinition) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(directory(), other.directory())
                && Objects.equals(parent(), other.parent()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositorySyncDefinition").add("Branch", branch()).add("Directory", directory())
                .add("Parent", parent()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "Directory":
            return Optional.ofNullable(clazz.cast(directory()));
        case "Parent":
            return Optional.ofNullable(clazz.cast(parent()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositorySyncDefinition, T> g) {
        return obj -> g.apply((RepositorySyncDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositorySyncDefinition> {
        /**
         * <p>
         * The branch specified for a repository sync definition.
         * </p>
         * 
         * @param branch
         *        The branch specified for a repository sync definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The configuration file for a repository sync definition. This value comes from creating or updating the
         * <code>config-file</code> field of a <code>sync-configuration</code>.
         * </p>
         * 
         * @param directory
         *        The configuration file for a repository sync definition. This value comes from creating or updating
         *        the <code>config-file</code> field of a <code>sync-configuration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directory(String directory);

        /**
         * <p>
         * The parent resource specified for a repository sync definition.
         * </p>
         * 
         * @param parent
         *        The parent resource specified for a repository sync definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parent(String parent);

        /**
         * <p>
         * The target resource specified for a repository sync definition. In some cases, such as CFN_STACK_SYNC, the
         * parent and target resource are the same.
         * </p>
         * 
         * @param target
         *        The target resource specified for a repository sync definition. In some cases, such as CFN_STACK_SYNC,
         *        the parent and target resource are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl implements Builder {
        private String branch;

        private String directory;

        private String parent;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySyncDefinition model) {
            branch(model.branch);
            directory(model.directory);
            parent(model.parent);
            target(model.target);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getDirectory() {
            return directory;
        }

        public final void setDirectory(String directory) {
            this.directory = directory;
        }

        @Override
        public final Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public final String getParent() {
            return parent;
        }

        public final void setParent(String parent) {
            this.parent = parent;
        }

        @Override
        public final Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public RepositorySyncDefinition build() {
            return new RepositorySyncDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
