/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a blocker for a sync event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncBlocker implements SdkPojo, Serializable, ToCopyableBuilder<SyncBlocker.Builder, SyncBlocker> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SyncBlocker::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SyncBlocker::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SyncBlocker::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CREATED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedReason").getter(getter(SyncBlocker::createdReason)).setter(setter(Builder::createdReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedReason").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(SyncBlocker::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<List<SyncBlockerContext>> CONTEXTS_FIELD = SdkField
            .<List<SyncBlockerContext>> builder(MarshallingType.LIST)
            .memberName("Contexts")
            .getter(getter(SyncBlocker::contexts))
            .setter(setter(Builder::contexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SyncBlockerContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyncBlockerContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOLVED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolvedReason").getter(getter(SyncBlocker::resolvedReason)).setter(setter(Builder::resolvedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedReason").build()).build();

    private static final SdkField<Instant> RESOLVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResolvedAt").getter(getter(SyncBlocker::resolvedAt)).setter(setter(Builder::resolvedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            STATUS_FIELD, CREATED_REASON_FIELD, CREATED_AT_FIELD, CONTEXTS_FIELD, RESOLVED_REASON_FIELD, RESOLVED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String status;

    private final String createdReason;

    private final Instant createdAt;

    private final List<SyncBlockerContext> contexts;

    private final String resolvedReason;

    private final Instant resolvedAt;

    private SyncBlocker(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.createdReason = builder.createdReason;
        this.createdAt = builder.createdAt;
        this.contexts = builder.contexts;
        this.resolvedReason = builder.resolvedReason;
        this.resolvedAt = builder.resolvedAt;
    }

    /**
     * <p>
     * The ID for a specific sync blocker.
     * </p>
     * 
     * @return The ID for a specific sync blocker.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The sync blocker type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlockerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The sync blocker type.
     * @see BlockerType
     */
    public final BlockerType type() {
        return BlockerType.fromValue(type);
    }

    /**
     * <p>
     * The sync blocker type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlockerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The sync blocker type.
     * @see BlockerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status for a specific sync blocker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BlockerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for a specific sync blocker.
     * @see BlockerStatus
     */
    public final BlockerStatus status() {
        return BlockerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status for a specific sync blocker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BlockerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for a specific sync blocker.
     * @see BlockerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The provided reason for a specific sync blocker.
     * </p>
     * 
     * @return The provided reason for a specific sync blocker.
     */
    public final String createdReason() {
        return createdReason;
    }

    /**
     * <p>
     * The creation time for a specific sync blocker.
     * </p>
     * 
     * @return The creation time for a specific sync blocker.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContexts() {
        return contexts != null && !(contexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contexts for a specific sync blocker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContexts} method.
     * </p>
     * 
     * @return The contexts for a specific sync blocker.
     */
    public final List<SyncBlockerContext> contexts() {
        return contexts;
    }

    /**
     * <p>
     * The resolved reason for a specific sync blocker.
     * </p>
     * 
     * @return The resolved reason for a specific sync blocker.
     */
    public final String resolvedReason() {
        return resolvedReason;
    }

    /**
     * <p>
     * The time that a specific sync blocker was resolved.
     * </p>
     * 
     * @return The time that a specific sync blocker was resolved.
     */
    public final Instant resolvedAt() {
        return resolvedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasContexts() ? contexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolvedReason());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncBlocker)) {
            return false;
        }
        SyncBlocker other = (SyncBlocker) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdReason(), other.createdReason()) && Objects.equals(createdAt(), other.createdAt())
                && hasContexts() == other.hasContexts() && Objects.equals(contexts(), other.contexts())
                && Objects.equals(resolvedReason(), other.resolvedReason()) && Objects.equals(resolvedAt(), other.resolvedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncBlocker").add("Id", id()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("CreatedReason", createdReason()).add("CreatedAt", createdAt())
                .add("Contexts", hasContexts() ? contexts() : null).add("ResolvedReason", resolvedReason())
                .add("ResolvedAt", resolvedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedReason":
            return Optional.ofNullable(clazz.cast(createdReason()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Contexts":
            return Optional.ofNullable(clazz.cast(contexts()));
        case "ResolvedReason":
            return Optional.ofNullable(clazz.cast(resolvedReason()));
        case "ResolvedAt":
            return Optional.ofNullable(clazz.cast(resolvedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncBlocker, T> g) {
        return obj -> g.apply((SyncBlocker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncBlocker> {
        /**
         * <p>
         * The ID for a specific sync blocker.
         * </p>
         * 
         * @param id
         *        The ID for a specific sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The sync blocker type.
         * </p>
         * 
         * @param type
         *        The sync blocker type.
         * @see BlockerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerType
         */
        Builder type(String type);

        /**
         * <p>
         * The sync blocker type.
         * </p>
         * 
         * @param type
         *        The sync blocker type.
         * @see BlockerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerType
         */
        Builder type(BlockerType type);

        /**
         * <p>
         * The status for a specific sync blocker.
         * </p>
         * 
         * @param status
         *        The status for a specific sync blocker.
         * @see BlockerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status for a specific sync blocker.
         * </p>
         * 
         * @param status
         *        The status for a specific sync blocker.
         * @see BlockerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockerStatus
         */
        Builder status(BlockerStatus status);

        /**
         * <p>
         * The provided reason for a specific sync blocker.
         * </p>
         * 
         * @param createdReason
         *        The provided reason for a specific sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdReason(String createdReason);

        /**
         * <p>
         * The creation time for a specific sync blocker.
         * </p>
         * 
         * @param createdAt
         *        The creation time for a specific sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The contexts for a specific sync blocker.
         * </p>
         * 
         * @param contexts
         *        The contexts for a specific sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(Collection<SyncBlockerContext> contexts);

        /**
         * <p>
         * The contexts for a specific sync blocker.
         * </p>
         * 
         * @param contexts
         *        The contexts for a specific sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(SyncBlockerContext... contexts);

        /**
         * <p>
         * The contexts for a specific sync blocker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeconnections.model.SyncBlockerContext.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codeconnections.model.SyncBlockerContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeconnections.model.SyncBlockerContext.Builder#build()} is called
         * immediately and its result is passed to {@link #contexts(List<SyncBlockerContext>)}.
         * 
         * @param contexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeconnections.model.SyncBlockerContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contexts(java.util.Collection<SyncBlockerContext>)
         */
        Builder contexts(Consumer<SyncBlockerContext.Builder>... contexts);

        /**
         * <p>
         * The resolved reason for a specific sync blocker.
         * </p>
         * 
         * @param resolvedReason
         *        The resolved reason for a specific sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedReason(String resolvedReason);

        /**
         * <p>
         * The time that a specific sync blocker was resolved.
         * </p>
         * 
         * @param resolvedAt
         *        The time that a specific sync blocker was resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedAt(Instant resolvedAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String status;

        private String createdReason;

        private Instant createdAt;

        private List<SyncBlockerContext> contexts = DefaultSdkAutoConstructList.getInstance();

        private String resolvedReason;

        private Instant resolvedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncBlocker model) {
            id(model.id);
            type(model.type);
            status(model.status);
            createdReason(model.createdReason);
            createdAt(model.createdAt);
            contexts(model.contexts);
            resolvedReason(model.resolvedReason);
            resolvedAt(model.resolvedAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlockerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BlockerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedReason() {
            return createdReason;
        }

        public final void setCreatedReason(String createdReason) {
            this.createdReason = createdReason;
        }

        @Override
        public final Builder createdReason(String createdReason) {
            this.createdReason = createdReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<SyncBlockerContext.Builder> getContexts() {
            List<SyncBlockerContext.Builder> result = SyncBlockerContextListCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<SyncBlockerContext.BuilderImpl> contexts) {
            this.contexts = SyncBlockerContextListCopier.copyFromBuilder(contexts);
        }

        @Override
        public final Builder contexts(Collection<SyncBlockerContext> contexts) {
            this.contexts = SyncBlockerContextListCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(SyncBlockerContext... contexts) {
            contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<SyncBlockerContext.Builder>... contexts) {
            contexts(Stream.of(contexts).map(c -> SyncBlockerContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResolvedReason() {
            return resolvedReason;
        }

        public final void setResolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
        }

        @Override
        public final Builder resolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
            return this;
        }

        public final Instant getResolvedAt() {
            return resolvedAt;
        }

        public final void setResolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
        }

        @Override
        public final Builder resolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
            return this;
        }

        @Override
        public SyncBlocker build() {
            return new SyncBlocker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
