/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSyncBlockerSummaryResponse extends CodeConnectionsResponse implements
        ToCopyableBuilder<GetSyncBlockerSummaryResponse.Builder, GetSyncBlockerSummaryResponse> {
    private static final SdkField<SyncBlockerSummary> SYNC_BLOCKER_SUMMARY_FIELD = SdkField
            .<SyncBlockerSummary> builder(MarshallingType.SDK_POJO).memberName("SyncBlockerSummary")
            .getter(getter(GetSyncBlockerSummaryResponse::syncBlockerSummary)).setter(setter(Builder::syncBlockerSummary))
            .constructor(SyncBlockerSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncBlockerSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_BLOCKER_SUMMARY_FIELD));

    private final SyncBlockerSummary syncBlockerSummary;

    private GetSyncBlockerSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.syncBlockerSummary = builder.syncBlockerSummary;
    }

    /**
     * <p>
     * The list of sync blockers for a specified resource.
     * </p>
     * 
     * @return The list of sync blockers for a specified resource.
     */
    public final SyncBlockerSummary syncBlockerSummary() {
        return syncBlockerSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(syncBlockerSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSyncBlockerSummaryResponse)) {
            return false;
        }
        GetSyncBlockerSummaryResponse other = (GetSyncBlockerSummaryResponse) obj;
        return Objects.equals(syncBlockerSummary(), other.syncBlockerSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSyncBlockerSummaryResponse").add("SyncBlockerSummary", syncBlockerSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncBlockerSummary":
            return Optional.ofNullable(clazz.cast(syncBlockerSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSyncBlockerSummaryResponse, T> g) {
        return obj -> g.apply((GetSyncBlockerSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeConnectionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSyncBlockerSummaryResponse> {
        /**
         * <p>
         * The list of sync blockers for a specified resource.
         * </p>
         * 
         * @param syncBlockerSummary
         *        The list of sync blockers for a specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncBlockerSummary(SyncBlockerSummary syncBlockerSummary);

        /**
         * <p>
         * The list of sync blockers for a specified resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncBlockerSummary.Builder} avoiding the
         * need to create one manually via {@link SyncBlockerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncBlockerSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #syncBlockerSummary(SyncBlockerSummary)}.
         * 
         * @param syncBlockerSummary
         *        a consumer that will call methods on {@link SyncBlockerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncBlockerSummary(SyncBlockerSummary)
         */
        default Builder syncBlockerSummary(Consumer<SyncBlockerSummary.Builder> syncBlockerSummary) {
            return syncBlockerSummary(SyncBlockerSummary.builder().applyMutation(syncBlockerSummary).build());
        }
    }

    static final class BuilderImpl extends CodeConnectionsResponse.BuilderImpl implements Builder {
        private SyncBlockerSummary syncBlockerSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSyncBlockerSummaryResponse model) {
            super(model);
            syncBlockerSummary(model.syncBlockerSummary);
        }

        public final SyncBlockerSummary.Builder getSyncBlockerSummary() {
            return syncBlockerSummary != null ? syncBlockerSummary.toBuilder() : null;
        }

        public final void setSyncBlockerSummary(SyncBlockerSummary.BuilderImpl syncBlockerSummary) {
            this.syncBlockerSummary = syncBlockerSummary != null ? syncBlockerSummary.build() : null;
        }

        @Override
        public final Builder syncBlockerSummary(SyncBlockerSummary syncBlockerSummary) {
            this.syncBlockerSummary = syncBlockerSummary;
            return this;
        }

        @Override
        public GetSyncBlockerSummaryResponse build() {
            return new GetSyncBlockerSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
