/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the revision for a specific sync event, such as the branch, owner ID, and name of the repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Revision implements SdkPojo, Serializable, ToCopyableBuilder<Revision.Builder, Revision> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(Revision::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Directory").getter(getter(Revision::directory)).setter(setter(Builder::directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directory").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(Revision::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(Revision::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(Revision::providerTypeAsString)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> SHA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sha")
            .getter(getter(Revision::sha)).setter(setter(Builder::sha))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sha").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, DIRECTORY_FIELD,
            OWNER_ID_FIELD, REPOSITORY_NAME_FIELD, PROVIDER_TYPE_FIELD, SHA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String branch;

    private final String directory;

    private final String ownerId;

    private final String repositoryName;

    private final String providerType;

    private final String sha;

    private Revision(BuilderImpl builder) {
        this.branch = builder.branch;
        this.directory = builder.directory;
        this.ownerId = builder.ownerId;
        this.repositoryName = builder.repositoryName;
        this.providerType = builder.providerType;
        this.sha = builder.sha;
    }

    /**
     * <p>
     * The branch name for a specific revision.
     * </p>
     * 
     * @return The branch name for a specific revision.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The directory, if any, for a specific revision.
     * </p>
     * 
     * @return The directory, if any, for a specific revision.
     */
    public final String directory() {
        return directory;
    }

    /**
     * <p>
     * The owner ID for a specific revision, such as the GitHub owner ID for a GitHub repository.
     * </p>
     * 
     * @return The owner ID for a specific revision, such as the GitHub owner ID for a GitHub repository.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The repository name for a specific revision.
     * </p>
     * 
     * @return The repository name for a specific revision.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The provider type for a revision, such as GitHub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type for a revision, such as GitHub.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The provider type for a revision, such as GitHub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type for a revision, such as GitHub.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The SHA, such as the commit ID, for a specific revision.
     * </p>
     * 
     * @return The SHA, such as the commit ID, for a specific revision.
     */
    public final String sha() {
        return sha;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(directory());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sha());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(directory(), other.directory())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(sha(), other.sha());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Revision").add("Branch", branch()).add("Directory", directory()).add("OwnerId", ownerId())
                .add("RepositoryName", repositoryName()).add("ProviderType", providerTypeAsString()).add("Sha", sha()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "Directory":
            return Optional.ofNullable(clazz.cast(directory()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "Sha":
            return Optional.ofNullable(clazz.cast(sha()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Revision, T> g) {
        return obj -> g.apply((Revision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Revision> {
        /**
         * <p>
         * The branch name for a specific revision.
         * </p>
         * 
         * @param branch
         *        The branch name for a specific revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The directory, if any, for a specific revision.
         * </p>
         * 
         * @param directory
         *        The directory, if any, for a specific revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directory(String directory);

        /**
         * <p>
         * The owner ID for a specific revision, such as the GitHub owner ID for a GitHub repository.
         * </p>
         * 
         * @param ownerId
         *        The owner ID for a specific revision, such as the GitHub owner ID for a GitHub repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The repository name for a specific revision.
         * </p>
         * 
         * @param repositoryName
         *        The repository name for a specific revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The provider type for a revision, such as GitHub.
         * </p>
         * 
         * @param providerType
         *        The provider type for a revision, such as GitHub.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The provider type for a revision, such as GitHub.
         * </p>
         * 
         * @param providerType
         *        The provider type for a revision, such as GitHub.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The SHA, such as the commit ID, for a specific revision.
         * </p>
         * 
         * @param sha
         *        The SHA, such as the commit ID, for a specific revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha(String sha);
    }

    static final class BuilderImpl implements Builder {
        private String branch;

        private String directory;

        private String ownerId;

        private String repositoryName;

        private String providerType;

        private String sha;

        private BuilderImpl() {
        }

        private BuilderImpl(Revision model) {
            branch(model.branch);
            directory(model.directory);
            ownerId(model.ownerId);
            repositoryName(model.repositoryName);
            providerType(model.providerType);
            sha(model.sha);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getDirectory() {
            return directory;
        }

        public final void setDirectory(String directory) {
            this.directory = directory;
        }

        @Override
        public final Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getSha() {
            return sha;
        }

        public final void setSha(String sha) {
            this.sha = sha;
        }

        @Override
        public final Builder sha(String sha) {
            this.sha = sha;
            return this;
        }

        @Override
        public Revision build() {
            return new Revision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
