/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the repository link resource, such as the repository link ARN, the associated connection ARN,
 * encryption key ARN, and owner ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryLinkInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryLinkInfo.Builder, RepositoryLinkInfo> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(RepositoryLinkInfo::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(RepositoryLinkInfo::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(RepositoryLinkInfo::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(RepositoryLinkInfo::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> REPOSITORY_LINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkArn").getter(getter(RepositoryLinkInfo::repositoryLinkArn))
            .setter(setter(Builder::repositoryLinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkArn").build()).build();

    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(RepositoryLinkInfo::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(RepositoryLinkInfo::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, OWNER_ID_FIELD, PROVIDER_TYPE_FIELD, REPOSITORY_LINK_ARN_FIELD, REPOSITORY_LINK_ID_FIELD,
            REPOSITORY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionArn;

    private final String encryptionKeyArn;

    private final String ownerId;

    private final String providerType;

    private final String repositoryLinkArn;

    private final String repositoryLinkId;

    private final String repositoryName;

    private RepositoryLinkInfo(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.ownerId = builder.ownerId;
        this.providerType = builder.providerType;
        this.repositoryLinkArn = builder.repositoryLinkArn;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.repositoryName = builder.repositoryName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection associated with the repository link.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection associated with the repository link.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository link.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository
     *         link.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.
     * </p>
     * 
     * @return The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The provider type for the connection, such as GitHub, associated with the repository link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type for the connection, such as GitHub, associated with the repository link.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The provider type for the connection, such as GitHub, associated with the repository link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type for the connection, such as GitHub, associated with the repository link.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the repository link.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the repository link.
     */
    public final String repositoryLinkArn() {
        return repositoryLinkArn;
    }

    /**
     * <p>
     * The ID of the repository link.
     * </p>
     * 
     * @return The ID of the repository link.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    /**
     * <p>
     * The name of the repository associated with the repository link.
     * </p>
     * 
     * @return The name of the repository associated with the repository link.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryLinkInfo)) {
            return false;
        }
        RepositoryLinkInfo other = (RepositoryLinkInfo) obj;
        return Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(repositoryLinkArn(), other.repositoryLinkArn())
                && Objects.equals(repositoryLinkId(), other.repositoryLinkId())
                && Objects.equals(repositoryName(), other.repositoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryLinkInfo").add("ConnectionArn", connectionArn())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("OwnerId", ownerId())
                .add("ProviderType", providerTypeAsString()).add("RepositoryLinkArn", repositoryLinkArn())
                .add("RepositoryLinkId", repositoryLinkId()).add("RepositoryName", repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "RepositoryLinkArn":
            return Optional.ofNullable(clazz.cast(repositoryLinkArn()));
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryLinkInfo, T> g) {
        return obj -> g.apply((RepositoryLinkInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryLinkInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection associated with the repository link.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the connection associated with the repository link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository link.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository
         *        link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.
         * </p>
         * 
         * @param ownerId
         *        The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The provider type for the connection, such as GitHub, associated with the repository link.
         * </p>
         * 
         * @param providerType
         *        The provider type for the connection, such as GitHub, associated with the repository link.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The provider type for the connection, such as GitHub, associated with the repository link.
         * </p>
         * 
         * @param providerType
         *        The provider type for the connection, such as GitHub, associated with the repository link.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the repository link.
         * </p>
         * 
         * @param repositoryLinkArn
         *        The Amazon Resource Name (ARN) of the repository link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkArn(String repositoryLinkArn);

        /**
         * <p>
         * The ID of the repository link.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        /**
         * <p>
         * The name of the repository associated with the repository link.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository associated with the repository link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);
    }

    static final class BuilderImpl implements Builder {
        private String connectionArn;

        private String encryptionKeyArn;

        private String ownerId;

        private String providerType;

        private String repositoryLinkArn;

        private String repositoryLinkId;

        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryLinkInfo model) {
            connectionArn(model.connectionArn);
            encryptionKeyArn(model.encryptionKeyArn);
            ownerId(model.ownerId);
            providerType(model.providerType);
            repositoryLinkArn(model.repositoryLinkArn);
            repositoryLinkId(model.repositoryLinkId);
            repositoryName(model.repositoryName);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getRepositoryLinkArn() {
            return repositoryLinkArn;
        }

        public final void setRepositoryLinkArn(String repositoryLinkArn) {
            this.repositoryLinkArn = repositoryLinkArn;
        }

        @Override
        public final Builder repositoryLinkArn(String repositoryLinkArn) {
            this.repositoryLinkArn = repositoryLinkArn;
            return this;
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        @Override
        public RepositoryLinkInfo build() {
            return new RepositoryLinkInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
