/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information, such as repository, branch, provider, and resource names for a specific sync configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SyncConfiguration.Builder, SyncConfiguration> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(SyncConfiguration::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> CONFIG_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigFile").getter(getter(SyncConfiguration::configFile)).setter(setter(Builder::configFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(SyncConfiguration::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(SyncConfiguration::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(SyncConfiguration::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(SyncConfiguration::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(SyncConfiguration::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(SyncConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncType").getter(getter(SyncConfiguration::syncTypeAsString)).setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final SdkField<String> PUBLISH_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishDeploymentStatus").getter(getter(SyncConfiguration::publishDeploymentStatusAsString))
            .setter(setter(Builder::publishDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishDeploymentStatus").build())
            .build();

    private static final SdkField<String> TRIGGER_RESOURCE_UPDATE_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerResourceUpdateOn").getter(getter(SyncConfiguration::triggerResourceUpdateOnAsString))
            .setter(setter(Builder::triggerResourceUpdateOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerResourceUpdateOn").build())
            .build();

    private static final SdkField<String> PULL_REQUEST_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PullRequestComment").getter(getter(SyncConfiguration::pullRequestCommentAsString))
            .setter(setter(Builder::pullRequestComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PullRequestComment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD,
            CONFIG_FILE_FIELD, OWNER_ID_FIELD, PROVIDER_TYPE_FIELD, REPOSITORY_LINK_ID_FIELD, REPOSITORY_NAME_FIELD,
            RESOURCE_NAME_FIELD, ROLE_ARN_FIELD, SYNC_TYPE_FIELD, PUBLISH_DEPLOYMENT_STATUS_FIELD,
            TRIGGER_RESOURCE_UPDATE_ON_FIELD, PULL_REQUEST_COMMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String branch;

    private final String configFile;

    private final String ownerId;

    private final String providerType;

    private final String repositoryLinkId;

    private final String repositoryName;

    private final String resourceName;

    private final String roleArn;

    private final String syncType;

    private final String publishDeploymentStatus;

    private final String triggerResourceUpdateOn;

    private final String pullRequestComment;

    private SyncConfiguration(BuilderImpl builder) {
        this.branch = builder.branch;
        this.configFile = builder.configFile;
        this.ownerId = builder.ownerId;
        this.providerType = builder.providerType;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.repositoryName = builder.repositoryName;
        this.resourceName = builder.resourceName;
        this.roleArn = builder.roleArn;
        this.syncType = builder.syncType;
        this.publishDeploymentStatus = builder.publishDeploymentStatus;
        this.triggerResourceUpdateOn = builder.triggerResourceUpdateOn;
        this.pullRequestComment = builder.pullRequestComment;
    }

    /**
     * <p>
     * The branch associated with a specific sync configuration.
     * </p>
     * 
     * @return The branch associated with a specific sync configuration.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The file path to the configuration file associated with a specific sync configuration. The path should point to
     * an actual file in the sync configurations linked repository.
     * </p>
     * 
     * @return The file path to the configuration file associated with a specific sync configuration. The path should
     *         point to an actual file in the sync configurations linked repository.
     */
    public final String configFile() {
        return configFile;
    }

    /**
     * <p>
     * The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.
     * </p>
     * 
     * @return The owner ID for the repository associated with a specific sync configuration, such as the owner ID in
     *         GitHub.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The connection provider type associated with a specific sync configuration, such as GitHub.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The connection provider type associated with a specific sync configuration, such as GitHub.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The ID of the repository link associated with a specific sync configuration.
     * </p>
     * 
     * @return The ID of the repository link associated with a specific sync configuration.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    /**
     * <p>
     * The name of the repository associated with a specific sync configuration.
     * </p>
     * 
     * @return The name of the repository associated with a specific sync configuration.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the connection resource associated with a specific sync configuration.
     * </p>
     * 
     * @return The name of the connection resource associated with a specific sync configuration.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The type of sync for a specific sync configuration.
     * @see SyncConfigurationType
     */
    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(syncType);
    }

    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The type of sync for a specific sync configuration.
     * @see SyncConfigurationType
     */
    public final String syncTypeAsString() {
        return syncType;
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publishDeploymentStatus} will return {@link PublishDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #publishDeploymentStatusAsString}.
     * </p>
     * 
     * @return Whether to enable or disable publishing of deployment status to source providers.
     * @see PublishDeploymentStatus
     */
    public final PublishDeploymentStatus publishDeploymentStatus() {
        return PublishDeploymentStatus.fromValue(publishDeploymentStatus);
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publishDeploymentStatus} will return {@link PublishDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #publishDeploymentStatusAsString}.
     * </p>
     * 
     * @return Whether to enable or disable publishing of deployment status to source providers.
     * @see PublishDeploymentStatus
     */
    public final String publishDeploymentStatusAsString() {
        return publishDeploymentStatus;
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #triggerResourceUpdateOn} will return {@link TriggerResourceUpdateOn#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #triggerResourceUpdateOnAsString}.
     * </p>
     * 
     * @return When to trigger Git sync to begin the stack update.
     * @see TriggerResourceUpdateOn
     */
    public final TriggerResourceUpdateOn triggerResourceUpdateOn() {
        return TriggerResourceUpdateOn.fromValue(triggerResourceUpdateOn);
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #triggerResourceUpdateOn} will return {@link TriggerResourceUpdateOn#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #triggerResourceUpdateOnAsString}.
     * </p>
     * 
     * @return When to trigger Git sync to begin the stack update.
     * @see TriggerResourceUpdateOn
     */
    public final String triggerResourceUpdateOnAsString() {
        return triggerResourceUpdateOn;
    }

    /**
     * <p>
     * A toggle that specifies whether to enable or disable pull request comments for the sync configuration to be
     * created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullRequestComment} will return {@link PullRequestComment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #pullRequestCommentAsString}.
     * </p>
     * 
     * @return A toggle that specifies whether to enable or disable pull request comments for the sync configuration to
     *         be created.
     * @see PullRequestComment
     */
    public final PullRequestComment pullRequestComment() {
        return PullRequestComment.fromValue(pullRequestComment);
    }

    /**
     * <p>
     * A toggle that specifies whether to enable or disable pull request comments for the sync configuration to be
     * created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullRequestComment} will return {@link PullRequestComment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #pullRequestCommentAsString}.
     * </p>
     * 
     * @return A toggle that specifies whether to enable or disable pull request comments for the sync configuration to
     *         be created.
     * @see PullRequestComment
     */
    public final String pullRequestCommentAsString() {
        return pullRequestComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(configFile());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(syncTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publishDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerResourceUpdateOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestCommentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncConfiguration)) {
            return false;
        }
        SyncConfiguration other = (SyncConfiguration) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(configFile(), other.configFile())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(repositoryLinkId(), other.repositoryLinkId())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(resourceName(), other.resourceName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(syncTypeAsString(), other.syncTypeAsString())
                && Objects.equals(publishDeploymentStatusAsString(), other.publishDeploymentStatusAsString())
                && Objects.equals(triggerResourceUpdateOnAsString(), other.triggerResourceUpdateOnAsString())
                && Objects.equals(pullRequestCommentAsString(), other.pullRequestCommentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncConfiguration").add("Branch", branch()).add("ConfigFile", configFile())
                .add("OwnerId", ownerId()).add("ProviderType", providerTypeAsString())
                .add("RepositoryLinkId", repositoryLinkId()).add("RepositoryName", repositoryName())
                .add("ResourceName", resourceName()).add("RoleArn", roleArn()).add("SyncType", syncTypeAsString())
                .add("PublishDeploymentStatus", publishDeploymentStatusAsString())
                .add("TriggerResourceUpdateOn", triggerResourceUpdateOnAsString())
                .add("PullRequestComment", pullRequestCommentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "ConfigFile":
            return Optional.ofNullable(clazz.cast(configFile()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncTypeAsString()));
        case "PublishDeploymentStatus":
            return Optional.ofNullable(clazz.cast(publishDeploymentStatusAsString()));
        case "TriggerResourceUpdateOn":
            return Optional.ofNullable(clazz.cast(triggerResourceUpdateOnAsString()));
        case "PullRequestComment":
            return Optional.ofNullable(clazz.cast(pullRequestCommentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncConfiguration, T> g) {
        return obj -> g.apply((SyncConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncConfiguration> {
        /**
         * <p>
         * The branch associated with a specific sync configuration.
         * </p>
         * 
         * @param branch
         *        The branch associated with a specific sync configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The file path to the configuration file associated with a specific sync configuration. The path should point
         * to an actual file in the sync configurations linked repository.
         * </p>
         * 
         * @param configFile
         *        The file path to the configuration file associated with a specific sync configuration. The path should
         *        point to an actual file in the sync configurations linked repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configFile(String configFile);

        /**
         * <p>
         * The owner ID for the repository associated with a specific sync configuration, such as the owner ID in
         * GitHub.
         * </p>
         * 
         * @param ownerId
         *        The owner ID for the repository associated with a specific sync configuration, such as the owner ID in
         *        GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The connection provider type associated with a specific sync configuration, such as GitHub.
         * </p>
         * 
         * @param providerType
         *        The connection provider type associated with a specific sync configuration, such as GitHub.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The connection provider type associated with a specific sync configuration, such as GitHub.
         * </p>
         * 
         * @param providerType
         *        The connection provider type associated with a specific sync configuration, such as GitHub.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The ID of the repository link associated with a specific sync configuration.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link associated with a specific sync configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        /**
         * <p>
         * The name of the repository associated with a specific sync configuration.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository associated with a specific sync configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the connection resource associated with a specific sync configuration.
         * </p>
         * 
         * @param resourceName
         *        The name of the connection resource associated with a specific sync configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The type of sync for a specific sync configuration.
         * </p>
         * 
         * @param syncType
         *        The type of sync for a specific sync configuration.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * The type of sync for a specific sync configuration.
         * </p>
         * 
         * @param syncType
         *        The type of sync for a specific sync configuration.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(SyncConfigurationType syncType);

        /**
         * <p>
         * Whether to enable or disable publishing of deployment status to source providers.
         * </p>
         * 
         * @param publishDeploymentStatus
         *        Whether to enable or disable publishing of deployment status to source providers.
         * @see PublishDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishDeploymentStatus
         */
        Builder publishDeploymentStatus(String publishDeploymentStatus);

        /**
         * <p>
         * Whether to enable or disable publishing of deployment status to source providers.
         * </p>
         * 
         * @param publishDeploymentStatus
         *        Whether to enable or disable publishing of deployment status to source providers.
         * @see PublishDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishDeploymentStatus
         */
        Builder publishDeploymentStatus(PublishDeploymentStatus publishDeploymentStatus);

        /**
         * <p>
         * When to trigger Git sync to begin the stack update.
         * </p>
         * 
         * @param triggerResourceUpdateOn
         *        When to trigger Git sync to begin the stack update.
         * @see TriggerResourceUpdateOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerResourceUpdateOn
         */
        Builder triggerResourceUpdateOn(String triggerResourceUpdateOn);

        /**
         * <p>
         * When to trigger Git sync to begin the stack update.
         * </p>
         * 
         * @param triggerResourceUpdateOn
         *        When to trigger Git sync to begin the stack update.
         * @see TriggerResourceUpdateOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerResourceUpdateOn
         */
        Builder triggerResourceUpdateOn(TriggerResourceUpdateOn triggerResourceUpdateOn);

        /**
         * <p>
         * A toggle that specifies whether to enable or disable pull request comments for the sync configuration to be
         * created.
         * </p>
         * 
         * @param pullRequestComment
         *        A toggle that specifies whether to enable or disable pull request comments for the sync configuration
         *        to be created.
         * @see PullRequestComment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestComment
         */
        Builder pullRequestComment(String pullRequestComment);

        /**
         * <p>
         * A toggle that specifies whether to enable or disable pull request comments for the sync configuration to be
         * created.
         * </p>
         * 
         * @param pullRequestComment
         *        A toggle that specifies whether to enable or disable pull request comments for the sync configuration
         *        to be created.
         * @see PullRequestComment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestComment
         */
        Builder pullRequestComment(PullRequestComment pullRequestComment);
    }

    static final class BuilderImpl implements Builder {
        private String branch;

        private String configFile;

        private String ownerId;

        private String providerType;

        private String repositoryLinkId;

        private String repositoryName;

        private String resourceName;

        private String roleArn;

        private String syncType;

        private String publishDeploymentStatus;

        private String triggerResourceUpdateOn;

        private String pullRequestComment;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncConfiguration model) {
            branch(model.branch);
            configFile(model.configFile);
            ownerId(model.ownerId);
            providerType(model.providerType);
            repositoryLinkId(model.repositoryLinkId);
            repositoryName(model.repositoryName);
            resourceName(model.resourceName);
            roleArn(model.roleArn);
            syncType(model.syncType);
            publishDeploymentStatus(model.publishDeploymentStatus);
            triggerResourceUpdateOn(model.triggerResourceUpdateOn);
            pullRequestComment(model.pullRequestComment);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getConfigFile() {
            return configFile;
        }

        public final void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        @Override
        public final Builder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        public final String getPublishDeploymentStatus() {
            return publishDeploymentStatus;
        }

        public final void setPublishDeploymentStatus(String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
        }

        @Override
        public final Builder publishDeploymentStatus(String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
            return this;
        }

        @Override
        public final Builder publishDeploymentStatus(PublishDeploymentStatus publishDeploymentStatus) {
            this.publishDeploymentStatus(publishDeploymentStatus == null ? null : publishDeploymentStatus.toString());
            return this;
        }

        public final String getTriggerResourceUpdateOn() {
            return triggerResourceUpdateOn;
        }

        public final void setTriggerResourceUpdateOn(String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
        }

        @Override
        public final Builder triggerResourceUpdateOn(String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
            return this;
        }

        @Override
        public final Builder triggerResourceUpdateOn(TriggerResourceUpdateOn triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn(triggerResourceUpdateOn == null ? null : triggerResourceUpdateOn.toString());
            return this;
        }

        public final String getPullRequestComment() {
            return pullRequestComment;
        }

        public final void setPullRequestComment(String pullRequestComment) {
            this.pullRequestComment = pullRequestComment;
        }

        @Override
        public final Builder pullRequestComment(String pullRequestComment) {
            this.pullRequestComment = pullRequestComment;
            return this;
        }

        @Override
        public final Builder pullRequestComment(PullRequestComment pullRequestComment) {
            this.pullRequestComment(pullRequestComment == null ? null : pullRequestComment.toString());
            return this;
        }

        @Override
        public SyncConfiguration build() {
            return new SyncConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
