/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRepositoryLinkResponse extends CodeConnectionsResponse implements
        ToCopyableBuilder<UpdateRepositoryLinkResponse.Builder, UpdateRepositoryLinkResponse> {
    private static final SdkField<RepositoryLinkInfo> REPOSITORY_LINK_INFO_FIELD = SdkField
            .<RepositoryLinkInfo> builder(MarshallingType.SDK_POJO).memberName("RepositoryLinkInfo")
            .getter(getter(UpdateRepositoryLinkResponse::repositoryLinkInfo)).setter(setter(Builder::repositoryLinkInfo))
            .constructor(RepositoryLinkInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_LINK_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RepositoryLinkInfo repositoryLinkInfo;

    private UpdateRepositoryLinkResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryLinkInfo = builder.repositoryLinkInfo;
    }

    /**
     * <p>
     * Information about the repository link to be updated.
     * </p>
     * 
     * @return Information about the repository link to be updated.
     */
    public final RepositoryLinkInfo repositoryLinkInfo() {
        return repositoryLinkInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryLinkResponse)) {
            return false;
        }
        UpdateRepositoryLinkResponse other = (UpdateRepositoryLinkResponse) obj;
        return Objects.equals(repositoryLinkInfo(), other.repositoryLinkInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRepositoryLinkResponse").add("RepositoryLinkInfo", repositoryLinkInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryLinkInfo":
            return Optional.ofNullable(clazz.cast(repositoryLinkInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RepositoryLinkInfo", REPOSITORY_LINK_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryLinkResponse, T> g) {
        return obj -> g.apply((UpdateRepositoryLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeConnectionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRepositoryLinkResponse> {
        /**
         * <p>
         * Information about the repository link to be updated.
         * </p>
         * 
         * @param repositoryLinkInfo
         *        Information about the repository link to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkInfo(RepositoryLinkInfo repositoryLinkInfo);

        /**
         * <p>
         * Information about the repository link to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryLinkInfo.Builder} avoiding the
         * need to create one manually via {@link RepositoryLinkInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryLinkInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #repositoryLinkInfo(RepositoryLinkInfo)}.
         * 
         * @param repositoryLinkInfo
         *        a consumer that will call methods on {@link RepositoryLinkInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryLinkInfo(RepositoryLinkInfo)
         */
        default Builder repositoryLinkInfo(Consumer<RepositoryLinkInfo.Builder> repositoryLinkInfo) {
            return repositoryLinkInfo(RepositoryLinkInfo.builder().applyMutation(repositoryLinkInfo).build());
        }
    }

    static final class BuilderImpl extends CodeConnectionsResponse.BuilderImpl implements Builder {
        private RepositoryLinkInfo repositoryLinkInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryLinkResponse model) {
            super(model);
            repositoryLinkInfo(model.repositoryLinkInfo);
        }

        public final RepositoryLinkInfo.Builder getRepositoryLinkInfo() {
            return repositoryLinkInfo != null ? repositoryLinkInfo.toBuilder() : null;
        }

        public final void setRepositoryLinkInfo(RepositoryLinkInfo.BuilderImpl repositoryLinkInfo) {
            this.repositoryLinkInfo = repositoryLinkInfo != null ? repositoryLinkInfo.build() : null;
        }

        @Override
        public final Builder repositoryLinkInfo(RepositoryLinkInfo repositoryLinkInfo) {
            this.repositoryLinkInfo = repositoryLinkInfo;
            return this;
        }

        @Override
        public UpdateRepositoryLinkResponse build() {
            return new UpdateRepositoryLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
