/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostResponse extends CodeConnectionsResponse implements
        ToCopyableBuilder<GetHostResponse.Builder, GetHostResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetHostResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetHostResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(GetHostResponse::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> PROVIDER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderEndpoint").getter(getter(GetHostResponse::providerEndpoint))
            .setter(setter(Builder::providerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderEndpoint").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(GetHostResponse::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            PROVIDER_TYPE_FIELD, PROVIDER_ENDPOINT_FIELD, VPC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String status;

    private final String providerType;

    private final String providerEndpoint;

    private final VpcConfiguration vpcConfiguration;

    private GetHostResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.status = builder.status;
        this.providerType = builder.providerType;
        this.providerEndpoint = builder.providerEndpoint;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The name of the requested host.
     * </p>
     * 
     * @return The name of the requested host.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the requested host.
     * </p>
     * 
     * @return The status of the requested host.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The provider type of the requested host, such as GitHub Enterprise Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type of the requested host, such as GitHub Enterprise Server.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The provider type of the requested host, such as GitHub Enterprise Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type of the requested host, such as GitHub Enterprise Server.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The endpoint of the infrastructure represented by the requested host.
     * </p>
     * 
     * @return The endpoint of the infrastructure represented by the requested host.
     */
    public final String providerEndpoint() {
        return providerEndpoint;
    }

    /**
     * <p>
     * The VPC configuration of the requested host.
     * </p>
     * 
     * @return The VPC configuration of the requested host.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(providerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostResponse)) {
            return false;
        }
        GetHostResponse other = (GetHostResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(providerEndpoint(), other.providerEndpoint())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHostResponse").add("Name", name()).add("Status", status())
                .add("ProviderType", providerTypeAsString()).add("ProviderEndpoint", providerEndpoint())
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "ProviderEndpoint":
            return Optional.ofNullable(clazz.cast(providerEndpoint()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("ProviderEndpoint", PROVIDER_ENDPOINT_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHostResponse, T> g) {
        return obj -> g.apply((GetHostResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeConnectionsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetHostResponse> {
        /**
         * <p>
         * The name of the requested host.
         * </p>
         * 
         * @param name
         *        The name of the requested host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the requested host.
         * </p>
         * 
         * @param status
         *        The status of the requested host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The provider type of the requested host, such as GitHub Enterprise Server.
         * </p>
         * 
         * @param providerType
         *        The provider type of the requested host, such as GitHub Enterprise Server.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The provider type of the requested host, such as GitHub Enterprise Server.
         * </p>
         * 
         * @param providerType
         *        The provider type of the requested host, such as GitHub Enterprise Server.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The endpoint of the infrastructure represented by the requested host.
         * </p>
         * 
         * @param providerEndpoint
         *        The endpoint of the infrastructure represented by the requested host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerEndpoint(String providerEndpoint);

        /**
         * <p>
         * The VPC configuration of the requested host.
         * </p>
         * 
         * @param vpcConfiguration
         *        The VPC configuration of the requested host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The VPC configuration of the requested host.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl extends CodeConnectionsResponse.BuilderImpl implements Builder {
        private String name;

        private String status;

        private String providerType;

        private String providerEndpoint;

        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostResponse model) {
            super(model);
            name(model.name);
            status(model.status);
            providerType(model.providerType);
            providerEndpoint(model.providerEndpoint);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getProviderEndpoint() {
            return providerEndpoint;
        }

        public final void setProviderEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
        }

        @Override
        public final Builder providerEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public GetHostResponse build() {
            return new GetHostResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
