/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSyncBlockerRequest extends CodeConnectionsRequest implements
        ToCopyableBuilder<UpdateSyncBlockerRequest.Builder, UpdateSyncBlockerRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateSyncBlockerRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncType").getter(getter(UpdateSyncBlockerRequest::syncTypeAsString)).setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(UpdateSyncBlockerRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> RESOLVED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolvedReason").getter(getter(UpdateSyncBlockerRequest::resolvedReason))
            .setter(setter(Builder::resolvedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SYNC_TYPE_FIELD,
            RESOURCE_NAME_FIELD, RESOLVED_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String syncType;

    private final String resourceName;

    private final String resolvedReason;

    private UpdateSyncBlockerRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.syncType = builder.syncType;
        this.resourceName = builder.resourceName;
        this.resolvedReason = builder.resolvedReason;
    }

    /**
     * <p>
     * The ID of the sync blocker to be updated.
     * </p>
     * 
     * @return The ID of the sync blocker to be updated.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The sync type of the sync blocker to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type of the sync blocker to be updated.
     * @see SyncConfigurationType
     */
    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(syncType);
    }

    /**
     * <p>
     * The sync type of the sync blocker to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type of the sync blocker to be updated.
     * @see SyncConfigurationType
     */
    public final String syncTypeAsString() {
        return syncType;
    }

    /**
     * <p>
     * The name of the resource for the sync blocker to be updated.
     * </p>
     * 
     * @return The name of the resource for the sync blocker to be updated.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The reason for resolving the sync blocker.
     * </p>
     * 
     * @return The reason for resolving the sync blocker.
     */
    public final String resolvedReason() {
        return resolvedReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(syncTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSyncBlockerRequest)) {
            return false;
        }
        UpdateSyncBlockerRequest other = (UpdateSyncBlockerRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(syncTypeAsString(), other.syncTypeAsString())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resolvedReason(), other.resolvedReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSyncBlockerRequest").add("Id", id()).add("SyncType", syncTypeAsString())
                .add("ResourceName", resourceName()).add("ResolvedReason", resolvedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncTypeAsString()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ResolvedReason":
            return Optional.ofNullable(clazz.cast(resolvedReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ResolvedReason", RESOLVED_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSyncBlockerRequest, T> g) {
        return obj -> g.apply((UpdateSyncBlockerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeConnectionsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSyncBlockerRequest> {
        /**
         * <p>
         * The ID of the sync blocker to be updated.
         * </p>
         * 
         * @param id
         *        The ID of the sync blocker to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The sync type of the sync blocker to be updated.
         * </p>
         * 
         * @param syncType
         *        The sync type of the sync blocker to be updated.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * The sync type of the sync blocker to be updated.
         * </p>
         * 
         * @param syncType
         *        The sync type of the sync blocker to be updated.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(SyncConfigurationType syncType);

        /**
         * <p>
         * The name of the resource for the sync blocker to be updated.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource for the sync blocker to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The reason for resolving the sync blocker.
         * </p>
         * 
         * @param resolvedReason
         *        The reason for resolving the sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedReason(String resolvedReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeConnectionsRequest.BuilderImpl implements Builder {
        private String id;

        private String syncType;

        private String resourceName;

        private String resolvedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSyncBlockerRequest model) {
            super(model);
            id(model.id);
            syncType(model.syncType);
            resourceName(model.resourceName);
            resolvedReason(model.resolvedReason);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResolvedReason() {
            return resolvedReason;
        }

        public final void setResolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
        }

        @Override
        public final Builder resolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSyncBlockerRequest build() {
            return new UpdateSyncBlockerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
