/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.codeconnections.auth.scheme.CodeConnectionsAuthSchemeParams;
import software.amazon.awssdk.services.codeconnections.auth.scheme.CodeConnectionsAuthSchemeProvider;
import software.amazon.awssdk.utils.CollectionUtils;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class PreferredCodeConnectionsAuthSchemeProvider implements CodeConnectionsAuthSchemeProvider {
    private final CodeConnectionsAuthSchemeProvider delegate;

    private final List<String> authSchemePreference;

    public PreferredCodeConnectionsAuthSchemeProvider(CodeConnectionsAuthSchemeProvider delegate,
            List<String> authSchemePreference) {
        this.delegate = delegate;
        this.authSchemePreference = authSchemePreference != null ? authSchemePreference : Collections.emptyList();
    }

    /**
     * Resolve the auth schemes based on the given set of parameters.
     */
    @Override
    public List<AuthSchemeOption> resolveAuthScheme(CodeConnectionsAuthSchemeParams params) {
        List<AuthSchemeOption> candidateAuthSchemes = delegate.resolveAuthScheme(params);
        if (CollectionUtils.isNullOrEmpty(authSchemePreference)) {
            return candidateAuthSchemes;
        }
        List<AuthSchemeOption> authSchemes = new ArrayList<>();
        authSchemePreference.forEach(preferredSchemeId -> {
            candidateAuthSchemes
                    .stream()
                    .filter(candidate -> {
                        String candidateSchemeName = candidate.schemeId().contains("#") ? candidate.schemeId().split("#")[1]
                                : candidate.schemeId();
                        return candidateSchemeName.equals(preferredSchemeId);
                    }).findFirst().ifPresent(authSchemes::add);
        });
        candidateAuthSchemes.forEach(candidate -> {
            if (!authSchemes.contains(candidate)) {
                authSchemes.add(candidate);
            }
        });
        return authSchemes;
    }
}
