/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositorySyncDefinitionsRequest extends CodeConnectionsRequest implements
        ToCopyableBuilder<ListRepositorySyncDefinitionsRequest.Builder, ListRepositorySyncDefinitionsRequest> {
    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(ListRepositorySyncDefinitionsRequest::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncType").getter(getter(ListRepositorySyncDefinitionsRequest::syncTypeAsString))
            .setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_LINK_ID_FIELD,
            SYNC_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryLinkId;

    private final String syncType;

    private ListRepositorySyncDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryLinkId = builder.repositoryLinkId;
        this.syncType = builder.syncType;
    }

    /**
     * <p>
     * The ID of the repository link for the sync definition for which you want to retrieve information.
     * </p>
     * 
     * @return The ID of the repository link for the sync definition for which you want to retrieve information.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    /**
     * <p>
     * The sync type of the repository link for the the sync definition for which you want to retrieve information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type of the repository link for the the sync definition for which you want to retrieve
     *         information.
     * @see SyncConfigurationType
     */
    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(syncType);
    }

    /**
     * <p>
     * The sync type of the repository link for the the sync definition for which you want to retrieve information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type of the repository link for the the sync definition for which you want to retrieve
     *         information.
     * @see SyncConfigurationType
     */
    public final String syncTypeAsString() {
        return syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(syncTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositorySyncDefinitionsRequest)) {
            return false;
        }
        ListRepositorySyncDefinitionsRequest other = (ListRepositorySyncDefinitionsRequest) obj;
        return Objects.equals(repositoryLinkId(), other.repositoryLinkId())
                && Objects.equals(syncTypeAsString(), other.syncTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositorySyncDefinitionsRequest").add("RepositoryLinkId", repositoryLinkId())
                .add("SyncType", syncTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRepositorySyncDefinitionsRequest, T> g) {
        return obj -> g.apply((ListRepositorySyncDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositorySyncDefinitionsRequest> {
        /**
         * <p>
         * The ID of the repository link for the sync definition for which you want to retrieve information.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link for the sync definition for which you want to retrieve information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        /**
         * <p>
         * The sync type of the repository link for the the sync definition for which you want to retrieve information.
         * </p>
         * 
         * @param syncType
         *        The sync type of the repository link for the the sync definition for which you want to retrieve
         *        information.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * The sync type of the repository link for the the sync definition for which you want to retrieve information.
         * </p>
         * 
         * @param syncType
         *        The sync type of the repository link for the the sync definition for which you want to retrieve
         *        information.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(SyncConfigurationType syncType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeConnectionsRequest.BuilderImpl implements Builder {
        private String repositoryLinkId;

        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositorySyncDefinitionsRequest model) {
            super(model);
            repositoryLinkId(model.repositoryLinkId);
            syncType(model.syncType);
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositorySyncDefinitionsRequest build() {
            return new ListRepositorySyncDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
