/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsAsyncClient;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsServiceClientConfiguration;
import software.amazon.awssdk.services.codeconnections.internal.CodeConnectionsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codeconnections.model.AccessDeniedException;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsException;
import software.amazon.awssdk.services.codeconnections.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codeconnections.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.codeconnections.model.ConflictException;
import software.amazon.awssdk.services.codeconnections.model.CreateConnectionRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateConnectionResponse;
import software.amazon.awssdk.services.codeconnections.model.CreateHostRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateHostResponse;
import software.amazon.awssdk.services.codeconnections.model.CreateRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.CreateSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteHostRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteHostResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.model.GetConnectionRequest;
import software.amazon.awssdk.services.codeconnections.model.GetConnectionResponse;
import software.amazon.awssdk.services.codeconnections.model.GetHostRequest;
import software.amazon.awssdk.services.codeconnections.model.GetHostResponse;
import software.amazon.awssdk.services.codeconnections.model.GetRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.GetRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.GetRepositorySyncStatusRequest;
import software.amazon.awssdk.services.codeconnections.model.GetRepositorySyncStatusResponse;
import software.amazon.awssdk.services.codeconnections.model.GetResourceSyncStatusRequest;
import software.amazon.awssdk.services.codeconnections.model.GetResourceSyncStatusResponse;
import software.amazon.awssdk.services.codeconnections.model.GetSyncBlockerSummaryRequest;
import software.amazon.awssdk.services.codeconnections.model.GetSyncBlockerSummaryResponse;
import software.amazon.awssdk.services.codeconnections.model.GetSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.GetSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.model.InternalServerException;
import software.amazon.awssdk.services.codeconnections.model.InvalidInputException;
import software.amazon.awssdk.services.codeconnections.model.LimitExceededException;
import software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListConnectionsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListHostsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListHostsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest;
import software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksResponse;
import software.amazon.awssdk.services.codeconnections.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codeconnections.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codeconnections.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codeconnections.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeconnections.model.ResourceUnavailableException;
import software.amazon.awssdk.services.codeconnections.model.RetryLatestCommitFailedException;
import software.amazon.awssdk.services.codeconnections.model.SyncBlockerDoesNotExistException;
import software.amazon.awssdk.services.codeconnections.model.SyncConfigurationStillExistsException;
import software.amazon.awssdk.services.codeconnections.model.TagResourceRequest;
import software.amazon.awssdk.services.codeconnections.model.TagResourceResponse;
import software.amazon.awssdk.services.codeconnections.model.ThrottlingException;
import software.amazon.awssdk.services.codeconnections.model.UnsupportedOperationException;
import software.amazon.awssdk.services.codeconnections.model.UnsupportedProviderTypeException;
import software.amazon.awssdk.services.codeconnections.model.UntagResourceRequest;
import software.amazon.awssdk.services.codeconnections.model.UntagResourceResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateHostRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateHostResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateOutOfSyncException;
import software.amazon.awssdk.services.codeconnections.model.UpdateRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncBlockerRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncBlockerResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.CreateHostRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.CreateRepositoryLinkRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.CreateSyncConfigurationRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.DeleteHostRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.DeleteRepositoryLinkRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.DeleteSyncConfigurationRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetConnectionRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetHostRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetRepositoryLinkRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetRepositorySyncStatusRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetResourceSyncStatusRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetSyncBlockerSummaryRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.GetSyncConfigurationRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.ListConnectionsRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.ListHostsRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.ListRepositoryLinksRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.ListRepositorySyncDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.ListSyncConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.UpdateHostRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.UpdateRepositoryLinkRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.UpdateSyncBlockerRequestMarshaller;
import software.amazon.awssdk.services.codeconnections.transform.UpdateSyncConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCodeConnectionsAsyncClient
implements CodeConnectionsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeConnectionsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeConnectionsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CodeConnections#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, createConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createConnectionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$createConnection$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$createConnection$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHostResponse> createHost(CreateHostRequest createHostRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHostRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, createHostRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHost");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHostResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHost").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateHostRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createHostRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$createHost$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$createHost$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRepositoryLinkResponse> createRepositoryLink(CreateRepositoryLinkRequest createRepositoryLinkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRepositoryLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, createRepositoryLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepositoryLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryLinkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepositoryLink").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRepositoryLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRepositoryLinkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$createRepositoryLink$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$createRepositoryLink$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSyncConfigurationResponse> createSyncConfiguration(CreateSyncConfigurationRequest createSyncConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSyncConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, createSyncConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSyncConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSyncConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSyncConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSyncConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSyncConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$createSyncConfiguration$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$createSyncConfiguration$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConnectionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$deleteConnection$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$deleteConnection$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHostResponse> deleteHost(DeleteHostRequest deleteHostRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteHostRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteHostRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHost");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHostResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHost").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteHostRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteHostRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$deleteHost$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$deleteHost$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRepositoryLinkResponse> deleteRepositoryLink(DeleteRepositoryLinkRequest deleteRepositoryLinkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRepositoryLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRepositoryLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepositoryLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryLinkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepositoryLink").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRepositoryLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRepositoryLinkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$deleteRepositoryLink$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$deleteRepositoryLink$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSyncConfigurationResponse> deleteSyncConfiguration(DeleteSyncConfigurationRequest deleteSyncConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSyncConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSyncConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSyncConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSyncConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSyncConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSyncConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSyncConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$deleteSyncConfiguration$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$deleteSyncConfiguration$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getConnectionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getConnection$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getConnection$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostResponse> getHost(GetHostRequest getHostRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getHostRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getHostRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHost");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHostResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHost").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetHostRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getHostRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getHost$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getHost$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryLinkResponse> getRepositoryLink(GetRepositoryLinkRequest getRepositoryLinkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRepositoryLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getRepositoryLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryLinkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryLink").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRepositoryLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryLinkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getRepositoryLink$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getRepositoryLink$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositorySyncStatusResponse> getRepositorySyncStatus(GetRepositorySyncStatusRequest getRepositorySyncStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRepositorySyncStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getRepositorySyncStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositorySyncStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositorySyncStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositorySyncStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRepositorySyncStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositorySyncStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getRepositorySyncStatus$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getRepositorySyncStatus$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceSyncStatusResponse> getResourceSyncStatus(GetResourceSyncStatusRequest getResourceSyncStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceSyncStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceSyncStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceSyncStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceSyncStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceSyncStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceSyncStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceSyncStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getResourceSyncStatus$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getResourceSyncStatus$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSyncBlockerSummaryResponse> getSyncBlockerSummary(GetSyncBlockerSummaryRequest getSyncBlockerSummaryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSyncBlockerSummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getSyncBlockerSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSyncBlockerSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSyncBlockerSummaryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSyncBlockerSummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSyncBlockerSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSyncBlockerSummaryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getSyncBlockerSummary$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getSyncBlockerSummary$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSyncConfigurationResponse> getSyncConfiguration(GetSyncConfigurationRequest getSyncConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSyncConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, getSyncConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSyncConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSyncConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSyncConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSyncConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSyncConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$getSyncConfiguration$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$getSyncConfiguration$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListConnectionsResponse> listConnections(ListConnectionsRequest listConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, listConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listConnectionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$listConnections$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$listConnections$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListHostsResponse> listHosts(ListHostsRequest listHostsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listHostsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, listHostsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHosts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHostsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHosts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListHostsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listHostsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$listHosts$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$listHosts$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRepositoryLinksResponse> listRepositoryLinks(ListRepositoryLinksRequest listRepositoryLinksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRepositoryLinksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, listRepositoryLinksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositoryLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoryLinksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositoryLinks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRepositoryLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRepositoryLinksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$listRepositoryLinks$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$listRepositoryLinks$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRepositorySyncDefinitionsResponse> listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRepositorySyncDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, listRepositorySyncDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositorySyncDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositorySyncDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositorySyncDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRepositorySyncDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRepositorySyncDefinitionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$listRepositorySyncDefinitions$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$listRepositorySyncDefinitions$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSyncConfigurationsResponse> listSyncConfigurations(ListSyncConfigurationsRequest listSyncConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSyncConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, listSyncConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSyncConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSyncConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSyncConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSyncConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSyncConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$listSyncConfigurations$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$listSyncConfigurations$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$listTagsForResource$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$listTagsForResource$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$tagResource$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$tagResource$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$untagResource$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$untagResource$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateHostResponse> updateHost(UpdateHostRequest updateHostRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateHostRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, updateHostRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHost");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHostResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHost").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateHostRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateHostRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$updateHost$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$updateHost$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRepositoryLinkResponse> updateRepositoryLink(UpdateRepositoryLinkRequest updateRepositoryLinkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRepositoryLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, updateRepositoryLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRepositoryLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRepositoryLinkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRepositoryLink").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRepositoryLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRepositoryLinkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$updateRepositoryLink$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$updateRepositoryLink$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSyncBlockerResponse> updateSyncBlocker(UpdateSyncBlockerRequest updateSyncBlockerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSyncBlockerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, updateSyncBlockerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSyncBlocker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSyncBlockerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSyncBlocker").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSyncBlockerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSyncBlockerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$updateSyncBlocker$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$updateSyncBlocker$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSyncConfigurationResponse> updateSyncConfiguration(UpdateSyncConfigurationRequest updateSyncConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSyncConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeConnectionsAsyncClient.resolveMetricPublishers(clientConfiguration, updateSyncConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeConnections");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSyncConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSyncConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "SyncBlockerDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncBlockerDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncBlockerDoesNotExistException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "UnsupportedProviderTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedProviderTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedProviderTypeException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "SyncConfigurationStillExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SyncConfigurationStillExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SyncConfigurationStillExistsException::builder).build());
                    }
                    case "UpdateOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateOutOfSyncException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateOutOfSyncException::builder).build());
                    }
                    case "RetryLatestCommitFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RetryLatestCommitFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RetryLatestCommitFailedException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSyncConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSyncConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSyncConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeConnectionsAsyncClient.lambda$updateSyncConfiguration$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeConnectionsAsyncClient.lambda$updateSyncConfiguration$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CodeConnectionsServiceClientConfiguration serviceClientConfiguration() {
        return new CodeConnectionsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "codeconnections";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeConnectionsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CodeConnectionsServiceClientConfigurationBuilder serviceConfigBuilder = new CodeConnectionsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSyncConfiguration$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSyncConfiguration$106(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSyncConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSyncBlocker$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSyncBlocker$102(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSyncBlockerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRepositoryLink$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRepositoryLink$98(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRepositoryLinkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateHost$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHost$94(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateHostResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$90(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$86(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSyncConfigurations$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSyncConfigurations$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListSyncConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRepositorySyncDefinitions$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositorySyncDefinitions$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListRepositorySyncDefinitionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRepositoryLinks$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositoryLinks$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListRepositoryLinksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listHosts$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHosts$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListHostsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listConnections$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnections$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListConnectionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSyncConfiguration$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSyncConfiguration$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetSyncConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSyncBlockerSummary$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSyncBlockerSummary$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetSyncBlockerSummaryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceSyncStatus$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceSyncStatus$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceSyncStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositorySyncStatus$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositorySyncStatus$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositorySyncStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositoryLink$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryLink$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryLinkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHost$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHost$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetHostResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getConnection$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnection$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSyncConfiguration$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSyncConfiguration$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSyncConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRepositoryLink$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepositoryLink$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRepositoryLinkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteHost$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHost$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteHostResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteConnection$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnection$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSyncConfiguration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSyncConfiguration$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSyncConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRepositoryLink$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRepositoryLink$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRepositoryLinkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHost$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHost$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHostResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createConnection$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnection$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

