/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration that shifts traffic from one version of a Lambda function to another in equal increments, with an
 * equal number of minutes between each increment. The original and target Lambda function versions are specified in the
 * deployment's AppSpec file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeBasedLinear implements SdkPojo, Serializable, ToCopyableBuilder<TimeBasedLinear.Builder, TimeBasedLinear> {
    private static final SdkField<Integer> LINEAR_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TimeBasedLinear::linearPercentage)).setter(setter(Builder::linearPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linearPercentage").build()).build();

    private static final SdkField<Integer> LINEAR_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TimeBasedLinear::linearInterval)).setter(setter(Builder::linearInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linearInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAR_PERCENTAGE_FIELD,
            LINEAR_INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer linearPercentage;

    private final Integer linearInterval;

    private TimeBasedLinear(BuilderImpl builder) {
        this.linearPercentage = builder.linearPercentage;
        this.linearInterval = builder.linearInterval;
    }

    /**
     * <p>
     * The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code>
     * deployment.
     * </p>
     * 
     * @return The percentage of traffic that is shifted at the start of each increment of a
     *         <code>TimeBasedLinear</code> deployment.
     */
    public Integer linearPercentage() {
        return linearPercentage;
    }

    /**
     * <p>
     * The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.
     * </p>
     * 
     * @return The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code>
     *         deployment.
     */
    public Integer linearInterval() {
        return linearInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(linearPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(linearInterval());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedLinear)) {
            return false;
        }
        TimeBasedLinear other = (TimeBasedLinear) obj;
        return Objects.equals(linearPercentage(), other.linearPercentage())
                && Objects.equals(linearInterval(), other.linearInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TimeBasedLinear").add("LinearPercentage", linearPercentage())
                .add("LinearInterval", linearInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "linearPercentage":
            return Optional.ofNullable(clazz.cast(linearPercentage()));
        case "linearInterval":
            return Optional.ofNullable(clazz.cast(linearInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedLinear, T> g) {
        return obj -> g.apply((TimeBasedLinear) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeBasedLinear> {
        /**
         * <p>
         * The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code>
         * deployment.
         * </p>
         * 
         * @param linearPercentage
         *        The percentage of traffic that is shifted at the start of each increment of a
         *        <code>TimeBasedLinear</code> deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linearPercentage(Integer linearPercentage);

        /**
         * <p>
         * The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.
         * </p>
         * 
         * @param linearInterval
         *        The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code>
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linearInterval(Integer linearInterval);
    }

    static final class BuilderImpl implements Builder {
        private Integer linearPercentage;

        private Integer linearInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedLinear model) {
            linearPercentage(model.linearPercentage);
            linearInterval(model.linearInterval);
        }

        public final Integer getLinearPercentage() {
            return linearPercentage;
        }

        @Override
        public final Builder linearPercentage(Integer linearPercentage) {
            this.linearPercentage = linearPercentage;
            return this;
        }

        public final void setLinearPercentage(Integer linearPercentage) {
            this.linearPercentage = linearPercentage;
        }

        public final Integer getLinearInterval() {
            return linearInterval;
        }

        @Override
        public final Builder linearInterval(Integer linearInterval) {
            this.linearInterval = linearInterval;
            return this;
        }

        public final void setLinearInterval(Integer linearInterval) {
            this.linearInterval = linearInterval;
        }

        @Override
        public TimeBasedLinear build() {
            return new TimeBasedLinear(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
