/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationInfo implements SdkPojo, Serializable, ToCopyableBuilder<ApplicationInfo.Builder, ApplicationInfo> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationInfo::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationInfo::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ApplicationInfo::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Boolean> LINKED_TO_GIT_HUB_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ApplicationInfo::linkedToGitHub)).setter(setter(Builder::linkedToGitHub))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedToGitHub").build()).build();

    private static final SdkField<String> GIT_HUB_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationInfo::gitHubAccountName)).setter(setter(Builder::gitHubAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitHubAccountName").build()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationInfo::computePlatformAsString)).setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_NAME_FIELD, CREATE_TIME_FIELD, LINKED_TO_GIT_HUB_FIELD, GIT_HUB_ACCOUNT_NAME_FIELD,
            COMPUTE_PLATFORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String applicationName;

    private final Instant createTime;

    private final Boolean linkedToGitHub;

    private final String gitHubAccountName;

    private final String computePlatform;

    private ApplicationInfo(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.createTime = builder.createTime;
        this.linkedToGitHub = builder.linkedToGitHub;
        this.gitHubAccountName = builder.gitHubAccountName;
        this.computePlatform = builder.computePlatform;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The time at which the application was created.
     * </p>
     * 
     * @return The time at which the application was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * True if the user has authenticated with GitHub for the specified application. Otherwise, false.
     * </p>
     * 
     * @return True if the user has authenticated with GitHub for the specified application. Otherwise, false.
     */
    public Boolean linkedToGitHub() {
        return linkedToGitHub;
    }

    /**
     * <p>
     * The name for a connection to a GitHub account.
     * </p>
     * 
     * @return The name for a connection to a GitHub account.
     */
    public String gitHubAccountName() {
        return gitHubAccountName;
    }

    /**
     * <p>
     * The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for deployment of the application (<code>Lambda</code> or
     *         <code>Server</code>).
     * @see ComputePlatform
     */
    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for deployment of the application (<code>Lambda</code> or
     *         <code>Server</code>).
     * @see ComputePlatform
     */
    public String computePlatformAsString() {
        return computePlatform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(linkedToGitHub());
        hashCode = 31 * hashCode + Objects.hashCode(gitHubAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationName(), other.applicationName()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(linkedToGitHub(), other.linkedToGitHub())
                && Objects.equals(gitHubAccountName(), other.gitHubAccountName())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationInfo").add("ApplicationId", applicationId())
                .add("ApplicationName", applicationName()).add("CreateTime", createTime())
                .add("LinkedToGitHub", linkedToGitHub()).add("GitHubAccountName", gitHubAccountName())
                .add("ComputePlatform", computePlatformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "linkedToGitHub":
            return Optional.ofNullable(clazz.cast(linkedToGitHub()));
        case "gitHubAccountName":
            return Optional.ofNullable(clazz.cast(gitHubAccountName()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationInfo, T> g) {
        return obj -> g.apply((ApplicationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationInfo> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The time at which the application was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * True if the user has authenticated with GitHub for the specified application. Otherwise, false.
         * </p>
         * 
         * @param linkedToGitHub
         *        True if the user has authenticated with GitHub for the specified application. Otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedToGitHub(Boolean linkedToGitHub);

        /**
         * <p>
         * The name for a connection to a GitHub account.
         * </p>
         * 
         * @param gitHubAccountName
         *        The name for a connection to a GitHub account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubAccountName(String gitHubAccountName);

        /**
         * <p>
         * The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for deployment of the application (<code>Lambda</code> or
         *        <code>Server</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for deployment of the application (<code>Lambda</code> or
         *        <code>Server</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String applicationName;

        private Instant createTime;

        private Boolean linkedToGitHub;

        private String gitHubAccountName;

        private String computePlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            applicationId(model.applicationId);
            applicationName(model.applicationName);
            createTime(model.createTime);
            linkedToGitHub(model.linkedToGitHub);
            gitHubAccountName(model.gitHubAccountName);
            computePlatform(model.computePlatform);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Boolean getLinkedToGitHub() {
            return linkedToGitHub;
        }

        @Override
        public final Builder linkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
            return this;
        }

        public final void setLinkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
        }

        public final String getGitHubAccountName() {
            return gitHubAccountName;
        }

        @Override
        public final Builder gitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
            return this;
        }

        public final void setGitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
        }

        public final String getComputePlatformAsString() {
            return computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
