/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateDeploymentConfig operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentConfigRequest extends CodeDeployRequest implements
        ToCopyableBuilder<CreateDeploymentConfigRequest.Builder, CreateDeploymentConfigRequest> {
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentConfigRequest::deploymentConfigName)).setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<MinimumHealthyHosts> MINIMUM_HEALTHY_HOSTS_FIELD = SdkField
            .<MinimumHealthyHosts> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDeploymentConfigRequest::minimumHealthyHosts)).setter(setter(Builder::minimumHealthyHosts))
            .constructor(MinimumHealthyHosts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHosts").build())
            .build();

    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIG_FIELD = SdkField
            .<TrafficRoutingConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDeploymentConfigRequest::trafficRoutingConfig)).setter(setter(Builder::trafficRoutingConfig))
            .constructor(TrafficRoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficRoutingConfig").build())
            .build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentConfigRequest::computePlatformAsString)).setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_NAME_FIELD,
            MINIMUM_HEALTHY_HOSTS_FIELD, TRAFFIC_ROUTING_CONFIG_FIELD, COMPUTE_PLATFORM_FIELD));

    private final String deploymentConfigName;

    private final MinimumHealthyHosts minimumHealthyHosts;

    private final TrafficRoutingConfig trafficRoutingConfig;

    private final String computePlatform;

    private CreateDeploymentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
        this.computePlatform = builder.computePlatform;
    }

    /**
     * <p>
     * The name of the deployment configuration to create.
     * </p>
     * 
     * @return The name of the deployment configuration to create.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The minimum number of healthy instances that should be available at any time during the deployment. There are two
     * parameters expected in the input: type and value.
     * </p>
     * <p>
     * The type parameter takes either of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
     * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS
     * CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * </p>
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * </p>
     * 
     * @return The minimum number of healthy instances that should be available at any time during the deployment. There
     *         are two parameters expected in the input: type and value.</p>
     *         <p>
     *         The type parameter takes either of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of
     *         the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
     *         deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up
     *         fractional instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The value parameter takes an integer.
     *         </p>
     *         <p>
     *         For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     */
    public MinimumHealthyHosts minimumHealthyHosts() {
        return minimumHealthyHosts;
    }

    /**
     * <p>
     * The configuration that specifies how the deployment traffic is routed.
     * </p>
     * 
     * @return The configuration that specifies how the deployment traffic is routed.
     */
    public TrafficRoutingConfig trafficRoutingConfig() {
        return trafficRoutingConfig;
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public String computePlatformAsString() {
        return computePlatform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(trafficRoutingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigRequest)) {
            return false;
        }
        CreateDeploymentConfigRequest other = (CreateDeploymentConfigRequest) obj;
        return Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(minimumHealthyHosts(), other.minimumHealthyHosts())
                && Objects.equals(trafficRoutingConfig(), other.trafficRoutingConfig())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentConfigRequest").add("DeploymentConfigName", deploymentConfigName())
                .add("MinimumHealthyHosts", minimumHealthyHosts()).add("TrafficRoutingConfig", trafficRoutingConfig())
                .add("ComputePlatform", computePlatformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "minimumHealthyHosts":
            return Optional.ofNullable(clazz.cast(minimumHealthyHosts()));
        case "trafficRoutingConfig":
            return Optional.ofNullable(clazz.cast(trafficRoutingConfig()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentConfigRequest, T> g) {
        return obj -> g.apply((CreateDeploymentConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentConfigRequest> {
        /**
         * <p>
         * The name of the deployment configuration to create.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of the deployment configuration to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The minimum number of healthy instances that should be available at any time during the deployment. There are
         * two parameters expected in the input: type and value.
         * </p>
         * <p>
         * The type parameter takes either of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
         * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
         * AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional
         * instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * </p>
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * </p>
         * 
         * @param minimumHealthyHosts
         *        The minimum number of healthy instances that should be available at any time during the deployment.
         *        There are two parameters expected in the input: type and value.</p>
         *        <p>
         *        The type parameter takes either of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute
         *        value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage
         *        of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
         *        deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up
         *        fractional instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The value parameter takes an integer.
         *        </p>
         *        <p>
         *        For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of
         *        95.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts);

        /**
         * <p>
         * The minimum number of healthy instances that should be available at any time during the deployment. There are
         * two parameters expected in the input: type and value.
         * </p>
         * <p>
         * The type parameter takes either of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
         * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
         * AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional
         * instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * </p>
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * </p>
         * This is a convenience that creates an instance of the {@link MinimumHealthyHosts.Builder} avoiding the need
         * to create one manually via {@link MinimumHealthyHosts#builder()}.
         *
         * When the {@link Consumer} completes, {@link MinimumHealthyHosts.Builder#build()} is called immediately and
         * its result is passed to {@link #minimumHealthyHosts(MinimumHealthyHosts)}.
         * 
         * @param minimumHealthyHosts
         *        a consumer that will call methods on {@link MinimumHealthyHosts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumHealthyHosts(MinimumHealthyHosts)
         */
        default Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return minimumHealthyHosts(MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts).build());
        }

        /**
         * <p>
         * The configuration that specifies how the deployment traffic is routed.
         * </p>
         * 
         * @param trafficRoutingConfig
         *        The configuration that specifies how the deployment traffic is routed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig);

        /**
         * <p>
         * The configuration that specifies how the deployment traffic is routed.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficRoutingConfig.Builder} avoiding the need
         * to create one manually via {@link TrafficRoutingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficRoutingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficRoutingConfig(TrafficRoutingConfig)}.
         * 
         * @param trafficRoutingConfig
         *        a consumer that will call methods on {@link TrafficRoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficRoutingConfig(TrafficRoutingConfig)
         */
        default Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return trafficRoutingConfig(TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig).build());
        }

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentConfigName;

        private MinimumHealthyHosts minimumHealthyHosts;

        private TrafficRoutingConfig trafficRoutingConfig;

        private String computePlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigRequest model) {
            super(model);
            deploymentConfigName(model.deploymentConfigName);
            minimumHealthyHosts(model.minimumHealthyHosts);
            trafficRoutingConfig(model.trafficRoutingConfig);
            computePlatform(model.computePlatform);
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return minimumHealthyHosts != null ? minimumHealthyHosts.toBuilder() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return trafficRoutingConfig != null ? trafficRoutingConfig.toBuilder() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        public final String getComputePlatformAsString() {
            return computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentConfigRequest build() {
            return new CreateDeploymentConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
