/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about groups of on-premises instance tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnPremisesTagSet implements SdkPojo, Serializable,
        ToCopyableBuilder<OnPremisesTagSet.Builder, OnPremisesTagSet> {
    private static final SdkField<List<List<TagFilter>>> ON_PREMISES_TAG_SET_LIST_FIELD = SdkField
            .<List<List<TagFilter>>> builder(MarshallingType.LIST)
            .memberName("onPremisesTagSetList")
            .getter(getter(OnPremisesTagSet::onPremisesTagSetList))
            .setter(setter(Builder::onPremisesTagSetList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSetList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<TagFilter>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(TagFilter::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ON_PREMISES_TAG_SET_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<List<TagFilter>> onPremisesTagSetList;

    private OnPremisesTagSet(BuilderImpl builder) {
        this.onPremisesTagSetList = builder.onPremisesTagSetList;
    }

    /**
     * Returns true if the OnPremisesTagSetList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOnPremisesTagSetList() {
        return onPremisesTagSetList != null && !(onPremisesTagSetList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains other lists of on-premises instance tag groups. For an instance to be included in the
     * deployment group, it must be identified by all of the tag groups in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOnPremisesTagSetList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains other lists of on-premises instance tag groups. For an instance to be included in
     *         the deployment group, it must be identified by all of the tag groups in the list.
     */
    public final List<List<TagFilter>> onPremisesTagSetList() {
        return onPremisesTagSetList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOnPremisesTagSetList() ? onPremisesTagSetList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnPremisesTagSet)) {
            return false;
        }
        OnPremisesTagSet other = (OnPremisesTagSet) obj;
        return hasOnPremisesTagSetList() == other.hasOnPremisesTagSetList()
                && Objects.equals(onPremisesTagSetList(), other.onPremisesTagSetList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnPremisesTagSet")
                .add("OnPremisesTagSetList", hasOnPremisesTagSetList() ? onPremisesTagSetList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "onPremisesTagSetList":
            return Optional.ofNullable(clazz.cast(onPremisesTagSetList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnPremisesTagSet, T> g) {
        return obj -> g.apply((OnPremisesTagSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnPremisesTagSet> {
        /**
         * <p>
         * A list that contains other lists of on-premises instance tag groups. For an instance to be included in the
         * deployment group, it must be identified by all of the tag groups in the list.
         * </p>
         * 
         * @param onPremisesTagSetList
         *        A list that contains other lists of on-premises instance tag groups. For an instance to be included in
         *        the deployment group, it must be identified by all of the tag groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesTagSetList(Collection<? extends Collection<TagFilter>> onPremisesTagSetList);

        /**
         * <p>
         * A list that contains other lists of on-premises instance tag groups. For an instance to be included in the
         * deployment group, it must be identified by all of the tag groups in the list.
         * </p>
         * 
         * @param onPremisesTagSetList
         *        A list that contains other lists of on-premises instance tag groups. For an instance to be included in
         *        the deployment group, it must be identified by all of the tag groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesTagSetList(Collection<TagFilter>... onPremisesTagSetList);
    }

    static final class BuilderImpl implements Builder {
        private List<List<TagFilter>> onPremisesTagSetList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OnPremisesTagSet model) {
            onPremisesTagSetList(model.onPremisesTagSetList);
        }

        public final List<List<TagFilter.Builder>> getOnPremisesTagSetList() {
            List<List<TagFilter.Builder>> result = OnPremisesTagSetListCopier.copyToBuilder(this.onPremisesTagSetList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder onPremisesTagSetList(Collection<? extends Collection<TagFilter>> onPremisesTagSetList) {
            this.onPremisesTagSetList = OnPremisesTagSetListCopier.copy(onPremisesTagSetList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesTagSetList(Collection<TagFilter>... onPremisesTagSetList) {
            onPremisesTagSetList(Arrays.asList(onPremisesTagSetList));
            return this;
        }

        public final void setOnPremisesTagSetList(Collection<? extends Collection<TagFilter.BuilderImpl>> onPremisesTagSetList) {
            this.onPremisesTagSetList = OnPremisesTagSetListCopier.copyFromBuilder(onPremisesTagSetList);
        }

        @Override
        public OnPremisesTagSet build() {
            return new OnPremisesTagSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
