/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListOnPremisesInstances</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOnPremisesInstancesRequest extends CodeDeployRequest implements
        ToCopyableBuilder<ListOnPremisesInstancesRequest.Builder, ListOnPremisesInstancesRequest> {
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationStatus").getter(getter(ListOnPremisesInstancesRequest::registrationStatusAsString))
            .setter(setter(Builder::registrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build())
            .build();

    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("tagFilters")
            .getter(getter(ListOnPremisesInstancesRequest::tagFilters))
            .setter(setter(Builder::tagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListOnPremisesInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_STATUS_FIELD,
            TAG_FILTERS_FIELD, NEXT_TOKEN_FIELD));

    private final String registrationStatus;

    private final List<TagFilter> tagFilters;

    private final String nextToken;

    private ListOnPremisesInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.registrationStatus = builder.registrationStatus;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The registration status of the on-premises instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Registered</code>: Include registered on-premises instances in the resulting list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The registration status of the on-premises instances:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Registered</code>: Include registered on-premises instances in the resulting list.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(registrationStatus);
    }

    /**
     * <p>
     * The registration status of the on-premises instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Registered</code>: Include registered on-premises instances in the resulting list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The registration status of the on-premises instances:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Registered</code>: Include registered on-premises instances in the resulting list.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final String registrationStatusAsString() {
        return registrationStatus;
    }

    /**
     * Returns true if the TagFilters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagFilters() {
        return tagFilters != null && !(tagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The on-premises instance tags that are used to restrict the on-premises instance names returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The on-premises instance tags that are used to restrict the on-premises instance names returned.
     */
    public final List<TagFilter> tagFilters() {
        return tagFilters;
    }

    /**
     * <p>
     * An identifier returned from the previous list on-premises instances call. It can be used to return the next set
     * of on-premises instances in the list.
     * </p>
     * 
     * @return An identifier returned from the previous list on-premises instances call. It can be used to return the
     *         next set of on-premises instances in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagFilters() ? tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesRequest)) {
            return false;
        }
        ListOnPremisesInstancesRequest other = (ListOnPremisesInstancesRequest) obj;
        return Objects.equals(registrationStatusAsString(), other.registrationStatusAsString())
                && hasTagFilters() == other.hasTagFilters() && Objects.equals(tagFilters(), other.tagFilters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOnPremisesInstancesRequest").add("RegistrationStatus", registrationStatusAsString())
                .add("TagFilters", hasTagFilters() ? tagFilters() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registrationStatus":
            return Optional.ofNullable(clazz.cast(registrationStatusAsString()));
        case "tagFilters":
            return Optional.ofNullable(clazz.cast(tagFilters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOnPremisesInstancesRequest, T> g) {
        return obj -> g.apply((ListOnPremisesInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOnPremisesInstancesRequest> {
        /**
         * <p>
         * The registration status of the on-premises instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Registered</code>: Include registered on-premises instances in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationStatus
         *        The registration status of the on-premises instances:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Registered</code>: Include registered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The registration status of the on-premises instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Registered</code>: Include registered on-premises instances in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationStatus
         *        The registration status of the on-premises instances:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Registered</code>: Include registered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * The on-premises instance tags that are used to restrict the on-premises instance names returned.
         * </p>
         * 
         * @param tagFilters
         *        The on-premises instance tags that are used to restrict the on-premises instance names returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<TagFilter> tagFilters);

        /**
         * <p>
         * The on-premises instance tags that are used to restrict the on-premises instance names returned.
         * </p>
         * 
         * @param tagFilters
         *        The on-premises instance tags that are used to restrict the on-premises instance names returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(TagFilter... tagFilters);

        /**
         * <p>
         * The on-premises instance tags that are used to restrict the on-premises instance names returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagFilter>.Builder} avoiding the need to
         * create one manually via {@link List<TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #tagFilters(List<TagFilter>)}.
         * 
         * @param tagFilters
         *        a consumer that will call methods on {@link List<TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilters(List<TagFilter>)
         */
        Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters);

        /**
         * <p>
         * An identifier returned from the previous list on-premises instances call. It can be used to return the next
         * set of on-premises instances in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous list on-premises instances call. It can be used to return the
         *        next set of on-premises instances in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String registrationStatus;

        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesRequest model) {
            super(model);
            registrationStatus(model.registrationStatus);
            tagFilters(model.tagFilters);
            nextToken(model.nextToken);
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        public final List<TagFilter.Builder> getTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter... tagFilters) {
            tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters) {
            tagFilters(Stream.of(tagFilters).map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOnPremisesInstancesRequest build() {
            return new ListOnPremisesInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
