/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.TriggerEventType;
import software.amazon.awssdk.services.codedeploy.model.TriggerEventTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerConfig> {
    private static final SdkField<String> TRIGGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerName").getter(TriggerConfig.getter(TriggerConfig::triggerName)).setter(TriggerConfig.setter(Builder::triggerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerName").build()}).build();
    private static final SdkField<String> TRIGGER_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerTargetArn").getter(TriggerConfig.getter(TriggerConfig::triggerTargetArn)).setter(TriggerConfig.setter(Builder::triggerTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerTargetArn").build()}).build();
    private static final SdkField<List<String>> TRIGGER_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggerEvents").getter(TriggerConfig.getter(TriggerConfig::triggerEventsAsStrings)).setter(TriggerConfig.setter(Builder::triggerEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_NAME_FIELD, TRIGGER_TARGET_ARN_FIELD, TRIGGER_EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String triggerName;
    private final String triggerTargetArn;
    private final List<String> triggerEvents;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerName = builder.triggerName;
        this.triggerTargetArn = builder.triggerTargetArn;
        this.triggerEvents = builder.triggerEvents;
    }

    public final String triggerName() {
        return this.triggerName;
    }

    public final String triggerTargetArn() {
        return this.triggerTargetArn;
    }

    public final List<TriggerEventType> triggerEvents() {
        return TriggerEventTypeListCopier.copyStringToEnum(this.triggerEvents);
    }

    public final boolean hasTriggerEvents() {
        return this.triggerEvents != null && !(this.triggerEvents instanceof SdkAutoConstructList);
    }

    public final List<String> triggerEventsAsStrings() {
        return this.triggerEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggerEvents() ? this.triggerEventsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig)obj;
        return Objects.equals(this.triggerName(), other.triggerName()) && Objects.equals(this.triggerTargetArn(), other.triggerTargetArn()) && this.hasTriggerEvents() == other.hasTriggerEvents() && Objects.equals(this.triggerEventsAsStrings(), other.triggerEventsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TriggerConfig").add("TriggerName", (Object)this.triggerName()).add("TriggerTargetArn", (Object)this.triggerTargetArn()).add("TriggerEvents", this.hasTriggerEvents() ? this.triggerEventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "triggerName": {
                return Optional.ofNullable(clazz.cast(this.triggerName()));
            }
            case "triggerTargetArn": {
                return Optional.ofNullable(clazz.cast(this.triggerTargetArn()));
            }
            case "triggerEvents": {
                return Optional.ofNullable(clazz.cast(this.triggerEventsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerConfig, T> g) {
        return obj -> g.apply((TriggerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String triggerName;
        private String triggerTargetArn;
        private List<String> triggerEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            this.triggerName(model.triggerName);
            this.triggerTargetArn(model.triggerTargetArn);
            this.triggerEventsWithStrings(model.triggerEvents);
        }

        public final String getTriggerName() {
            return this.triggerName;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        @Override
        @Transient
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final String getTriggerTargetArn() {
            return this.triggerTargetArn;
        }

        public final void setTriggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
        }

        @Override
        @Transient
        public final Builder triggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
            return this;
        }

        public final Collection<String> getTriggerEvents() {
            if (this.triggerEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.triggerEvents;
        }

        public final void setTriggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
        }

        @Override
        @Transient
        public final Builder triggerEventsWithStrings(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggerEventsWithStrings(String ... triggerEvents) {
            this.triggerEventsWithStrings(Arrays.asList(triggerEvents));
            return this;
        }

        @Override
        @Transient
        public final Builder triggerEvents(Collection<TriggerEventType> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copyEnumToString(triggerEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggerEvents(TriggerEventType ... triggerEvents) {
            this.triggerEvents(Arrays.asList(triggerEvents));
            return this;
        }

        public TriggerConfig build() {
            return new TriggerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerConfig> {
        public Builder triggerName(String var1);

        public Builder triggerTargetArn(String var1);

        public Builder triggerEventsWithStrings(Collection<String> var1);

        public Builder triggerEventsWithStrings(String ... var1);

        public Builder triggerEvents(Collection<TriggerEventType> var1);

        public Builder triggerEvents(TriggerEventType ... var1);
    }
}

