/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instances to be used in the replacement environment in a blue/green deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetInstances implements SdkPojo, Serializable, ToCopyableBuilder<TargetInstances.Builder, TargetInstances> {
    private static final SdkField<List<EC2TagFilter>> TAG_FILTERS_FIELD = SdkField
            .<List<EC2TagFilter>> builder(MarshallingType.LIST)
            .memberName("tagFilters")
            .getter(getter(TargetInstances::tagFilters))
            .setter(setter(Builder::tagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoScalingGroups")
            .getter(getter(TargetInstances::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.<EC2TagSet> builder(MarshallingType.SDK_POJO)
            .memberName("ec2TagSet").getter(getter(TargetInstances::ec2TagSet)).setter(setter(Builder::ec2TagSet))
            .constructor(EC2TagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FILTERS_FIELD,
            AUTO_SCALING_GROUPS_FIELD, EC2_TAG_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EC2TagFilter> tagFilters;

    private final List<String> autoScalingGroups;

    private final EC2TagSet ec2TagSet;

    private TargetInstances(BuilderImpl builder) {
        this.tagFilters = builder.tagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.ec2TagSet = builder.ec2TagSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagFilters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagFilters() {
        return tagFilters != null && !(tagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
     * blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagFilters} method.
     * </p>
     * 
     * @return The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment
     *         for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
     */
    public final List<EC2TagFilter> tagFilters() {
        return tagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoScalingGroups() {
        return autoScalingGroups != null && !(autoScalingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingGroups} method.
     * </p>
     * 
     * @return The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
     *         deployment.
     */
    public final List<String> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * Information about the groups of EC2 instance tags that an instance must be identified by in order for it to be
     * included in the replacement environment for a blue/green deployment. Cannot be used in the same call as
     * <code>tagFilters</code>.
     * </p>
     * 
     * @return Information about the groups of EC2 instance tags that an instance must be identified by in order for it
     *         to be included in the replacement environment for a blue/green deployment. Cannot be used in the same
     *         call as <code>tagFilters</code>.
     */
    public final EC2TagSet ec2TagSet() {
        return ec2TagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTagFilters() ? tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroups() ? autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstances)) {
            return false;
        }
        TargetInstances other = (TargetInstances) obj;
        return hasTagFilters() == other.hasTagFilters() && Objects.equals(tagFilters(), other.tagFilters())
                && hasAutoScalingGroups() == other.hasAutoScalingGroups()
                && Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(ec2TagSet(), other.ec2TagSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetInstances").add("TagFilters", hasTagFilters() ? tagFilters() : null)
                .add("AutoScalingGroups", hasAutoScalingGroups() ? autoScalingGroups() : null).add("Ec2TagSet", ec2TagSet())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tagFilters":
            return Optional.ofNullable(clazz.cast(tagFilters()));
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "ec2TagSet":
            return Optional.ofNullable(clazz.cast(ec2TagSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetInstances, T> g) {
        return obj -> g.apply((TargetInstances) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetInstances> {
        /**
         * <p>
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
         * blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
         * </p>
         * 
         * @param tagFilters
         *        The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment
         *        for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<EC2TagFilter> tagFilters);

        /**
         * <p>
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
         * blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
         * </p>
         * 
         * @param tagFilters
         *        The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment
         *        for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(EC2TagFilter... tagFilters);

        /**
         * <p>
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
         * blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EC2TagFilter>.Builder} avoiding the
         * need to create one manually via {@link List<EC2TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #tagFilters(List<EC2TagFilter>)}.
         * 
         * @param tagFilters
         *        a consumer that will call methods on {@link List<EC2TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilters(List<EC2TagFilter>)
         */
        Builder tagFilters(Consumer<EC2TagFilter.Builder>... tagFilters);

        /**
         * <p>
         * The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         * deployment.
         * </p>
         * 
         * @param autoScalingGroups
         *        The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<String> autoScalingGroups);

        /**
         * <p>
         * The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         * deployment.
         * </p>
         * 
         * @param autoScalingGroups
         *        The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(String... autoScalingGroups);

        /**
         * <p>
         * Information about the groups of EC2 instance tags that an instance must be identified by in order for it to
         * be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as
         * <code>tagFilters</code>.
         * </p>
         * 
         * @param ec2TagSet
         *        Information about the groups of EC2 instance tags that an instance must be identified by in order for
         *        it to be included in the replacement environment for a blue/green deployment. Cannot be used in the
         *        same call as <code>tagFilters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSet(EC2TagSet ec2TagSet);

        /**
         * <p>
         * Information about the groups of EC2 instance tags that an instance must be identified by in order for it to
         * be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as
         * <code>tagFilters</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EC2TagSet.Builder} avoiding the need to
         * create one manually via {@link EC2TagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2TagSet.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2TagSet(EC2TagSet)}.
         * 
         * @param ec2TagSet
         *        a consumer that will call methods on {@link EC2TagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagSet(EC2TagSet)
         */
        default Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return ec2TagSet(EC2TagSet.builder().applyMutation(ec2TagSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EC2TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private EC2TagSet ec2TagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstances model) {
            tagFilters(model.tagFilters);
            autoScalingGroups(model.autoScalingGroups);
            ec2TagSet(model.ec2TagSet);
        }

        public final List<EC2TagFilter.Builder> getTagFilters() {
            List<EC2TagFilter.Builder> result = EC2TagFilterListCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagFilters(Collection<EC2TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public final Builder tagFilters(Collection<EC2TagFilter> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(EC2TagFilter... tagFilters) {
            tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<EC2TagFilter.Builder>... tagFilters) {
            tagFilters(Stream.of(tagFilters).map(c -> EC2TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAutoScalingGroups() {
            if (autoScalingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingGroups;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return ec2TagSet != null ? ec2TagSet.toBuilder() : null;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        @Override
        public TargetInstances build() {
            return new TargetInstances(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
