/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetDeployment</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentResponse extends CodeDeployResponse implements
        ToCopyableBuilder<GetDeploymentResponse.Builder, GetDeploymentResponse> {
    private static final SdkField<DeploymentInfo> DEPLOYMENT_INFO_FIELD = SdkField
            .<DeploymentInfo> builder(MarshallingType.SDK_POJO).memberName("deploymentInfo")
            .getter(getter(GetDeploymentResponse::deploymentInfo)).setter(setter(Builder::deploymentInfo))
            .constructor(DeploymentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_INFO_FIELD));

    private final DeploymentInfo deploymentInfo;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentInfo = builder.deploymentInfo;
    }

    /**
     * <p>
     * Information about the deployment.
     * </p>
     * 
     * @return Information about the deployment.
     */
    public final DeploymentInfo deploymentInfo() {
        return deploymentInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse) obj;
        return Objects.equals(deploymentInfo(), other.deploymentInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentResponse").add("DeploymentInfo", deploymentInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentInfo":
            return Optional.ofNullable(clazz.cast(deploymentInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentResponse> {
        /**
         * <p>
         * Information about the deployment.
         * </p>
         * 
         * @param deploymentInfo
         *        Information about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentInfo(DeploymentInfo deploymentInfo);

        /**
         * <p>
         * Information about the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentInfo.Builder} avoiding the need
         * to create one manually via {@link DeploymentInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentInfo(DeploymentInfo)}.
         * 
         * @param deploymentInfo
         *        a consumer that will call methods on {@link DeploymentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentInfo(DeploymentInfo)
         */
        default Builder deploymentInfo(Consumer<DeploymentInfo.Builder> deploymentInfo) {
            return deploymentInfo(DeploymentInfo.builder().applyMutation(deploymentInfo).build());
        }
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private DeploymentInfo deploymentInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            deploymentInfo(model.deploymentInfo);
        }

        public final DeploymentInfo.Builder getDeploymentInfo() {
            return deploymentInfo != null ? deploymentInfo.toBuilder() : null;
        }

        public final void setDeploymentInfo(DeploymentInfo.BuilderImpl deploymentInfo) {
            this.deploymentInfo = deploymentInfo != null ? deploymentInfo.build() : null;
        }

        @Override
        public final Builder deploymentInfo(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
            return this;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
