/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetDeploymentGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentGroupResponse extends CodeDeployResponse implements
        ToCopyableBuilder<GetDeploymentGroupResponse.Builder, GetDeploymentGroupResponse> {
    private static final SdkField<DeploymentGroupInfo> DEPLOYMENT_GROUP_INFO_FIELD = SdkField
            .<DeploymentGroupInfo> builder(MarshallingType.SDK_POJO).memberName("deploymentGroupInfo")
            .getter(getter(GetDeploymentGroupResponse::deploymentGroupInfo)).setter(setter(Builder::deploymentGroupInfo))
            .constructor(DeploymentGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_GROUP_INFO_FIELD));

    private final DeploymentGroupInfo deploymentGroupInfo;

    private GetDeploymentGroupResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentGroupInfo = builder.deploymentGroupInfo;
    }

    /**
     * <p>
     * Information about the deployment group.
     * </p>
     * 
     * @return Information about the deployment group.
     */
    public final DeploymentGroupInfo deploymentGroupInfo() {
        return deploymentGroupInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentGroupResponse)) {
            return false;
        }
        GetDeploymentGroupResponse other = (GetDeploymentGroupResponse) obj;
        return Objects.equals(deploymentGroupInfo(), other.deploymentGroupInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentGroupResponse").add("DeploymentGroupInfo", deploymentGroupInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentGroupInfo":
            return Optional.ofNullable(clazz.cast(deploymentGroupInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentGroupResponse, T> g) {
        return obj -> g.apply((GetDeploymentGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentGroupResponse> {
        /**
         * <p>
         * Information about the deployment group.
         * </p>
         * 
         * @param deploymentGroupInfo
         *        Information about the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupInfo(DeploymentGroupInfo deploymentGroupInfo);

        /**
         * <p>
         * Information about the deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentGroupInfo.Builder} avoiding the
         * need to create one manually via {@link DeploymentGroupInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentGroupInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentGroupInfo(DeploymentGroupInfo)}.
         * 
         * @param deploymentGroupInfo
         *        a consumer that will call methods on {@link DeploymentGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentGroupInfo(DeploymentGroupInfo)
         */
        default Builder deploymentGroupInfo(Consumer<DeploymentGroupInfo.Builder> deploymentGroupInfo) {
            return deploymentGroupInfo(DeploymentGroupInfo.builder().applyMutation(deploymentGroupInfo).build());
        }
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private DeploymentGroupInfo deploymentGroupInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentGroupResponse model) {
            super(model);
            deploymentGroupInfo(model.deploymentGroupInfo);
        }

        public final DeploymentGroupInfo.Builder getDeploymentGroupInfo() {
            return deploymentGroupInfo != null ? deploymentGroupInfo.toBuilder() : null;
        }

        public final void setDeploymentGroupInfo(DeploymentGroupInfo.BuilderImpl deploymentGroupInfo) {
            this.deploymentGroupInfo = deploymentGroupInfo != null ? deploymentGroupInfo.build() : null;
        }

        @Override
        public final Builder deploymentGroupInfo(DeploymentGroupInfo deploymentGroupInfo) {
            this.deploymentGroupInfo = deploymentGroupInfo;
            return this;
        }

        @Override
        public GetDeploymentGroupResponse build() {
            return new GetDeploymentGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
